/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.zdoc.markdown;

import org.nutz.json.Json;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.zdoc.NutD;
import org.nutz.plugins.zdoc.NutDSet;
import org.nutz.plugins.zdoc.NutDSetParser;
import org.nutz.plugins.zdoc.NutDoc;
import org.nutz.plugins.zdoc.markdown.MarkdownDocParser;

public abstract class AbstractMarkdownDSetParser
implements NutDSetParser {
    private static final Log log = Logs.get();

    protected abstract NutMap loadConfig(NutDSet var1, String var2, String var3);

    protected abstract void checkPath(NutDSet var1, String var2);

    protected abstract void loadTreeByPaths(NutDSet var1, String var2);

    protected abstract void loadTreeByRecur(NutDSet var1);

    protected void loadTreeByPath(NutDSet home, String path) {
    }

    @Override
    public void parse(NutDSet home, String path, String configPath) {
        log.infof("checkPath: %s", new Object[]{path});
        this.checkPath(home, path);
        log.infof("loadConfig: %s", new Object[]{configPath});
        NutMap conf = this.loadConfig(home, path, configPath);
        String paths = conf.getString("paths");
        if (!Strings.isBlank((CharSequence)paths)) {
            log.info((Object)"loadTreeByPaths:");
            this.loadTreeByPaths(home, paths);
        } else {
            log.info((Object)"loadTreeByRecur:");
            this.loadTreeByRecur(home);
        }
        conf.remove((Object)"paths");
        for (String key : conf.keySet()) {
            if (key == null || key.startsWith("_")) continue;
            home.getMeta().put((Object)key, conf.get((Object)key));
        }
        log.info((Object)Json.toJson((Object)home.getMeta()));
        for (NutD d : home.getChildren()) {
            this.__parse_it(d);
        }
    }

    private void __parse_it(NutD d) {
        if (d instanceof NutDoc) {
            MarkdownDocParser dp = new MarkdownDocParser();
            NutDoc doc = (NutDoc)d;
            log.info((Object)(" - parse : " + doc.getPath()));
            dp.parse(doc);
        } else if (d instanceof NutDSet) {
            for (NutD d2 : ((NutDSet)d).getChildren()) {
                this.__parse_it(d2);
            }
        } else {
            throw Lang.impossible();
        }
    }
}

