/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.zdoc.msword;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.nutz.img.Images;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.plugins.zdoc.NutDSet;
import org.nutz.plugins.zdoc.msword.AbstractMsWordDSetRender;
import org.nutz.plugins.zdoc.msword.MsWordImageInfo;

public class LocalMsWordDSetRender
extends AbstractMsWordDSetRender {
    private File dSrc;
    private File fTa;

    @Override
    protected MsWordImageInfo readPictureInfo(String aph, boolean openStream) {
        MsWordImageInfo mwii = new MsWordImageInfo();
        File fImg = Files.getFile((File)this.dSrc, (String)aph);
        if (!fImg.exists()) {
            throw Lang.makeThrow((String)"e.zdoc.msword.imgnoexist : %s", (Object[])new Object[]{aph});
        }
        String suffixName = Files.getSuffixName((String)aph);
        if (suffixName == null) {
            throw Lang.makeThrow((String)"e.zdoc.msword.imgnotype : %s", (Object[])new Object[]{aph});
        }
        String imgType = suffixName.toLowerCase();
        if (imgType.equals("jpg") || imgType.equals("jpeg")) {
            mwii.pictureType = 5;
        } else if (imgType.equals("gif")) {
            mwii.pictureType = 8;
        } else if (imgType.equals("png")) {
            mwii.pictureType = 6;
        } else {
            throw Lang.makeThrow((String)"e.zdoc.msword.invalidImageType : %s", (Object[])new Object[]{aph});
        }
        BufferedImage im = Images.read((Object)fImg);
        mwii.fileName = Files.getName((String)aph);
        mwii.width = im.getWidth();
        mwii.height = im.getHeight();
        if (openStream) {
            mwii.ins = Streams.buff((InputStream)Streams.fileIn((File)fImg));
        }
        return mwii;
    }

    @Override
    protected void writeToTarget(XWPFDocument wdDoc) {
        BufferedOutputStream ops = Streams.buff((OutputStream)Streams.fileOut((File)this.fTa));
        try {
            try {
                wdDoc.write((OutputStream)ops);
            }
            catch (IOException e) {
                throw Lang.wrapThrow((Throwable)e);
            }
        }
        finally {
            Streams.safeClose((Closeable)ops);
        }
    }

    @Override
    protected void checkTarget(String target) {
        this.fTa = Files.createFileIfNoExists2((String)target);
    }

    @Override
    protected void checkPrimerObj(NutDSet ds) {
        this.dSrc = (File)ds.getPrimerObj();
        if (this.dSrc == null || !this.dSrc.exists() || !this.dSrc.isDirectory()) {
            throw Lang.makeThrow((String)"e.zdoc.html.render.dsrc_invalid", (Object[])new Object[]{this.dSrc});
        }
    }
}

