/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch.jgss;

import com.jcraft.jsch.GSSContext;
import com.jcraft.jsch.JSchException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;

public class GSSContextKrb5
implements GSSContext {
    private org.ietf.jgss.GSSContext context = null;

    public void create(String string, String string2) throws JSchException {
        try {
            Oid oid = new Oid("1.2.840.113554.1.2.2");
            Oid oid2 = new Oid("1.2.840.113554.1.2.2.1");
            GSSManager gSSManager = GSSManager.getInstance();
            GSSCredential gSSCredential = null;
            String string3 = string2;
            try {
                string3 = InetAddress.getByName(string3).getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            GSSName gSSName = gSSManager.createName("host/" + string3, oid2);
            this.context = gSSManager.createContext(gSSName, oid, gSSCredential, 0);
            this.context.requestMutualAuth(true);
            this.context.requestConf(true);
            this.context.requestInteg(true);
            this.context.requestCredDeleg(true);
            this.context.requestAnonymity(false);
            return;
        }
        catch (GSSException gSSException) {
            throw new JSchException(gSSException.toString());
        }
    }

    public boolean isEstablished() {
        return this.context.isEstablished();
    }

    public byte[] init(byte[] byArray, int n, int n2) throws JSchException {
        try {
            return this.context.initSecContext(byArray, 0, n2);
        }
        catch (GSSException gSSException) {
            throw new JSchException(gSSException.toString());
        }
    }

    public byte[] getMIC(byte[] byArray, int n, int n2) {
        try {
            MessageProp messageProp = new MessageProp(0, true);
            return this.context.getMIC(byArray, n, n2, messageProp);
        }
        catch (GSSException gSSException) {
            return null;
        }
    }

    public void dispose() {
        try {
            this.context.dispose();
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
    }
}

