/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.connection.ChannelDataWindow;
import com.sshtools.j2ssh.connection.ChannelEventListener;
import com.sshtools.j2ssh.connection.ChannelState;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.SshMsgChannelData;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Channel {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$connection$Channel == null ? (class$com$sshtools$j2ssh$connection$Channel = Channel.class$("com.sshtools.j2ssh.connection.Channel")) : class$com$sshtools$j2ssh$connection$Channel);
    protected ChannelDataWindow localWindow = new ChannelDataWindow();
    protected ChannelDataWindow remoteWindow = new ChannelDataWindow();
    protected ConnectionProtocol connection;
    protected long localChannelId;
    protected long localPacketSize;
    protected long remoteChannelId;
    protected long remotePacketSize;
    protected ChannelState state = new ChannelState();
    private boolean isClosed = false;
    private boolean isLocalEOF = false;
    private boolean isRemoteEOF = false;
    private boolean localHasClosed = false;
    private boolean remoteHasClosed = false;
    private String name = "Unnamed Channel";
    private Vector eventListeners = new Vector();
    static /* synthetic */ Class class$com$sshtools$j2ssh$connection$Channel;

    public Channel() {
        this.localPacketSize = this.getMaximumPacketSize();
        this.localWindow.increaseWindowSpace(this.getMaximumWindowSpace());
    }

    public abstract byte[] getChannelOpenData();

    public abstract byte[] getChannelConfirmationData();

    public abstract String getChannelType();

    protected abstract int getMinimumWindowSpace();

    protected abstract int getMaximumWindowSpace();

    protected abstract int getMaximumPacketSize();

    protected abstract void onChannelData(SshMsgChannelData var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChannelData(SshMsgChannelData sshMsgChannelData) throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (!this.isClosed()) {
                if (sshMsgChannelData.getChannelDataLength() > this.localWindow.getWindowSpace()) {
                    throw new IOException("More data recieved than is allowed by the channel data window [" + this.name + "]");
                }
                long l = this.localWindow.consumeWindowSpace(sshMsgChannelData.getChannelData().length);
                if (l < (long)this.getMinimumWindowSpace()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.name + "]");
                    }
                    l = (long)this.getMaximumWindowSpace() - l;
                    log.debug("Requesting connection protocol increase window");
                    this.connection.sendChannelWindowAdjust(this, l);
                    this.localWindow.increaseWindowSpace(l);
                }
                this.onChannelData(sshMsgChannelData);
                Iterator iterator = this.eventListeners.iterator();
                while (iterator.hasNext()) {
                    ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                    if (channelEventListener == null) continue;
                    channelEventListener.onDataReceived(this, sshMsgChannelData.getChannelData());
                }
            } else {
                throw new IOException("Channel data received but channel is closed [" + this.name + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            return this.state.getValue() == 2;
        }
    }

    protected void sendChannelData(byte[] byArray) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.name + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelData(this, byArray);
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, byArray);
            }
        } else {
            throw new IOException("The channel is closed [" + this.name + "]");
        }
    }

    protected void sendChannelExtData(int n, byte[] byArray) throws IOException {
        if (!this.connection.isConnected()) {
            throw new IOException("The connection has been closed [" + this.name + "]");
        }
        if (!this.isClosed()) {
            this.connection.sendChannelExtData(this, n, byArray);
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataSent(this, byArray);
            }
        } else {
            throw new IOException("The channel is closed [" + this.name + "]");
        }
    }

    protected abstract void onChannelExtData(SshMsgChannelExtendedData var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processChannelData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if ((long)sshMsgChannelExtendedData.getChannelData().length > this.localWindow.getWindowSpace()) {
                throw new IOException("More data recieved than is allowed by the channel data window [" + this.name + "]");
            }
            long l = this.localWindow.consumeWindowSpace(sshMsgChannelExtendedData.getChannelData().length);
            if (l < (long)this.getMinimumWindowSpace()) {
                if (log.isDebugEnabled()) {
                    log.debug("Channel " + String.valueOf(this.localChannelId) + " requires more window space [" + this.name + "]");
                }
                l = (long)this.getMaximumWindowSpace() - l;
                this.connection.sendChannelWindowAdjust(this, l);
                this.localWindow.increaseWindowSpace(l);
            }
            this.onChannelExtData(sshMsgChannelExtendedData);
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onDataReceived(this, sshMsgChannelExtendedData.getChannelData());
            }
        }
    }

    public long getLocalChannelId() {
        return this.localChannelId;
    }

    public long getLocalPacketSize() {
        return this.localPacketSize;
    }

    public ChannelDataWindow getLocalWindow() {
        return this.localWindow;
    }

    public long getRemoteChannelId() {
        return this.remoteChannelId;
    }

    public long getRemotePacketSize() {
        return this.remotePacketSize;
    }

    public ChannelDataWindow getRemoteWindow() {
        return this.remoteWindow;
    }

    public ChannelState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            if (this.isOpen()) {
                if (this.connection != null && !this.localHasClosed && this.connection.isConnected()) {
                    this.connection.closeChannel(this);
                }
                this.localHasClosed = true;
                if (log.isDebugEnabled()) {
                    log.debug("Connection is " + (this.connection == null ? "null" : (this.connection.isConnected() ? "connected" : "not connected")));
                }
                if (this.remoteHasClosed || this.connection == null || !this.connection.isConnected()) {
                    log.info("Finializing channel close");
                    this.finalizeClose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteClose() throws IOException {
        log.info("Remote side is closing channel");
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.remoteHasClosed = true;
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalizeClose() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(3);
            this.onChannelClose();
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelClose(this);
            }
            if (this.connection != null) {
                this.connection.freeChannel(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.isLocalEOF = true;
            this.connection.sendChannelEOF(this);
        }
    }

    public boolean isLocalEOF() {
        return this.isLocalEOF;
    }

    public boolean isRemoteEOF() {
        return this.isRemoteEOF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteEOF() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.isRemoteEOF = true;
            this.onChannelEOF();
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelEOF(this);
            }
        }
    }

    public void addEventListener(ChannelEventListener channelEventListener) {
        this.eventListeners.add(channelEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(ConnectionProtocol connectionProtocol, long l, long l2, long l3, long l4) throws IOException {
        this.localChannelId = l;
        this.remoteChannelId = l2;
        this.remotePacketSize = l4;
        this.remoteWindow.increaseWindowSpace(l3);
        this.connection = connectionProtocol;
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        ChannelState channelState = this.state;
        synchronized (channelState) {
            this.state.setValue(2);
            this.onChannelOpen();
            Iterator iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                ChannelEventListener channelEventListener = (ChannelEventListener)iterator.next();
                if (channelEventListener == null) continue;
                channelEventListener.onChannelOpen(this);
            }
        }
    }

    protected void init(ConnectionProtocol connectionProtocol, long l, long l2, long l3, long l4, ChannelEventListener channelEventListener) throws IOException {
        if (channelEventListener != null) {
            this.addEventListener(channelEventListener);
        }
        this.init(connectionProtocol, l, l2, l3, l4);
    }

    protected abstract void onChannelClose() throws IOException;

    protected abstract void onChannelEOF() throws IOException;

    protected abstract void onChannelOpen() throws IOException;

    protected abstract void onChannelRequest(String var1, boolean var2, byte[] var3) throws IOException;

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

