/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.session;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.agent.AgentSocketChannel;
import com.sshtools.j2ssh.agent.SshAgentClient;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ChannelInputStream;
import com.sshtools.j2ssh.connection.IOChannel;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.connection.SshMsgChannelExtendedData;
import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.session.PseudoTerminal;
import com.sshtools.j2ssh.session.SignalListener;
import com.sshtools.j2ssh.subsystem.SubsystemClient;
import com.sshtools.j2ssh.transport.SshMessageStore;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionChannelClient
extends IOChannel {
    private static Log log = LogFactory.getLog(class$com$sshtools$j2ssh$session$SessionChannelClient == null ? (class$com$sshtools$j2ssh$session$SessionChannelClient = SessionChannelClient.class$("com.sshtools.j2ssh.session.SessionChannelClient")) : class$com$sshtools$j2ssh$session$SessionChannelClient);
    private Integer exitCode = null;
    private String sessionType = "Uninitialized";
    private SubsystemClient subsystem;
    private boolean localFlowControl = false;
    private SignalListener signalListener;
    private SshMessageStore errorMessages = new SshMessageStore();
    private ChannelInputStream stderr = new ChannelInputStream(this.errorMessages, new Integer(1));
    static /* synthetic */ Class class$com$sshtools$j2ssh$session$SessionChannelClient;

    public SessionChannelClient() {
        this.setName("session");
    }

    public byte[] getChannelOpenData() {
        return null;
    }

    public byte[] getChannelConfirmationData() {
        return null;
    }

    public String getChannelType() {
        return "session";
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 32648;
    }

    protected int getMaximumPacketSize() {
        return 32648;
    }

    public void setSignalListener(SignalListener signalListener) {
        this.signalListener = signalListener;
    }

    public boolean setEnvironmentVariable(String string, String string2) throws IOException {
        log.debug("Requesting environment variable to be set [" + string + "=" + string2 + "]");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(string);
        byteArrayWriter.writeString(string2);
        return this.connection.sendChannelRequest(this, "env", true, byteArrayWriter.toByteArray());
    }

    public boolean requestAgentForwarding() throws IOException {
        log.info("Requesting agent forwarding for the session");
        if (System.getProperty("sshtools.agent") == null) {
            throw new SshException("Agent not found! 'sshtools.agent' system property should identify the agent location");
        }
        boolean bl = this.connection.sendChannelRequest(this, "auth-agent-req", true, null);
        if (bl) {
            this.connection.addChannelFactory("auth-agent", new ChannelFactory(){

                public Channel createChannel(String string, byte[] byArray) throws InvalidChannelException {
                    try {
                        AgentSocketChannel agentSocketChannel = new AgentSocketChannel(false);
                        Socket socket = SshAgentClient.connectAgentSocket(System.getProperty("sshtools.agent"));
                        agentSocketChannel.bindSocket(socket);
                        return agentSocketChannel;
                    }
                    catch (Exception exception) {
                        throw new InvalidChannelException(exception.getMessage());
                    }
                }
            });
        }
        return bl;
    }

    public boolean requestX11Forwarding(int n, String string) throws IOException {
        log.debug("Requesting X11 forwarding for display " + n + " using cookie " + string);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeBoolean(false);
        byteArrayWriter.writeString("MIT-MAGIC-COOKIE-1");
        byteArrayWriter.writeString(string);
        byteArrayWriter.writeUINT32(new UnsignedInteger32(String.valueOf(n)));
        return this.connection.sendChannelRequest(this, "x11-req", true, byteArrayWriter.toByteArray());
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void changeTerminalDimensions(PseudoTerminal pseudoTerminal) throws IOException {
        log.debug("Changing terminal dimensions");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeInt(pseudoTerminal.getColumns());
        byteArrayWriter.writeInt(pseudoTerminal.getRows());
        byteArrayWriter.writeInt(pseudoTerminal.getWidth());
        byteArrayWriter.writeInt(pseudoTerminal.getHeight());
        this.connection.sendChannelRequest(this, "window-change", false, byteArrayWriter.toByteArray());
    }

    public boolean executeCommand(String string) throws IOException {
        log.info("Requesting command execution");
        log.debug("Command is " + string);
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(string);
        if (this.connection.sendChannelRequest(this, "exec", true, byteArrayWriter.toByteArray())) {
            if (this.sessionType.equals("Uninitialized")) {
                this.sessionType = string;
            }
            return true;
        }
        return false;
    }

    public boolean requestPseudoTerminal(String string, int n, int n2, int n3, int n4, String string2) throws IOException {
        log.info("Requesting pseudo terminal");
        if (log.isDebugEnabled()) {
            log.debug("Terminal Type is " + string);
            log.debug("Columns=" + String.valueOf(n));
            log.debug("Rows=" + String.valueOf(n2));
            log.debug("Width=" + String.valueOf(n3));
            log.debug("Height=" + String.valueOf(n4));
        }
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(string);
        byteArrayWriter.writeInt(n);
        byteArrayWriter.writeInt(n2);
        byteArrayWriter.writeInt(n3);
        byteArrayWriter.writeInt(n4);
        byteArrayWriter.writeString(string2);
        return this.connection.sendChannelRequest(this, "pty-req", true, byteArrayWriter.toByteArray());
    }

    public boolean requestPseudoTerminal(PseudoTerminal pseudoTerminal) throws IOException {
        return this.requestPseudoTerminal(pseudoTerminal.getTerm(), pseudoTerminal.getColumns(), pseudoTerminal.getRows(), pseudoTerminal.getWidth(), pseudoTerminal.getHeight(), pseudoTerminal.getEncodedTerminalModes());
    }

    public boolean startShell() throws IOException {
        log.debug("Requesting users shell");
        if (this.connection.sendChannelRequest(this, "shell", true, null)) {
            if (this.sessionType.equals("Uninitialized")) {
                this.sessionType = "shell";
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(String string) throws IOException {
        log.info("Starting " + string + " subsystem");
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.writeString(string);
        if (this.connection.sendChannelRequest(this, "subsystem", true, byteArrayWriter.toByteArray())) {
            if (this.sessionType.equals("Uninitialized")) {
                this.sessionType = string;
            }
            return true;
        }
        return false;
    }

    public boolean startSubsystem(SubsystemClient subsystemClient) throws IOException {
        boolean bl = this.startSubsystem(subsystemClient.getName());
        if (bl) {
            this.subsystem = subsystemClient;
            subsystemClient.setSessionChannel(this);
            subsystemClient.start();
        }
        return bl;
    }

    public boolean isLocalFlowControlEnabled() {
        return this.localFlowControl;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String string) {
        this.sessionType = string;
    }

    public SubsystemClient getSubsystem() {
        return this.subsystem;
    }

    protected void onChannelClose() throws IOException {
        super.onChannelClose();
        try {
            this.stderr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Integer n = this.getExitCode();
        if (n != null) {
            log.debug("Exit code " + n.toString());
        }
    }

    protected void onChannelOpen() throws IOException {
    }

    public InputStream getStderrInputStream() throws IOException {
        return this.stderr;
    }

    protected void onChannelExtData(SshMsgChannelExtendedData sshMsgChannelExtendedData) throws IOException {
        this.errorMessages.addMessage(sshMsgChannelExtendedData);
    }

    protected void onChannelRequest(String string, boolean bl, byte[] byArray) throws IOException {
        log.debug("Channel Request received: " + string);
        if (string.equals("exit-status")) {
            this.exitCode = new Integer((int)ByteArrayReader.readInt(byArray, 0));
            log.debug("Exit code of " + this.exitCode.toString() + " received");
        } else if (string.equals("exit-signal")) {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string2 = byteArrayReader.readString();
            boolean bl2 = byteArrayReader.read() != 0;
            String string3 = byteArrayReader.readString();
            String string4 = byteArrayReader.readString();
            log.debug("Exit signal " + string2 + " received");
            log.debug("Signal message: " + string3);
            log.debug("Core dumped: " + String.valueOf(bl2));
            if (this.signalListener != null) {
                this.signalListener.onExitSignal(string2, bl2, string3);
            }
        } else if (string.equals("xon-xoff")) {
            if (byArray.length >= 1) {
                this.localFlowControl = byArray[0] != 0;
            }
        } else if (string.equals("signal")) {
            String string5 = ByteArrayReader.readString(byArray, 0);
            log.debug("Signal " + string5 + " received");
            if (this.signalListener != null) {
                this.signalListener.onSignal(string5);
            }
        } else if (bl) {
            this.connection.sendChannelRequestFailure(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

