/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ConsoleKnownHostsKeyVerification
extends AbstractKnownHostsKeyVerification {
    public ConsoleKnownHostsKeyVerification() throws InvalidHostFileException {
        super(new File(System.getProperty("user.home"), ".ssh" + File.separator + "known_hosts").getAbsolutePath());
    }

    public ConsoleKnownHostsKeyVerification(String string) throws InvalidHostFileException {
        super(string);
    }

    public void onHostKeyMismatch(String string, SshPublicKey sshPublicKey, SshPublicKey sshPublicKey2) {
        try {
            System.out.println("The host key supplied by " + string + " is: " + sshPublicKey2.getFingerprint());
            System.out.println("The current allowed key for " + string + " is: " + sshPublicKey.getFingerprint());
            this.getResponse(string, sshPublicKey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onUnknownHost(String string, SshPublicKey sshPublicKey) {
        try {
            System.out.println("The host " + string + " is currently unknown to the system");
            System.out.println("The host key fingerprint is: " + sshPublicKey.getFingerprint());
            this.getResponse(string, sshPublicKey);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getResponse(String string, SshPublicKey sshPublicKey) throws InvalidHostFileException, IOException {
        String string2 = "";
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (!(string2.equalsIgnoreCase("YES") || string2.equalsIgnoreCase("NO") || string2.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable())) {
            String string3;
            String string4 = string3 = this.isHostFileWriteable() ? "Yes|No|Always" : "Yes|No";
            if (!this.isHostFileWriteable()) {
                System.out.println("Always option disabled, host file is not writeable");
            }
            System.out.print("Do you want to allow this host key? [" + string3 + "]: ");
            string2 = bufferedReader.readLine();
        }
        if (string2.equalsIgnoreCase("YES")) {
            this.allowHost(string, sshPublicKey, false);
        }
        if (string2.equalsIgnoreCase("NO")) {
            System.out.println("Cannot continue without a valid host key");
            System.exit(1);
        }
        if (string2.equalsIgnoreCase("ALWAYS") && this.isHostFileWriteable()) {
            this.allowHost(string, sshPublicKey, true);
        }
    }
}

