/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javazoom.jl.player.Player;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.UIUtils;
import net.sf.jftp.gui.framework.HImage;
import net.sf.jftp.gui.hostchooser.HostChooser;
import net.sf.jftp.gui.hostchooser.NfsHostChooser;
import net.sf.jftp.gui.hostchooser.SftpHostChooser;
import net.sf.jftp.gui.hostchooser.SmbHostChooser;
import net.sf.jftp.gui.hostchooser.WebdavHostChooser;
import net.sf.jftp.gui.tasks.AddBookmarks;
import net.sf.jftp.gui.tasks.AdvancedOptions;
import net.sf.jftp.gui.tasks.BookmarkItem;
import net.sf.jftp.gui.tasks.BookmarkManager;
import net.sf.jftp.gui.tasks.Displayer;
import net.sf.jftp.gui.tasks.HttpBrowser;
import net.sf.jftp.gui.tasks.HttpDownloader;
import net.sf.jftp.gui.tasks.LastConnections;
import net.sf.jftp.gui.tasks.ProxyChooser;
import net.sf.jftp.net.wrappers.StartConnection;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.tools.HttpSpider;
import net.sf.jftp.util.RawConnection;

public class AppMenuBar
extends JMenuBar
implements ActionListener {
    public static JCheckBoxMenuItem fadeMenu = new JCheckBoxMenuItem("Enable Status Animation", Settings.getEnableStatusAnimation());
    public static JCheckBoxMenuItem askToDelete = new JCheckBoxMenuItem("Confirm Remove", Settings.getAskToDelete());
    public static JCheckBoxMenuItem debug = new JCheckBoxMenuItem("Verbose Console Debugging", Settings.getEnableDebug());
    public static JCheckBoxMenuItem disableLog = new JCheckBoxMenuItem("Disable Log", Settings.getDisableLog());
    public static JMenuItem clearItems = new JMenuItem("Clear Finished Items");
    private JFtp jftp;
    JMenu file = new JMenu("File");
    JMenu opt = new JMenu("Options");
    JMenu view = new JMenu("View");
    JMenu tools = new JMenu("Tools");
    JMenu bookmarks = new JMenu("Bookmarks");
    JMenu info = new JMenu("Info");
    JMenu lf = new JMenu(" Switch Look & Feel to");
    JMenu background = new JMenu("Desktop Background");
    JMenu ftp = new JMenu(" FTP");
    JMenu smb = new JMenu(" SMB");
    JMenu sftp = new JMenu(" SFTP");
    JMenu security = new JMenu("Security");
    JMenu experimental = new JMenu("Experimental Features");
    JMenu rss = new JMenu("RSS Feed");
    JMenu cnn = new JMenu("CNN");
    JMenuItem localFtpCon = new JMenuItem("Open FTP Connection in Local Tab...");
    JMenuItem localSftpCon = new JMenuItem("Open SFTP Connection in Local Tab...");
    JMenuItem localSmbCon = new JMenuItem("Open SMB/LAN Connection in Local Tab...");
    JMenuItem localNfsCon = new JMenuItem("Open NFS Connection in Local Tab...");
    JMenuItem localWebdavCon = new JMenuItem("Open WebDAV Connection in Local Tab... (ALPHA)");
    JMenuItem closeLocalCon = new JMenuItem("Close Active Connection in Local Tab");
    JMenuItem ftpCon = new JMenuItem("Connect to FTP Server...");
    JMenuItem sftpCon = new JMenuItem("Connect to SFTP Server...");
    JMenuItem smbCon = new JMenuItem("Connect to SMB Server / Browse LAN...");
    JMenuItem nfsCon = new JMenuItem("Connect to NFS Server...");
    JMenuItem webdavCon = new JMenuItem("Connect to WebDAV Server... (ALPHA)");
    JMenuItem close = new JMenuItem("Disconnect and Connect to Filesystem");
    JMenuItem exit = new JMenuItem("Exit");
    JMenuItem readme = new JMenuItem("Show Readme...");
    JMenuItem changelog = new JMenuItem("View Changelog...");
    JMenuItem todo = new JMenuItem("What's Next...");
    JMenuItem hp = new JMenuItem("Visit Project Homepage...");
    JMenuItem opts = new JMenuItem("Advanced Options...");
    JMenuItem http = new JMenuItem("Download File from URL...");
    JMenuItem raw = new JMenuItem("Raw TCP/IP Connection...");
    JMenuItem spider = new JMenuItem("Recursive HTTP Download...");
    JMenuItem sshShell = new JMenuItem("SSH Shell...");
    JMenuItem shell = new JMenuItem("Execute /bin/bash");
    JMenuItem loadAudio = new JMenuItem("Play MP3");
    JCheckBoxMenuItem rssDisabled = new JCheckBoxMenuItem("Enable RSS Feed", Settings.getEnableRSS());
    JCheckBoxMenuItem nl = new JCheckBoxMenuItem("Show Newline Option", Settings.showNewlineOption);
    JMenuItem loadSlash = new JMenuItem("Slashdot");
    JMenuItem loadCNN1 = new JMenuItem("CNN Top Stories");
    JMenuItem loadCNN2 = new JMenuItem("CNN World");
    JMenuItem loadCNN3 = new JMenuItem("CNN Tech");
    JMenuItem loadRss = new JMenuItem("Custom RSS Feed");
    JCheckBoxMenuItem stdback = new JCheckBoxMenuItem("Background Image", Settings.getUseBackground());
    JCheckBoxMenuItem resuming = new JCheckBoxMenuItem("Enable Resuming", Settings.enableResuming);
    JCheckBoxMenuItem ask = new JCheckBoxMenuItem("Always Ask to Resume", Settings.askToResume);
    JMenuItem proxy = new JMenuItem("Proxy Settings...");
    JCheckBoxMenuItem smbThreads = new JCheckBoxMenuItem("Multiple Connections", Settings.getEnableSmbMultiThreading());
    JCheckBoxMenuItem sftpThreads = new JCheckBoxMenuItem("Multiple Connections", Settings.getEnableSftpMultiThreading());
    JCheckBoxMenuItem sshKeys = new JCheckBoxMenuItem("Enable Host Key check", Settings.getEnableSshKeys());
    JCheckBoxMenuItem storePasswords = new JCheckBoxMenuItem("Store passwords (plaintext)", Settings.getStorePasswords());
    JCheckBoxMenuItem useTableLayout = new JCheckBoxMenuItem("Use JTable layout", Settings.getUseJTableLayout());
    JCheckBoxMenuItem useNewIcons = new JCheckBoxMenuItem("Use Silk Icons", Settings.getUseNewIcons());
    JCheckBoxMenuItem hideHidden = new JCheckBoxMenuItem("Hide local hidden files (Unix only)", Settings.getHideLocalDotNames());
    JMenuItem clear = new JMenuItem("Clear Log");
    JMenuItem[] lastConnections = new JMenuItem[9];
    String[][] cons = new String[9][10];
    String[] lastConData = new String[9];
    Character charTab = new Character('\t');
    String tab = this.charTab.toString();
    JMenuItem manage = new JMenuItem("Manage Bookmarks...");
    JMenuItem add = new JMenuItem("Add Bookmark...");
    Hashtable marks;
    JMenu current = this.bookmarks;
    JMenu last = this.bookmarks;

    public AppMenuBar(JFtp jftp) {
        this.jftp = jftp;
        this.ftpCon.addActionListener(this);
        this.close.addActionListener(this);
        this.exit.addActionListener(this);
        this.readme.addActionListener(this);
        this.changelog.addActionListener(this);
        this.todo.addActionListener(this);
        this.resuming.addActionListener(this);
        this.ask.addActionListener(this);
        this.smbCon.addActionListener(this);
        this.clear.addActionListener(this);
        this.sftpCon.addActionListener(this);
        fadeMenu.addActionListener(this);
        askToDelete.addActionListener(this);
        this.smbThreads.addActionListener(this);
        this.sftpThreads.addActionListener(this);
        debug.addActionListener(this);
        disableLog.addActionListener(this);
        this.http.addActionListener(this);
        this.hp.addActionListener(this);
        this.raw.addActionListener(this);
        this.nfsCon.addActionListener(this);
        this.spider.addActionListener(this);
        this.proxy.addActionListener(this);
        this.stdback.addActionListener(this);
        this.opts.addActionListener(this);
        this.webdavCon.addActionListener(this);
        this.sshShell.addActionListener(this);
        this.shell.addActionListener(this);
        this.nl.addActionListener(this);
        this.localFtpCon.addActionListener(this);
        this.localSftpCon.addActionListener(this);
        this.localSmbCon.addActionListener(this);
        this.localNfsCon.addActionListener(this);
        this.localWebdavCon.addActionListener(this);
        this.closeLocalCon.addActionListener(this);
        this.add.addActionListener(this);
        this.storePasswords.addActionListener(this);
        this.rssDisabled.addActionListener(this);
        this.loadRss.addActionListener(this);
        this.loadSlash.addActionListener(this);
        this.loadCNN1.addActionListener(this);
        this.loadCNN2.addActionListener(this);
        this.loadCNN3.addActionListener(this);
        this.loadAudio.addActionListener(this);
        this.useTableLayout.addActionListener(this);
        this.useNewIcons.addActionListener(this);
        this.hideHidden.addActionListener(this);
        clearItems.addActionListener(JFtp.dList);
        this.clear.setAccelerator(KeyStroke.getKeyStroke(49, 8));
        clearItems.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        this.changelog.setAccelerator(KeyStroke.getKeyStroke(51, 8));
        this.readme.setAccelerator(KeyStroke.getKeyStroke(52, 8));
        this.todo.setAccelerator(KeyStroke.getKeyStroke(53, 8));
        this.resetFileItems();
        this.ftp.add(this.resuming);
        this.ftp.add(this.ask);
        this.ftp.add(this.nl);
        this.smb.add(this.smbThreads);
        this.sftp.add(this.sftpThreads);
        this.sftp.add(this.sshKeys);
        this.security.add(askToDelete);
        this.security.add(this.storePasswords);
        this.cnn.add(this.loadCNN1);
        this.cnn.add(this.loadCNN2);
        this.cnn.add(this.loadCNN3);
        this.rss.add(this.rssDisabled);
        this.rss.add(this.loadSlash);
        this.rss.add(this.cnn);
        this.rss.add(this.loadRss);
        this.opt.add(this.security);
        this.opt.addSeparator();
        this.opt.add(this.ftp);
        this.opt.add(this.smb);
        this.opt.add(this.sftp);
        this.opt.addSeparator();
        this.opt.add(this.proxy);
        this.opt.add(this.opts);
        this.tools.add(this.http);
        this.tools.add(this.spider);
        this.tools.addSeparator();
        this.tools.add(this.raw);
        this.tools.addSeparator();
        this.tools.add(this.sshShell);
        this.tools.add(this.shell);
        this.view.add(this.hideHidden);
        this.view.addSeparator();
        this.view.add(this.useTableLayout);
        this.view.add(this.useNewIcons);
        this.view.add(fadeMenu);
        this.view.add(this.clear);
        this.view.add(clearItems);
        this.view.addSeparator();
        this.view.add(debug);
        this.view.add(disableLog);
        this.view.addSeparator();
        this.view.add(this.rss);
        this.view.addSeparator();
        this.info.add(this.readme);
        this.info.add(this.changelog);
        UIManager.LookAndFeelInfo[] m = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < m.length; ++i) {
            try {
                LookAndFeel lnf = (LookAndFeel)Class.forName(m[i].getClassName()).newInstance();
                if (!lnf.isSupportedLookAndFeel()) continue;
                JMenuItem tmp = new JMenuItem(m[i].getName());
                tmp.addActionListener(this);
                this.lf.add(tmp);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                continue;
            }
            catch (InstantiationException ie) {
                continue;
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        this.view.add(this.lf);
        this.background.add(this.stdback);
        this.view.add(this.background);
        this.manage.addActionListener(this);
        this.add(this.file);
        this.add(this.opt);
        this.add(this.view);
        this.add(this.tools);
        this.add(this.bookmarks);
        this.add(this.info);
        this.loadBookmarks();
    }

    public void loadBookmarks() {
        this.marks = new Hashtable();
        this.bookmarks.removeAll();
        this.bookmarks.add(this.add);
        this.bookmarks.add(this.manage);
        this.bookmarks.addSeparator();
        String data = "";
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(Settings.bookmarks)));
            while ((data = in.readLine()) != null) {
                if (data.startsWith("#") || data.trim().equals("")) continue;
                this.addBookmarkLine(data);
            }
        }
        catch (IOException e) {
            Log.debug("No bookmarks.txt found, using defaults.");
            this.addBookmark("FTP", "ftp.kernel.org", "anonymous", "j-ftp@sf.net", 21, "/pub/linux/kernel", "false");
            this.addBookmark("FTP", "upload.sourceforge.net", "anonymous", "j-ftp@sf.net", 21, "/incoming", "false");
            this.addBookmark("SMB", "(LAN)", "guest", "guest", -1, "-", "false");
            return;
        }
    }

    private void addBookmarkLine(String tmp) {
        try {
            StringTokenizer t = new StringTokenizer(tmp, "#", false);
            if (tmp.toLowerCase().trim().startsWith("<dir>")) {
                String dir = tmp.substring(tmp.indexOf(">") + 1, tmp.lastIndexOf("<"));
                JMenu m = new JMenu(dir);
                this.current.add(m);
                this.last = this.current;
                this.current = m;
            } else if (tmp.toLowerCase().trim().startsWith("<enddir>")) {
                this.current = this.last;
            } else {
                this.addBookmark(t.nextToken(), t.nextToken(), t.nextToken(), t.nextToken(), Integer.parseInt(t.nextToken()), t.nextToken(), t.nextToken());
            }
        }
        catch (Exception ex) {
            Log.debug("Broken line: " + tmp);
            ex.printStackTrace();
        }
    }

    public void addBookmark(String pr, String h, String u, String p, int po, String d, String l) {
        BookmarkItem x = new BookmarkItem(h);
        x.setUserdata(u, p);
        if (l.trim().startsWith("t")) {
            x.setLocal(true);
        }
        x.setPort(po);
        x.setProtocol(pr);
        x.setDirectory(d);
        this.current.add(x);
        this.marks.put(x.getLabel(), x);
        x.addActionListener(this);
    }

    public void resetFileItems() {
        this.file.removeAll();
        this.file.add(this.ftpCon);
        this.file.add(this.sftpCon);
        this.file.add(this.smbCon);
        this.file.add(this.nfsCon);
        this.file.add(this.webdavCon);
        this.file.addSeparator();
        this.file.add(this.close);
        this.file.addSeparator();
        this.file.addSeparator();
        this.file.add(this.localFtpCon);
        this.file.add(this.localSftpCon);
        this.file.add(this.localSmbCon);
        this.file.add(this.localNfsCon);
        this.file.addSeparator();
        this.file.add(this.closeLocalCon);
        this.file.addSeparator();
        boolean connectionsExist = false;
        try {
            this.cons = new String[9][10];
            this.cons = LastConnections.readFromFile(9);
            String usingLocal = new String("");
            int i = 0;
            while (true) {
                if (i < 9) {
                    if (!this.cons[i][0].equals("null")) {
                        String protocol = this.cons[i][0];
                        String htmp = this.cons[i][1];
                        String utmp = this.cons[i][2];
                        int j = 3;
                        while (!this.cons[i][j].equals(LastConnections.SENTINEL)) {
                            ++j;
                        }
                        usingLocal = this.cons[i][j - 1];
                        usingLocal = usingLocal.equals("true") ? "(in local tab)" : "";
                        Integer conNumberInt = new Integer(i + 1);
                        String conNumber = conNumberInt.toString();
                        this.lastConData[i] = new String(conNumber + " " + protocol + ": " + htmp + " " + usingLocal);
                        this.lastConnections[i] = new JMenuItem(this.lastConData[i]);
                        this.lastConnections[i].addActionListener(this);
                        connectionsExist = true;
                        this.file.add(this.lastConnections[i]);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            Log.debug("WARNING: Remembered connections broken.");
            ex.printStackTrace();
        }
        if (connectionsExist) {
            this.file.addSeparator();
        }
        this.file.add(this.exit);
        this.setMnemonics();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.proxy) {
            JFtp.statusP.jftp.addToDesktop("Proxy Settings", new ProxyChooser(), 500, 110);
            return;
        }
        if (e.getSource() == this.add) {
            Log.out("add called");
            AddBookmarks a = new AddBookmarks(JFtp.statusP.jftp);
            a.update();
            return;
        }
        if (e.getSource() == this.webdavCon) {
            WebdavHostChooser hc = new WebdavHostChooser();
            hc.toFront();
            hc.update();
            return;
        }
        if (e.getSource() == this.localFtpCon) {
            if (!JFtp.uiBlocked) {
                HostChooser hc = new HostChooser(null, true);
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.localSmbCon) {
            if (!JFtp.uiBlocked) {
                SmbHostChooser hc = new SmbHostChooser(null, true);
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.localSftpCon) {
            if (!JFtp.uiBlocked) {
                SftpHostChooser hc = new SftpHostChooser(null, true);
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.localNfsCon) {
            if (!JFtp.uiBlocked) {
                NfsHostChooser hc = new NfsHostChooser(null, true);
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.localWebdavCon) {
            if (!JFtp.uiBlocked) {
                WebdavHostChooser hc = new WebdavHostChooser(null, true);
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.closeLocalCon) {
            JFtp.statusP.jftp.closeCurrentLocalTab();
            return;
        }
        if (e.getSource() == this.clear) {
            this.jftp.clearLog();
            return;
        }
        if (e.getSource() == this.spider) {
            this.jftp.addToDesktop("Http recursive download", new HttpSpider(JFtp.localDir.getPath() + "_httpdownload/"), 440, 250);
            return;
        }
        if (e.getSource() == this.hp) {
            HttpBrowser h = new HttpBrowser("http://j-ftp.sourceforge.net");
            JFtp.desktop.add((Component)h, new Integer(0x7FFFFFF5));
            return;
        }
        if (e.getSource() == this.raw) {
            RawConnection c = new RawConnection();
            return;
        }
        if (e.getSource() == this.readme) {
            this.show("docs/readme");
            return;
        }
        if (e.getSource() == this.changelog) {
            this.show("docs/CHANGELOG");
            return;
        }
        if (e.getSource() == this.todo) {
            this.show("docs/TODO");
            return;
        }
        if (e.getSource() == this.shell) {
            UIUtils.runCommand("/bin/bash");
            return;
        }
        if (e.getSource() == this.loadAudio) {
            try {
                JFileChooser f = new JFileChooser();
                f.showOpenDialog(this.jftp);
                File file = f.getSelectedFile();
                Player p = new Player(new FileInputStream(file));
                p.play();
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Log.debug("Error: (" + ex + ")");
                return;
            }
        }
        if (e.getSource() == this.exit) {
            this.jftp.windowClosing(null);
            return;
        }
        if (e.getSource() == this.close) {
            JFtp.statusP.jftp.closeCurrentTab();
            return;
        }
        if (e.getSource() == this.ftpCon) {
            if (!JFtp.uiBlocked) {
                HostChooser hc = new HostChooser();
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.smbCon) {
            if (!JFtp.uiBlocked) {
                SmbHostChooser hc = new SmbHostChooser();
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.sftpCon) {
            if (!JFtp.uiBlocked) {
                SftpHostChooser hc = new SftpHostChooser();
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.nfsCon) {
            if (!JFtp.uiBlocked) {
                NfsHostChooser hc = new NfsHostChooser();
                hc.toFront();
                hc.update();
                return;
            }
        }
        if (e.getSource() == this.resuming) {
            boolean res;
            Settings.enableResuming = res = this.resuming.getState();
            Settings.setProperty("jftp.enableResuming", res);
            this.ask.setEnabled(Settings.enableResuming);
            Settings.save();
            return;
        }
        if (e.getSource() == this.useTableLayout) {
            boolean res = this.useTableLayout.getState();
            Settings.setProperty("jftp.useJTableLayout", res);
            Settings.save();
            JOptionPane.showMessageDialog(this, "Please restart JFtp to have the UI changed.");
            return;
        }
        if (e.getSource() == this.useNewIcons) {
            boolean res = this.useNewIcons.getState();
            Settings.setProperty("jftp.gui.look.newIcons", res);
            Settings.save();
            JOptionPane.showMessageDialog(this, "Please restart JFtp to have the UI changed.");
            return;
        }
        if (e.getSource() == this.hideHidden) {
            boolean res = this.hideHidden.getState();
            Settings.setProperty("jftp.hideHiddenDotNames", res);
            Settings.save();
            JFtp.localUpdate();
            return;
        }
        if (e.getSource() == this.nl) {
            boolean res;
            Settings.showNewlineOption = res = this.nl.getState();
            return;
        }
        if (e.getSource() == this.stdback) {
            Settings.setProperty("jftp.useBackground", this.stdback.getState());
            Settings.save();
            JFtp.statusP.jftp.fireUpdate();
            return;
        }
        if (e.getSource() == this.sshKeys) {
            Settings.setProperty("jftp.useSshKeyVerification", this.sshKeys.getState());
            Settings.save();
            JFtp.statusP.jftp.fireUpdate();
            return;
        }
        if (e.getSource() == this.rssDisabled) {
            Settings.setProperty("jftp.enableRSS", this.rssDisabled.getState());
            Settings.save();
            JFtp.statusP.jftp.fireUpdate();
            return;
        }
        if (e.getSource() == this.loadRss) {
            String what = JOptionPane.showInputDialog("Enter URL", (Object)"http://");
            if (what == null) {
                return;
            }
            Settings.setProperty("jftp.customRSSFeed", what);
            Settings.save();
            JFtp.statusP.jftp.feeder.switchTo(what);
            return;
        }
        if (e.getSource() == this.loadSlash) {
            Settings.setProperty("jftp.customRSSFeed", "http://slashdot.org/rss/slashdot.rss");
            Settings.save();
            JFtp.statusP.jftp.feeder.switchTo("http://slashdot.org/rss/slashdot.rss");
            return;
        }
        if (e.getSource() == this.loadCNN1) {
            Settings.setProperty("jftp.customRSSFeed", "http://rss.cnn.com/rss/cnn_topstories.rss");
            Settings.save();
            JFtp.statusP.jftp.feeder.switchTo("http://rss.cnn.com/rss/cnn_topstories.rss");
            return;
        }
        if (e.getSource() == this.loadCNN2) {
            Settings.setProperty("jftp.customRSSFeed", "http://rss.cnn.com/rss/cnn_world.rss");
            Settings.save();
            JFtp.statusP.jftp.feeder.switchTo("http://rss.cnn.com/rss/cnn_world.rss");
            return;
        }
        if (e.getSource() == this.loadCNN3) {
            Settings.setProperty("jftp.customRSSFeed", "http://rss.cnn.com/rss/cnn_tech.rss");
            Settings.save();
            JFtp.statusP.jftp.feeder.switchTo("http://rss.cnn.com/rss/cnn_tech.rss");
            return;
        }
        if (e.getSource() == debug) {
            Settings.setProperty("jftp.enableDebug", debug.getState());
            Settings.save();
            return;
        }
        if (e.getSource() == disableLog) {
            Settings.setProperty("jftp.disableLog", disableLog.getState());
            Settings.save();
            return;
        }
        if (e.getSource() == this.smbThreads) {
            Settings.setProperty("jftp.enableSmbMultiThreading", this.smbThreads.getState());
            Settings.save();
            return;
        }
        if (e.getSource() == this.sftpThreads) {
            Settings.setProperty("jftp.enableSftpMultiThreading", this.sftpThreads.getState());
            Settings.save();
            return;
        }
        if (e.getSource() == this.ask) {
            Settings.askToResume = this.ask.getState();
            return;
        }
        if (e.getSource() == this.http) {
            HttpDownloader dl = new HttpDownloader();
            this.jftp.addToDesktop("Http download", dl, 480, 100);
            this.jftp.setLocation(dl.hashCode(), 100, 150);
            return;
        }
        if (e.getSource() == fadeMenu) {
            Settings.setProperty("jftp.gui.enableStatusAnimation", fadeMenu.getState());
            Settings.save();
            return;
        }
        if (e.getSource() == askToDelete) {
            Settings.setProperty("jftp.gui.askToDelete", askToDelete.getState());
            Settings.save();
            return;
        }
        if (e.getSource() == this.lastConnections[0]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(0);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[1]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(1);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[2]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(2);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[3]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(3);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[4]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(4);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[5]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(5);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[6]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(6);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[7]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(7);
                return;
            }
        }
        if (e.getSource() == this.lastConnections[8]) {
            if (!JFtp.uiBlocked) {
                this.connectionSelected(8);
                return;
            }
        }
        if (e.getSource() == this.opts) {
            AdvancedOptions adv = new AdvancedOptions();
            this.jftp.addToDesktop("Advanced Options", adv, 500, 180);
            this.jftp.setLocation(adv.hashCode(), 110, 180);
            return;
        }
        if (e.getSource() == this.manage) {
            BookmarkManager m = new BookmarkManager();
            JFtp.desktop.add((Component)m, new Integer(0x7FFFFFF5));
            return;
        }
        if (this.marks.contains(e.getSource())) {
            ((BookmarkItem)e.getSource()).connect();
            return;
        }
        if (e.getSource() == this.storePasswords) {
            boolean state = this.storePasswords.getState();
            if (!state) {
                JOptionPane j = new JOptionPane();
                int x = JOptionPane.showConfirmDialog(this.storePasswords, "You chose not to Save passwords.\nDo you want your old login data to be deleted?", "Delete old passwords?", 0);
                if (x == 0) {
                    File f = new File(Settings.login_def);
                    f.delete();
                    f = new File(Settings.login_def_sftp);
                    f.delete();
                    f = new File(Settings.login_def_nfs);
                    f.delete();
                    f = new File(Settings.login_def_smb);
                    f.delete();
                    f = new File(Settings.login);
                    f.delete();
                    f = new File(Settings.last_cons);
                    f.delete();
                    Log.debug("Deleted old login data files.\nPlease edit your bookmarks file manually!");
                }
            }
            Settings.setProperty("jftp.security.storePasswords", state);
            Settings.save();
            return;
        }
        if (e.getSource() == this.sshShell) {
            SftpHostChooser c = new SftpHostChooser(true);
            c.update();
            return;
        }
        String tmp = ((JMenuItem)e.getSource()).getLabel();
        UIManager.LookAndFeelInfo[] m = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < m.length) {
            if (m[i].getName().equals(tmp)) {
                JFtp.statusP.jftp.setLookAndFeel(m[i].getClassName());
                Settings.setProperty("jftp.gui.look", m[i].getClassName());
                Settings.save();
            }
            ++i;
        }
    }

    private void show(String file) {
        URL url = ClassLoader.getSystemResource(file);
        if (url == null) {
            url = HImage.class.getResource("/" + file);
        }
        Displayer d = new Displayer(url, null);
        JFtp.desktop.add((Component)d, new Integer(0x7FFFFFF4));
    }

    private void setMnemonics() {
        this.file.setMnemonic('F');
        this.opt.setMnemonic('O');
        this.view.setMnemonic('V');
        this.tools.setMnemonic('T');
        this.bookmarks.setMnemonic('B');
        this.info.setMnemonic('I');
        this.ftpCon.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.sftpCon.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.smbCon.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.nfsCon.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.close.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.localFtpCon.setMnemonic('F');
        this.localSftpCon.setMnemonic('S');
        this.localSmbCon.setMnemonic('L');
        this.localNfsCon.setMnemonic('N');
        this.closeLocalCon.setMnemonic('C');
        this.exit.setMnemonic('X');
        this.proxy.setMnemonic('P');
        this.http.setMnemonic('D');
        this.spider.setMnemonic('H');
        this.raw.setMnemonic('T');
        this.readme.setMnemonic('R');
        this.todo.setMnemonic('N');
        this.changelog.setMnemonic('C');
        this.hp.setMnemonic('H');
        this.opts.setMnemonic('A');
        this.manage.setMnemonic('M');
        this.clear.setMnemonic('C');
        clearItems.setMnemonic('F');
        try {
            int i = 0;
            while (true) {
                if (i < 9) {
                    if (!this.cons[i][0].equals("null")) {
                        Integer intI = new Integer(i + 1);
                        String stringI = intI.toString();
                        char charI = stringI.charAt(0);
                        this.lastConnections[i].setMnemonic(charI);
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            Log.out("WARNING: AppMenuBar produced Exception, ignored it");
            ex.printStackTrace();
        }
    }

    private void connectionSelected(int position) {
        String htmp = new String("");
        String utmp = new String("");
        String ptmp = new String("");
        String dtmp = new String("");
        boolean useLocal = false;
        int potmp = 0;
        String potmpString = new String("0");
        String useLocalString = new String("false");
        String protocol = this.cons[position][0];
        htmp = this.cons[position][1];
        utmp = this.cons[position][2];
        ptmp = this.cons[position][3];
        if (ptmp.equals("")) {
            ptmp = UIUtils.getPasswordFromUser(JFtp.statusP.jftp);
        }
        if (protocol.equals("FTP")) {
            potmpString = this.cons[position][4];
            dtmp = this.cons[position][5];
            useLocalString = this.cons[position][6];
            potmp = Integer.parseInt(potmpString);
            useLocal = useLocalString.equals("true");
            StartConnection.startFtpCon(htmp, utmp, ptmp, potmp, dtmp, useLocal);
        } else if (protocol.equals("SFTP")) {
            potmpString = this.cons[position][4];
            useLocalString = this.cons[position][5];
        } else if (protocol.equals("NFS")) {
            useLocalString = this.cons[position][4];
        } else if (protocol.equals("SMB")) {
            dtmp = this.cons[position][4];
            useLocalString = this.cons[position][5];
        }
        potmp = Integer.parseInt(potmpString);
        useLocal = useLocalString.equals("true");
        if (protocol.equals("SFTP")) {
            StartConnection.startCon(protocol, htmp, utmp, ptmp, potmp, dtmp, useLocal);
        } else if (!protocol.equals("FTP")) {
            StartConnection.startCon(protocol, htmp, utmp, ptmp, potmp, dtmp, useLocal);
        }
    }
}

