/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.SaveSet;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.UITool;
import net.sf.jftp.gui.base.UIUtils;
import net.sf.jftp.gui.base.dir.DirCanvas;
import net.sf.jftp.gui.base.dir.DirCellRenderer;
import net.sf.jftp.gui.base.dir.DirComponent;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.base.dir.DirLister;
import net.sf.jftp.gui.base.dir.DirPanel;
import net.sf.jftp.gui.base.dir.TableUtils;
import net.sf.jftp.gui.framework.HImage;
import net.sf.jftp.gui.framework.HImageButton;
import net.sf.jftp.gui.framework.HPanel;
import net.sf.jftp.gui.tasks.Creator;
import net.sf.jftp.gui.tasks.ImageViewer;
import net.sf.jftp.gui.tasks.NameChooser;
import net.sf.jftp.gui.tasks.RemoteCommand;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.FilesystemConnection;
import net.sf.jftp.net.FtpConnection;
import net.sf.jftp.net.wrappers.SmbConnection;
import net.sf.jftp.system.LocalIO;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.UpdateDaemon;
import net.sf.jftp.system.logging.Log;
import net.sf.jftp.util.ZipFileCreator;

public class LocalDir
extends DirComponent
implements ListSelectionListener,
ActionListener,
ConnectionListener,
KeyListener {
    static final String deleteString = "rm";
    static final String mkdirString = "mkdir";
    static final String refreshString = "fresh";
    static final String cdString = "cd";
    static final String cmdString = "cmd";
    static final String downloadString = "<-";
    static final String uploadString = "->";
    static final String zipString = "zip";
    static final String cpString = "cp";
    static final String rnString = "rn";
    static final String cdUpString = "cdUp";
    HImageButton deleteButton;
    HImageButton mkdirButton;
    HImageButton cmdButton;
    HImageButton refreshButton;
    HImageButton cdButton;
    HImageButton uploadButton;
    HImageButton zipButton;
    HImageButton cpButton;
    HImageButton rnButton;
    private DirCanvas label = new DirCanvas(this);
    private boolean pathChanged = true;
    private boolean firstGui = true;
    private int pos = 0;
    private JPanel p = new JPanel();
    private JToolBar buttonPanel = new JToolBar(){

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }
    };
    private JToolBar currDirPanel = new JToolBar(){

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }
    };
    private DefaultListModel jlm;
    private JScrollPane jsp = new JScrollPane(this.jl);
    private int tmpindex = -1;
    private Hashtable dummy = new Hashtable();
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenuItem runFile = new JMenuItem("Launch file");
    private JMenuItem viewFile = new JMenuItem("View file");
    private JMenuItem props = new JMenuItem("Properties");
    private DirEntry currentPopup = null;
    private String sortMode = null;
    String[] sortTypes = new String[]{"Normal", "Reverse", "Size", "Size/Re"};
    private JComboBox sorter = new JComboBox<String>(this.sortTypes);
    HImageButton cdUpButton;
    private boolean dateEnabled = false;

    public LocalDir() {
        this.type = "local";
        this.con = new FilesystemConnection();
        this.con.addConnectionListener(this);
    }

    public LocalDir(String path) {
        this.type = "local";
        this.path = path;
        this.con = new FilesystemConnection();
        this.con.addConnectionListener(this);
        this.con.chdir(path);
    }

    public void gui_init() {
        this.setLayout(new BorderLayout());
        this.currDirPanel.setFloatable(false);
        this.buttonPanel.setFloatable(false);
        FlowLayout f = new FlowLayout(2);
        f.setHgap(1);
        f.setVgap(2);
        this.buttonPanel.setLayout(f);
        this.buttonPanel.setMargin(new Insets(0, 0, 0, 0));
        this.runFile.addActionListener(this);
        this.viewFile.addActionListener(this);
        this.props.addActionListener(this);
        this.popupMenu.add(this.runFile);
        this.popupMenu.add(this.viewFile);
        this.popupMenu.add(this.props);
        this.deleteButton = new HImageButton(Settings.deleteImage, deleteString, "Delete selected", this);
        this.deleteButton.setToolTipText("Delete selected");
        this.mkdirButton = new HImageButton(Settings.mkdirImage, mkdirString, "Create a new directory", this);
        this.mkdirButton.setToolTipText("Create directory");
        this.refreshButton = new HImageButton(Settings.refreshImage, refreshString, "Refresh current directory", this);
        this.refreshButton.setToolTipText("Refresh directory");
        this.refreshButton.setRolloverIcon(new ImageIcon(HImage.getImage(this, Settings.refreshImage2)));
        this.refreshButton.setRolloverEnabled(true);
        this.cdButton = new HImageButton(Settings.cdImage, cdString, "Change directory", this);
        this.cdButton.setToolTipText("Change directory");
        this.uploadButton = new HImageButton(Settings.uploadImage, uploadString, "Upload selected", this);
        this.uploadButton.setToolTipText("Upload selected");
        this.zipButton = new HImageButton(Settings.zipFileImage, zipString, "Add selected to new zip file", this);
        this.zipButton.setToolTipText("Create zip");
        this.cpButton = new HImageButton(Settings.copyImage, cpString, "Copy selected files to another local dir", this);
        this.cpButton.setToolTipText("Local copy selected");
        this.rnButton = new HImageButton(Settings.textFileImage, rnString, "Rename selected file or directory", this);
        this.rnButton.setToolTipText("Rename selected");
        this.cdUpButton = new HImageButton(Settings.cdUpImage, cdUpString, "Go to Parent Directory", this);
        this.cdUpButton.setToolTipText("Go to Parent Directory");
        this.label.setText("Filesystem: " + StringUtils.cutPath(this.path));
        this.label.setSize(this.getSize().width - 10, 24);
        this.currDirPanel.add(this.label);
        this.currDirPanel.setSize(this.getSize().width - 10, 32);
        this.label.setSize(this.getSize().width - 20, 24);
        this.p.setLayout(new BorderLayout());
        this.p.add("North", this.currDirPanel);
        this.buttonPanel.add(this.sorter);
        this.buttonPanel.add(new JLabel("  "));
        this.buttonPanel.add(this.refreshButton);
        this.buttonPanel.add(new JLabel("  "));
        this.buttonPanel.add(this.cpButton);
        this.buttonPanel.add(this.rnButton);
        this.buttonPanel.add(this.mkdirButton);
        this.buttonPanel.add(this.cdButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.cdUpButton);
        this.buttonPanel.add(new JLabel("  "));
        this.buttonPanel.add(this.zipButton);
        this.buttonPanel.add(new JLabel("   "));
        this.buttonPanel.add(this.uploadButton);
        this.buttonPanel.setVisible(true);
        this.buttonPanel.setSize(this.getSize().width - 10, 32);
        this.p.add("East", this.buttonPanel);
        this.sorter.addActionListener(this);
        this.add("North", this.p);
        this.setDirList(true);
        this.jlm = new DefaultListModel();
        this.jl = new JList(this.jlm);
        this.jl.setCellRenderer(new DirCellRenderer());
        this.jl.setVisibleRowCount(15);
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (JFtp.uiBlocked) {
                    return;
                }
                if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                    int index = LocalDir.this.jl.getSelectedIndex() - 1;
                    if (index < -1) {
                        return;
                    }
                    String tgt = LocalDir.this.jl.getSelectedValue().toString();
                    if (index >= 0) {
                        if (LocalDir.this.dirEntry == null || LocalDir.this.dirEntry.length < index || LocalDir.this.dirEntry[index] == null) {
                            return;
                        }
                        LocalDir.this.currentPopup = LocalDir.this.dirEntry[index];
                        LocalDir.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JFtp.uiBlocked) {
                    return;
                }
                if (Settings.getUseJTableLayout()) {
                    TableUtils.copyTableSelectionsToJList(LocalDir.this.jl, LocalDir.this.table);
                }
                if (e.getClickCount() == 2) {
                    int index = LocalDir.this.jl.getSelectedIndex() - 1;
                    if (index < -1) {
                        return;
                    }
                    String tgt = LocalDir.this.jl.getSelectedValue().toString();
                    if (index < 0) {
                        LocalDir.this.chdir(LocalDir.this.path + tgt);
                    } else {
                        if (LocalDir.this.dirEntry == null || LocalDir.this.dirEntry.length < index || LocalDir.this.dirEntry[index] == null) {
                            return;
                        }
                        if (LocalDir.this.dirEntry[index].isDirectory()) {
                            if (JFtp.mainFrame != null) {
                                JFtp.mainFrame.setCursor(3);
                            }
                            LocalDir.this.chdir(LocalDir.this.path + tgt);
                            if (JFtp.mainFrame != null) {
                                JFtp.mainFrame.setCursor(0);
                            }
                        } else {
                            LocalDir.this.showContentWindow(LocalDir.this.path + LocalDir.this.dirEntry[index].toString(), LocalDir.this.dirEntry[index]);
                        }
                    }
                }
            }
        };
        if (Settings.newTableGui) {
            this.jsp = new JScrollPane(this.table);
            this.table.getSelectionModel().addListSelectionListener(this);
            this.table.addMouseListener(mouseListener);
        } else {
            this.jsp = new JScrollPane(this.jl);
            this.jl.addListSelectionListener(this);
            this.jl.addKeyListener(this);
            this.jl.addMouseListener(mouseListener);
            this.jl.requestFocus();
        }
        this.jsp.setSize(this.getSize().width - 20, this.getSize().height - 72);
        this.add("Center", this.jsp);
        this.jsp.setVisible(true);
        TableUtils.tryToEnableRowSorting(this.table);
        if (Settings.IS_JAVA_1_6) {
            this.buttonPanel.remove(this.sorter);
        }
        this.setVisible(true);
    }

    public void setViewPort() {
    }

    public void gui(boolean fakeInit) {
        if (this.firstGui) {
            this.gui_init();
            this.firstGui = false;
        }
        if (this.con instanceof FilesystemConnection) {
            this.label.setText("Filesystem: " + StringUtils.cutPath(this.path));
        } else {
            this.label.setText("Remote: " + StringUtils.cutPath(this.path));
        }
        if (!fakeInit) {
            this.setDirList(false);
        }
        this.invalidate();
        this.validate();
    }

    public void setDirList(boolean fakeInit) {
        this.jlm = new DefaultListModel();
        DirEntry dwn = new DirEntry("..", this);
        dwn.setDirectory();
        this.jlm.addElement(dwn);
        if (!fakeInit && this.pathChanged) {
            this.pathChanged = false;
            DirLister dir = new DirLister(this.con, this.sortMode, Settings.getHideLocalDotNames());
            while (!dir.finished) {
                LocalIO.pause(10);
            }
            if (dir.isOk()) {
                this.length = dir.getLength();
                this.dirEntry = new DirEntry[this.length];
                this.files = dir.list();
                String[] fSize = dir.sList();
                int[] perms = dir.getPermissions();
                for (int i = 0; i < this.length; ++i) {
                    if (this.files == null || this.files[i] == null) {
                        System.out.println("skipping setDirList, files or files[i] is null!");
                        return;
                    }
                    this.dirEntry[i] = new DirEntry(this.files[i], this);
                    if (this.dirEntry[i] == null) {
                        System.out.println("\nskipping setDirList, dirEntry[i] is null!");
                        return;
                    }
                    if (this.dirEntry[i].file == null) {
                        System.out.println("\nskipping setDirList, dirEntry[i].file is null!");
                        return;
                    }
                    if (perms != null) {
                        this.dirEntry[i].setPermission(perms[i]);
                    }
                    if (fSize[i].startsWith("@")) {
                        fSize[i] = fSize[i].substring(1);
                    }
                    this.dirEntry[i].setFileSize(Long.parseLong(fSize[i]));
                    if (this.dirEntry[i].file.endsWith("/")) {
                        this.dirEntry[i].setDirectory();
                    } else {
                        this.dirEntry[i].setFile();
                    }
                    Date[] d = dir.getDates();
                    if (d != null) {
                        this.dirEntry[i].setDate(d[i]);
                    }
                    this.jlm.addElement(this.dirEntry[i]);
                }
            } else {
                Log.debug("Not a directory: " + this.path);
            }
        }
        this.jl.setModel(this.jlm);
        this.update();
    }

    public boolean chdir(String p) {
        if (JFtp.remoteDir == null || p == null || p.trim().equals("")) {
            return false;
        }
        BasicConnection c = JFtp.remoteDir.getCon();
        if (c != null && c instanceof FtpConnection) {
            FtpConnection con = (FtpConnection)c;
            SaveSet s = new SaveSet(Settings.login_def, con.getHost(), con.getUsername(), con.getPassword(), Integer.toString(con.getPort()), con.getCachedPWD(), con.getLocalPath());
        }
        if (this.con.chdirNoRefresh(p)) {
            this.path = this.con.getPWD();
            if (this.con instanceof FilesystemConnection) {
                JFtp.remoteDir.getCon().setLocalPath(this.path);
                this.setDate();
            }
            this.pathChanged = true;
            this.gui(false);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (JFtp.uiBlocked) {
            return;
        }
        if (e.getActionCommand().equals(deleteString)) {
            this.lock(false);
            if (Settings.getAskToDelete() && !UITool.askToDelete(this)) {
                this.unlock(false);
                return;
            }
            for (int i = 0; i < this.length; ++i) {
                if (!this.dirEntry[i].selected) continue;
                this.con.removeFileOrDir(this.dirEntry[i].file);
            }
            this.unlock(false);
            this.fresh();
        } else if (e.getActionCommand().equals(mkdirString)) {
            Creator c = new Creator("Create:", this.con);
        } else if (e.getActionCommand().equals(cmdString)) {
            RemoteCommand rc = new RemoteCommand();
        } else if (e.getActionCommand().equals(cdString)) {
            String tmp = UITool.getPathFromDialog(this.path);
            this.chdir(tmp);
        } else if (e.getActionCommand().equals(refreshString)) {
            this.fresh();
        } else if (e.getActionCommand().equals(cpString)) {
            Object[] o = this.jl.getSelectedValues();
            if (o == null) {
                return;
            }
            String tmp = UITool.getPathFromDialog(this.path);
            if (tmp == null) {
                return;
            }
            if (!tmp.endsWith("/")) {
                tmp = tmp + "/";
            }
            try {
                this.copy(o, this.path, "", tmp);
                Log.debug("Copy finished...");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Log.debug("Copy failed!");
            }
        } else if (e.getActionCommand().equals(zipString)) {
            try {
                Object[] entry = this.jl.getSelectedValues();
                if (entry == null) {
                    return;
                }
                String[] tmp = new String[entry.length];
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = entry[i].toString();
                }
                NameChooser n = new NameChooser();
                String name = n.text.getText();
                ZipFileCreator z = new ZipFileCreator(tmp, this.path, name);
                this.fresh();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (e.getActionCommand().equals(uploadString)) {
            this.blockedTransfer(-2);
        } else if (e.getActionCommand().equals(downloadString)) {
            this.blockedTransfer(-2);
        } else if (e.getActionCommand().equals(rnString)) {
            Object[] target = this.jl.getSelectedValues();
            if (target == null || target.length == 0) {
                Log.debug("No file selected");
                return;
            }
            if (target.length > 1) {
                Log.debug("Too many files selected");
                return;
            }
            String val = JOptionPane.showInternalInputDialog(JFtp.desktop, "Choose a name...");
            if (val != null) {
                if (!this.con.rename(target[0].toString(), val)) {
                    Log.debug("Rename failed.");
                } else {
                    Log.debug("Successfully renamed.");
                    this.fresh();
                }
            }
        } else if (e.getSource() == this.props) {
            JFtp.statusP.jftp.clearLog();
            int x = this.currentPopup.getPermission();
            String tmp = x == 23 ? "read only" : (x == 42 ? "read/write" : (x == -666 ? "denied" : "undefined"));
            String msg = "File: " + this.currentPopup.toString() + "\n" + " Size: " + this.currentPopup.getFileSize() + " raw size: " + this.currentPopup.getRawSize() + "\n" + " Symlink: " + this.currentPopup.isLink() + "\n" + " Directory: " + this.currentPopup.isDirectory() + "\n" + " Permission: " + tmp + "\n";
            Log.debug(msg);
        } else if (e.getSource() == this.viewFile) {
            if (this.currentPopup.isDirectory()) {
                Log.debug("This is a directory, not a file.");
                return;
            }
            String url = JFtp.localDir.getPath() + this.currentPopup.toString();
            this.showContentWindow(url, this.currentPopup);
        } else if (e.getSource() == this.runFile) {
            if (this.currentPopup.isDirectory()) {
                Log.debug("This is a directory, not a file.");
                return;
            }
            String url = JFtp.localDir.getPath() + this.currentPopup.toString();
            this.showContentWindow("popup-run@" + url, this.currentPopup);
        } else if (e.getSource() == this.sorter) {
            this.sortMode = (String)this.sorter.getSelectedItem();
            Settings.showLocalDateNoSize = this.sortMode.equals("Date");
            this.fresh();
        } else if (e.getActionCommand().equals(cdUpString)) {
            this.chdir("..");
        }
    }

    private void copy(Object[] fRaw, String path, String offset, String target) throws Exception {
        String[] files = new String[fRaw.length];
        for (int j = 0; j < fRaw.length; ++j) {
            files[j] = fRaw[j].toString();
        }
        for (int i = 0; i < files.length; ++i) {
            File f = new File(path + offset + files[i]);
            BufferedInputStream in = null;
            BufferedOutputStream out = null;
            byte[] buf = new byte[4096];
            if (f.exists() && !f.isDirectory()) {
                in = new BufferedInputStream(new FileInputStream(path + offset + files[i]));
                out = new BufferedOutputStream(new FileOutputStream(target + offset + files[i]));
                int len = 0;
                while (in != null && (len = in.read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
                out.flush();
                out.close();
                continue;
            }
            if (!f.exists()) continue;
            if (!files[i].endsWith("/")) {
                files[i] = files[i] + "/";
            }
            File f2 = new File(target + offset + files[i]);
            if (!f.exists()) {
                f.mkdir();
            }
            this.copy(f.list(), path, offset + files[i], target);
        }
    }

    public synchronized void blockedTransfer(int index) {
        this.tmpindex = index;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean block;
                boolean bl = block = !Settings.getEnableMultiThreading();
                if (!(LocalDir.this.con instanceof FtpConnection)) {
                    block = true;
                }
                if (block || Settings.getNoUploadMultiThreading()) {
                    LocalDir.this.lock(false);
                }
                LocalDir.this.transfer(LocalDir.this.tmpindex);
                if (block || Settings.getNoUploadMultiThreading()) {
                    LocalDir.this.unlock(false);
                }
            }
        };
        Thread t = new Thread(r);
        t.start();
    }

    @Override
    public void lock(boolean first) {
        JFtp.uiBlocked = true;
        this.jl.setEnabled(false);
        if (!first) {
            JFtp.remoteDir.lock(true);
        }
    }

    @Override
    public void unlock(boolean first) {
        JFtp.uiBlocked = false;
        this.jl.setEnabled(true);
        if (!first) {
            JFtp.remoteDir.unlock(true);
        }
    }

    @Override
    public void fresh() {
        Object o;
        if (JFtp.mainFrame != null) {
            JFtp.mainFrame.setCursor(3);
        }
        String i = "";
        int idx = this.jl.getSelectedIndex();
        if (idx >= 0 && (o = this.jl.getSelectedValue()) != null) {
            i = o.toString();
        }
        this.chdir(this.path);
        if (idx >= 0 && idx < this.jl.getModel().getSize()) {
            if (this.jl.getModel().getElementAt(idx).toString().equals(i)) {
                this.jl.setSelectedIndex(idx);
            } else {
                this.jl.setSelectedIndex(0);
            }
        }
        this.update();
        if (JFtp.mainFrame != null) {
            JFtp.mainFrame.setCursor(0);
        }
    }

    public synchronized void transfer() {
        int i;
        boolean[] bFileSelected = new boolean[this.dirEntry.length + 1];
        DirEntry[] cacheEntry = new DirEntry[this.dirEntry.length];
        System.arraycopy(this.dirEntry, 0, cacheEntry, 0, cacheEntry.length);
        for (i = 0; i < this.dirEntry.length; ++i) {
            bFileSelected[i] = cacheEntry[i].selected;
            if (cacheEntry[i].equals(this.dirEntry[i])) continue;
            Log.out("mismatch");
        }
        for (i = 0; i < cacheEntry.length; ++i) {
            if (!bFileSelected[i]) continue;
            this.startTransfer(cacheEntry[i]);
        }
    }

    public void startTransfer(DirEntry entry) {
        if (this.con instanceof FilesystemConnection && JFtp.remoteDir.getCon() instanceof FtpConnection) {
            if (entry.getRawSize() < (long)Settings.smallSizeUp && !entry.isDirectory()) {
                JFtp.remoteDir.getCon().upload(this.path + entry.file);
            } else {
                JFtp.remoteDir.getCon().handleUpload(this.path + entry.file);
            }
        } else if (this.con instanceof FtpConnection && JFtp.remoteDir.getCon() instanceof FtpConnection) {
            if (entry.isDirectory()) {
                Log.debug("Directory transfer between remote connections is not supported yet!");
                return;
            }
            Log.out("direct ftp transfer started (upload)");
            ((FtpConnection)JFtp.remoteDir.getCon()).upload(entry.file, ((FtpConnection)JFtp.localDir.getCon()).getDownloadInputStream(this.path + entry.file));
        } else if (this.con instanceof FtpConnection && JFtp.remoteDir.getCon() instanceof FilesystemConnection) {
            this.con.setLocalPath(JFtp.remoteDir.getPath());
            this.con.handleDownload(this.path + entry.file);
        } else if (this.con instanceof FilesystemConnection && JFtp.remoteDir.getCon() instanceof FilesystemConnection) {
            this.con.upload(entry.file);
            JFtp.remoteDir.actionPerformed(this.con, "FRESH");
        } else if (this.con instanceof FilesystemConnection) {
            JFtp.remoteDir.getCon().handleUpload(entry.file);
            JFtp.remoteDir.actionPerformed(this.con, "FRESH");
        } else {
            if (entry.isDirectory()) {
                Log.debug("Directory transfer between remote connections is not supported yet!");
                return;
            }
            Log.out("direct transfer started (upload)");
            JFtp.remoteDir.getCon().upload(entry.file, JFtp.localDir.getCon().getDownloadInputStream(this.path + entry.file));
            JFtp.remoteDir.actionPerformed(this.con, "FRESH");
        }
    }

    public void transfer(int i) {
        if (i == -2) {
            this.transfer();
            return;
        }
        if (this.dirEntry[i].selected) {
            this.startTransfer(this.dirEntry[i]);
        }
    }

    public void safeUpdate() {
        UpdateDaemon.updateLocalDir();
    }

    @Override
    public void actionPerformed(Object target, String msg) {
        this.safeUpdate();
    }

    @Override
    public void updateProgress(String file, String type, long bytes) {
        if (this.dList == null || this.dirEntry == null || file == null) {
            return;
        }
        boolean flag = false;
        if (file.endsWith("/") && file.length() > 1) {
            flag = true;
            file = file.substring(0, file.lastIndexOf("/"));
        }
        file = file.substring(file.lastIndexOf("/") + 1);
        if (flag) {
            file = file + "/";
        }
        long s = 0L;
        if (JFtp.dList.sizeCache.containsKey(file)) {
            s = (Long)JFtp.dList.sizeCache.get(file);
        } else {
            s = new File(this.getPath() + file).length();
            JFtp.dList.sizeCache.put(file, new Long(s));
        }
        this.dList.updateList(file, type, bytes, s);
    }

    @Override
    public void connectionInitialized(BasicConnection con) {
    }

    @Override
    public void actionFinished(BasicConnection con) {
        this.safeUpdate();
    }

    @Override
    public void connectionFailed(BasicConnection con, String reason) {
    }

    private void setDate() {
        if (!(this.con instanceof FtpConnection) && !(this.con instanceof FilesystemConnection)) {
            try {
                this.sorter.removeItem("Date");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dateEnabled = false;
            return;
        }
        if (this.con instanceof FtpConnection && ((FtpConnection)this.con).dateVector.size() > 0) {
            if (!this.dateEnabled) {
                this.sorter.addItem("Date");
                this.dateEnabled = true;
                UpdateDaemon.updateRemoteDirGUI();
            }
        } else if (this.con instanceof FilesystemConnection && ((FilesystemConnection)this.con).dateVector.size() > 0) {
            if (!this.dateEnabled) {
                this.sorter.addItem("Date");
                this.dateEnabled = true;
                UpdateDaemon.updateRemoteDirGUI();
            }
        } else if (this.dateEnabled) {
            this.sorter.removeItem("Date");
            this.dateEnabled = false;
            Settings.showLocalDateNoSize = false;
            UpdateDaemon.updateRemoteDirGUI();
        }
    }

    @Override
    public void updateRemoteDirectory(BasicConnection c) {
        this.path = this.con instanceof FtpConnection ? ((FtpConnection)this.con).getCachedPWD() : (this.con instanceof SmbConnection && !this.path.startsWith("smb://") ? this.con.getPWD() : this.con.getPWD());
        this.safeUpdate();
    }

    private void setZipFilePath(DirEntry entry) {
        if (JFtp.mainFrame != null) {
            JFtp.mainFrame.setCursor(3);
        }
        String n = entry.toString();
        String tmp = this.path + n + "-dir/";
        Log.debug("\nExtracting: " + this.path + n);
        File tmpDir = new File(tmp);
        if (tmpDir.exists() || tmpDir.mkdir()) {
            try {
                ZipFile z = new ZipFile(this.path + n);
                Enumeration<? extends ZipEntry> e = z.entries();
                while (e.hasMoreElements()) {
                    ZipEntry z1 = e.nextElement();
                    Log.debug("-> " + z1.getName());
                    BufferedInputStream in = new BufferedInputStream(z.getInputStream(z1));
                    BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp + z1.getName()));
                    byte[] buf = new byte[8192];
                    while (in.read(buf, 0, 8192) != -1) {
                        out.write(buf);
                    }
                    out.flush();
                    out.close();
                    in.close();
                }
                this.chdir(tmp);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                Log.debug("ERROR: " + ex);
            }
        } else {
            Log.debug("Cannot create directory, skipping extraction...");
        }
        if (JFtp.mainFrame != null) {
            JFtp.mainFrame.setCursor(0);
        }
    }

    public void showContentWindow(String url, DirEntry d) {
        if (Settings.runtimeCommands > 0 && url.startsWith("popup-run@")) {
            String ext = url.substring(10);
            try {
                System.out.println("xx: " + ext);
                if (!Settings.askToRun || Settings.askToRun && UITool.askToRun(this)) {
                    UIUtils.runCommand(ext);
                }
            }
            catch (Exception ex) {
                Log.out("Could not launch file: " + ext);
            }
            return;
        }
        if (d.toString().endsWith(".zip")) {
            this.setZipFilePath(d);
        } else {
            try {
                url = "file://" + url;
                String ext = url.toLowerCase();
                if (ext.endsWith(".jpg") || ext.endsWith(".gif") || ext.endsWith(".jpeg") || ext.endsWith(".png")) {
                    ImageViewer d1 = new ImageViewer(url);
                    JFtp.desktop.add((Component)d1, new Integer(0x7FFFFFF4));
                    return;
                }
                if (Settings.runtimeCommands > 1) {
                    try {
                        if (!Settings.askToRun || Settings.askToRun && UITool.askToRun(this)) {
                            UIUtils.runCommand(ext);
                            return;
                        }
                    }
                    catch (Exception ex) {
                        Log.out("Could not launch file: " + ext);
                    }
                }
                if (d.getRawSize() > 200000L) {
                    Log.debug("File is too big - 200kb is the maximum, sorry.");
                    return;
                }
                HPanel f = new HPanel();
                JEditorPane pane = new JEditorPane(url);
                pane.setEditable(false);
                if (!pane.getEditorKit().getContentType().equals("text/html") && !pane.getEditorKit().getContentType().equals("text/rtf")) {
                    if (!pane.getEditorKit().getContentType().equals("text/plain")) {
                        Log.debug("Nothing to do with this filetype - use the buttons if you want to transfer files.");
                        return;
                    }
                    pane.setEditable(false);
                }
                JScrollPane jsp = new JScrollPane(pane);
                f.setLayout(new BorderLayout());
                f.add("Center", jsp);
                JFtp.statusP.jftp.addToDesktop(url, f, 600, 400);
            }
            catch (Exception ex) {
                Log.debug("File error: " + ex);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Object o = this.jl.getSelectedValue();
            if (o == null) {
                return;
            }
            String tmp = ((DirEntry)o).toString();
            if (tmp.endsWith("/") || tmp.equals("..")) {
                this.chdir(tmp);
            } else {
                this.showContentWindow(this.path + tmp, (DirEntry)o);
            }
        } else if (e.getKeyCode() == 32) {
            int x = ((DirPanel)JFtp.remoteDir).jl.getSelectedIndex();
            if (x == -1) {
                x = 0;
            }
            ((DirPanel)JFtp.remoteDir).jl.grabFocus();
            ((DirPanel)JFtp.remoteDir).jl.setSelectedIndex(x);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

