/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base.dir;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.base.LocalDir;
import net.sf.jftp.gui.base.RemoteDir;
import net.sf.jftp.gui.base.dir.DirEntry;
import net.sf.jftp.gui.framework.GUIDefaults;
import net.sf.jftp.system.logging.Log;

public class DirCellRenderer
extends DefaultListCellRenderer {
    static final ImageIcon longIcon = new ImageIcon(Settings.dirImage);
    static final ImageIcon shortIcon = new ImageIcon(Settings.fileImage);
    private Object value;

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        ImageIcon i = new ImageIcon(((DirEntry)value).getImage());
        if (i == null) {
            System.out.println("Img null: " + ((DirEntry)value).toString() + "/" + ((DirEntry)value).getImage());
        } else {
            this.setIcon(i);
        }
        this.value = value;
        Log.devnull(this.value);
        if (!((DirEntry)list.getModel().getElementAt(index)).getNoRender()) {
            String size = "";
            if (Settings.showFileSize) {
                size = ((DirEntry)list.getModel().getElementAt(index)).getFileSize();
            }
            this.setFont(GUIDefaults.monospaced);
            String s = value.toString();
            String date = "";
            if (Settings.showDateNoSize && ((DirEntry)list.getModel().getElementAt((int)index)).who instanceof RemoteDir) {
                size = ((DirEntry)list.getModel().getElementAt(index)).getDate();
                int x = 12 - size.length();
                for (int j = 0; j < x; ++j) {
                    size = size + " ";
                }
            } else if (Settings.showLocalDateNoSize && ((DirEntry)list.getModel().getElementAt((int)index)).who instanceof LocalDir) {
                size = ((DirEntry)list.getModel().getElementAt(index)).getDate();
                int x = 12 - size.length();
                for (int j = 0; j < x; ++j) {
                    size = size + " ";
                }
            }
            this.setText(size + s);
        } else {
            this.setFont(GUIDefaults.small);
            String s = value.toString();
            this.setText(s);
        }
        int ok = ((DirEntry)value).getPermission();
        if (ok == -666) {
            this.setForeground(GUIDefaults.deniedColor);
        } else if (ok == 42) {
            this.setForeground(GUIDefaults.writableColor);
        } else {
            this.setForeground(GUIDefaults.defaultColor);
        }
        if (((DirEntry)value).file.equals("..")) {
            this.setBackground(GUIDefaults.cdColor);
        }
        return this;
    }
}

