/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.base.dir;

import java.awt.Image;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.sf.jftp.config.Settings;
import net.sf.jftp.gui.framework.HImage;

public class DirEntry {
    public static final int R = 23;
    public static final int W = 42;
    public static final int DENIED = -666;
    static Hashtable extensionMap = new Hashtable();
    static final Object[] extensions = new Object[]{new String[]{Settings.textFileImage, ".txt", ".doc", ".rtf"}, new String[]{Settings.htmlFileImage, ".htm", ".html"}, new String[]{Settings.zipFileImage, ".arj", ".bz", ".bz2", ".deb", ".jar", ".gz", ".rav", ".rpm", ".tar", ".tgz", ".zip", ".z", ".iso"}, new String[]{Settings.imageFileImage, "bmp", ".gif", ".jpg", ".png", ".xbm", ".xpm"}, new String[]{Settings.codeFileImage, ".c", ".cc", ".h", ".java"}, new String[]{Settings.audioFileImage, ".au", ".mid", ".midi", ".mp3", ".wav"}, new String[]{Settings.execFileImage, ".bat", ".csh", ".cgi", ".com", ".class", ".cmd", ".csh", ".dtksh", ".exe", ".ksh", ".pdksh", ".pl", ".sh", ".tcl", ".tksh", ".zsh"}, new String[]{Settings.presentationFileImage, ".ppt"}, new String[]{Settings.spreadsheetFileImage, ".xls"}, new String[]{Settings.videoFileImage, ".asf", ".avi", ".mpg", "mpeg", ".wmf"}};
    public String file = "";
    private JLabel c = new JLabel();
    public boolean selected = false;
    public ActionListener who = null;
    private Image img;
    public boolean isFile = true;
    private boolean isDirectory = false;
    private long size = 0L;
    private long transferred = 0L;
    private boolean isLink = false;
    private int accessible = -1;
    private boolean noRender = false;
    public Date date = null;

    public DirEntry(String file, ActionListener who) {
        this.file = file;
        this.who = who;
        this.setFile();
    }

    public void setFile() {
        String ext;
        String tmp;
        String f = this.file;
        if (f.indexOf("<") >= 0 && f.indexOf(">") >= 0) {
            f = this.file.substring(this.file.indexOf("<") + 1);
            f = f.substring(0, f.lastIndexOf(">"));
        }
        int lastIndex = f.lastIndexOf(".");
        String image = Settings.fileImage;
        if (lastIndex != -1 && (tmp = (String)extensionMap.get((ext = f.substring(lastIndex)).toLowerCase())) != null) {
            image = tmp;
        }
        this.img = HImage.getImage(this.c, image);
        if (this.img == null) {
            this.img = HImage.getImage(this.c, Settings.fileImage);
        }
        this.isFile = true;
        this.isDirectory = false;
    }

    public void setDirectory() {
        this.img = HImage.getImage(this.c, Settings.dirImage);
        this.isFile = false;
        this.isDirectory = true;
    }

    public void setNoRender() {
        this.noRender = true;
    }

    public boolean getNoRender() {
        return this.noRender;
    }

    public void setPermission(int what) {
        this.accessible = what;
    }

    public int getPermission() {
        return this.accessible;
    }

    public void setSelected(boolean state) {
        this.selected = state;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public String toString() {
        return this.file;
    }

    public Image getImage() {
        return this.img;
    }

    public ImageIcon getImageIcon() {
        return new ImageIcon(this.img);
    }

    public void setDate(Date d) {
        this.date = d;
    }

    public String getDate() {
        if (this.date == null) {
            return "";
        }
        DateFormat df = DateFormat.getDateInstance(3);
        return df.format(this.date);
    }

    public void setFileSize(long s) {
        this.size = s;
    }

    public String getFileSize() {
        if (this.isDirectory() || this.size < 0L) {
            return "          ";
        }
        long rsize = this.size;
        String type = "bs";
        if (rsize > 1024L) {
            rsize /= 1024L;
            type = "kb";
        }
        if (rsize > 1024L) {
            rsize /= 1024L;
            type = "mb";
        }
        if (rsize > 1024L) {
            rsize /= 1024L;
            type = "gb";
        }
        String x = Long.toString(rsize);
        while (x.length() < 4) {
            x = " " + x;
        }
        return x + " " + type + " > ";
    }

    public long getRawSize() {
        return this.size;
    }

    public void setLink() {
        this.img = HImage.getImage(this.c, Settings.linkImage);
        this.file = this.file.substring(0, this.file.lastIndexOf("###"));
        this.isLink = true;
    }

    public boolean isLink() {
        return this.isLink;
    }

    public long getTransferred() {
        return this.transferred;
    }

    public void setTransferred(long transferred) {
        this.transferred = transferred;
    }

    static {
        for (int i = 0; i < extensions.length; ++i) {
            String[] temp = (String[])extensions[i];
            for (int j = 1; j < temp.length; ++j) {
                extensionMap.put(temp[j], temp[0]);
            }
        }
    }
}

