/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import net.sf.jftp.JFtp;
import net.sf.jftp.config.Settings;

public class LastConnections {
    public static String SENTINEL = new String("********************");
    private static JFtp jftp;

    public LastConnections(JFtp jftp) {
        LastConnections.jftp = jftp;
    }

    public static void writeToFile(String[][] a, int capacity) {
        try {
            File f1 = new File(Settings.appHomeDir);
            f1.mkdir();
            File f2 = new File(Settings.last_cons);
            f2.createNewFile();
            FileOutputStream fos = new FileOutputStream(Settings.last_cons);
            PrintStream out = new PrintStream(fos);
            for (int i = 0; i < capacity; ++i) {
                int j = 0;
                out.println(a[i][j]);
                while (j < 9 && !a[i][j].equals(SENTINEL)) {
                    out.println(a[i][++j]);
                }
            }
            jftp.updateMenuBar();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String[][] readFromFile(int capacity) {
        String[][] retVal = new String[capacity][10];
        try {
            int i;
            File f1 = new File(Settings.appHomeDir);
            f1.mkdir();
            File f2 = new File(Settings.last_cons);
            if (!f2.exists()) {
                LastConnections.init(capacity);
            }
            RandomAccessFile raf = new RandomAccessFile(f2, "r");
            String[] oldValues = new String[capacity];
            String firstSection = new String("");
            boolean oldVersion = true;
            for (i = 0; i < capacity; ++i) {
                if (capacity < 9) {
                    oldVersion = false;
                    break;
                }
                oldValues[i] = raf.readLine();
                firstSection = oldValues[i].substring(0, 3);
                if (!(firstSection.equals("FTP") || firstSection.equals("SFT") || firstSection.equals("SMB") || firstSection.equals("NFS") || firstSection.equals("nul"))) {
                    oldVersion = false;
                }
                if (!oldVersion) break;
            }
            raf = new RandomAccessFile(f2, "r");
            if (oldVersion) {
                for (i = 0; i < capacity; ++i) {
                    oldValues[i] = raf.readLine();
                }
                LastConnections.changeFile(oldValues);
            }
            raf = new RandomAccessFile(f2, "r");
            for (i = 0; i < capacity; ++i) {
                int j = 0;
                retVal[i][j] = raf.readLine();
                while (j < 10 && !retVal[i][j].equals(SENTINEL)) {
                    retVal[i][++j] = raf.readLine();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retVal;
    }

    public static String[][] prepend(String[] newString, int capacity, boolean newConnection) {
        int i;
        int j;
        String[][] lastCons = new String[capacity][10];
        lastCons = LastConnections.readFromFile(capacity);
        for (int i2 = 0; i2 < capacity; ++i2) {
            j = 0;
            while (!lastCons[i2][j].equals(SENTINEL)) {
                ++j;
            }
        }
        String[] temp = new String[10];
        j = 0;
        while (!lastCons[0][j].equals(SENTINEL)) {
            temp[j] = lastCons[0][j];
            ++j;
        }
        temp[j] = SENTINEL;
        j = 0;
        while (!newString[j].equals(SENTINEL)) {
            lastCons[0][j] = newString[j];
            ++j;
        }
        lastCons[0][j] = SENTINEL;
        ++j;
        while (j < 10) {
            lastCons[0][j] = "";
            ++j;
        }
        for (i = 0; i < capacity; ++i) {
            if (i + 1 == capacity) continue;
            j = 0;
            while (!temp[j].equals(SENTINEL)) {
                newString[j] = temp[j];
                ++j;
            }
            newString[j] = SENTINEL;
            j = 0;
            while (!lastCons[i + 1][j].equals(SENTINEL)) {
                temp[j] = lastCons[i + 1][j];
                ++j;
            }
            temp[j] = SENTINEL;
            j = 0;
            while (!newString[j].equals(SENTINEL)) {
                lastCons[i + 1][j] = newString[j];
                ++j;
            }
            lastCons[i + 1][j] = SENTINEL;
        }
        for (i = 0; i < capacity; ++i) {
            j = 0;
            while (!lastCons[i][j].equals(SENTINEL) && !lastCons[i][j].equals(SENTINEL)) {
                ++j;
            }
        }
        if (newConnection) {
            LastConnections.writeToFile(lastCons, capacity);
        }
        return lastCons;
    }

    public static String[][] moveToFront(int position, int capacity) {
        String[][] lastCons = new String[capacity][10];
        String[][] newLastCons = new String[capacity][10];
        lastCons = LastConnections.readFromFile(capacity);
        String[] temp = new String[10];
        int j = 0;
        temp[j] = lastCons[position][j];
        while (!lastCons[position][j].equals(SENTINEL)) {
            temp[++j] = lastCons[position][j];
        }
        j = 0;
        while (!lastCons[position][j].equals(SENTINEL)) {
            ++j;
        }
        newLastCons = LastConnections.prepend(temp, position + 1, false);
        for (int i = 0; i <= position; ++i) {
            j = 0;
            while (!newLastCons[i][j].equals(SENTINEL)) {
                lastCons[i][j] = newLastCons[i][j];
                ++j;
            }
            lastCons[i][j] = SENTINEL;
        }
        LastConnections.writeToFile(lastCons, capacity);
        return lastCons;
    }

    public static int findString(String[] findVal, int capacity) {
        String[][] lastCons = new String[capacity][10];
        lastCons = LastConnections.readFromFile(capacity);
        for (int i = 0; i < capacity; ++i) {
            int j;
            for (j = 0; j < 9 && findVal[j].equals(lastCons[i][j]) && !lastCons[i][j].equals(SENTINEL) && !findVal[j].equals(SENTINEL); ++j) {
            }
            if (!findVal[j].equals(lastCons[i][j])) continue;
            return i;
        }
        return -1;
    }

    private static void init(int capacity) {
        try {
            FileOutputStream fos = new FileOutputStream(Settings.last_cons);
            PrintStream out = new PrintStream(fos);
            for (int i = 0; i < capacity; ++i) {
                out.println("null");
                out.println(SENTINEL);
            }
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void changeFile(String[] oldValues) {
        String[][] newData = new String[9][10];
        for (int i = 0; i < 9; ++i) {
            StringTokenizer tokens = new StringTokenizer(oldValues[i], " ");
            int j = 0;
            while (tokens.hasMoreTokens()) {
                newData[i][j] = tokens.nextToken();
                ++j;
            }
            newData[i][j] = SENTINEL;
            if (!newData[i][0].equals("SFTP") || j != 5) continue;
            String temp = new String("");
            String temp2 = new String("");
            temp = newData[i][4];
            newData[i][4] = "22";
            temp2 = newData[i][5];
            newData[i][5] = temp;
            newData[i][6] = SENTINEL;
        }
        LastConnections.writeToFile(newData, 9);
    }
}

