/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class FilesystemConnection
implements BasicConnection {
    public static int filesystemBuffer = 128000;
    private String path = "";
    private String pwd = "";
    private Vector<ConnectionListener> listeners = new Vector();
    private String[] files;
    private String[] size = new String[0];
    private int[] perms = null;
    private String baseFile;
    private int fileCount;
    private boolean shortProgress = false;
    public Vector<Date> dateVector = new Vector();

    public FilesystemConnection() {
    }

    public FilesystemConnection(String path, ConnectionListener l) {
        this.listeners.add(l);
        this.chdir(path);
    }

    @Override
    public int removeFileOrDir(String file) {
        try {
            File f;
            if (file == null || file.equals("")) {
                return -1;
            }
            String tmp = file;
            if (StringUtils.isRelative(file)) {
                tmp = this.getPWD() + file;
            }
            if (!(f = new File(tmp)).getAbsolutePath().equals(f.getCanonicalPath()) && !f.delete()) {
                return -1;
            }
            if (f.exists() && f.isDirectory()) {
                this.cleanLocalDir(tmp);
            }
            if (!f.delete()) {
                Log.debug("Removal failed.");
                return -1;
            }
        }
        catch (IOException ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
        }
        return -1;
    }

    private void cleanLocalDir(String dir) {
        try {
            File f2;
            String[] tmp;
            dir = dir.replace('\\', '/');
            if (!dir.endsWith("/")) {
                dir = dir + "/";
            }
            if ((tmp = (f2 = new File(dir)).list()) == null) {
                return;
            }
            for (int i = 0; i < tmp.length; ++i) {
                File f3 = new File(dir + tmp[i]);
                if (!f3.getAbsolutePath().equals(f3.getCanonicalPath())) {
                    f3.delete();
                }
                if (f3.isDirectory()) {
                    this.cleanLocalDir(dir + tmp[i]);
                    f3.delete();
                    continue;
                }
                f3.delete();
            }
        }
        catch (IOException ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
        }
    }

    @Override
    public void sendRawCommand(String cmd) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public String getPWD() {
        return this.pwd;
    }

    @Override
    public boolean cdup() {
        return this.chdir(this.pwd.substring(0, this.pwd.lastIndexOf("/") + 1));
    }

    @Override
    public boolean mkdir(String dirName) {
        if (StringUtils.isRelative(dirName)) {
            dirName = this.getPWD() + dirName;
        }
        File f = new File(dirName);
        boolean x = f.mkdir();
        this.fireDirectoryUpdate();
        return x;
    }

    @Override
    public void list() throws IOException {
    }

    @Override
    public boolean chdir(String p) {
        String p2 = this.processPath(p);
        if (p2 == null) {
            return false;
        }
        File f = new File(p2);
        if (!(f.exists() && f.isDirectory() && f.canRead())) {
            Log.debug("Access denied.");
            return false;
        }
        this.pwd = p2;
        this.fireDirectoryUpdate();
        return true;
    }

    @Override
    public boolean chdirNoRefresh(String p) {
        String p2 = this.processPath(p);
        if (p2 == null) {
            return false;
        }
        this.pwd = p2;
        return true;
    }

    @Override
    public String getLocalPath() {
        return this.path;
    }

    public String processPath(String p) {
        File f;
        if (StringUtils.isRelative(p = p.replace('\\', '/'))) {
            p = this.pwd + p;
        }
        if ((f = new File(p = p.replace('\\', '/'))).exists()) {
            try {
                String p2 = f.getCanonicalPath();
                p2 = p2.replace('\\', '/');
                if (!p2.endsWith("/")) {
                    p2 = p2 + "/";
                }
                return p2;
            }
            catch (IOException ex) {
                Log.debug("Error: can not get pathname (processPath)!");
                return null;
            }
        }
        Log.debug("(processpPath) No such path: \"" + p + "\"");
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLocalPath(String p) {
        File f;
        if (StringUtils.isRelative(p = p.replace('\\', '/'))) {
            p = this.path + p;
        }
        if ((f = new File(p = p.replace('\\', '/'))).exists()) {
            try {
                this.path = f.getCanonicalPath();
                this.path = this.path.replace('\\', '/');
                if (this.path.endsWith("/")) return true;
                this.path = this.path + "/";
                return true;
            }
            catch (IOException ex) {
                Log.debug("Error: can not get pathname (local)!");
                return false;
            }
        } else {
            Log.out("(local) obsolete setLocalDir: \"" + p + "\"");
            return false;
        }
    }

    @Override
    public String[] sortLs() {
        this.dateVector = new Vector();
        File f = new File(this.pwd);
        this.files = f.list();
        if (this.files == null) {
            return new String[0];
        }
        this.size = new String[this.files.length];
        this.perms = new int[this.files.length];
        int accessible = 0;
        for (int i = 0; i < this.files.length; ++i) {
            File f2 = new File(this.pwd + this.files[i]);
            if (f2.isDirectory() && !this.files[i].endsWith("/")) {
                this.files[i] = this.files[i] + "/";
            }
            this.size[i] = "" + new File(this.pwd + this.files[i]).length();
            accessible = f2.canWrite() ? 42 : (f2.canRead() ? 23 : -666);
            this.perms[i] = accessible;
            Date d = new Date(f2.lastModified());
            this.dateVector.add(d);
        }
        return this.files;
    }

    @Override
    public String[] sortSize() {
        return this.size;
    }

    @Override
    public int[] getPermissions() {
        return this.perms;
    }

    @Override
    public int handleDownload(String file) {
        this.transfer(file);
        return 0;
    }

    @Override
    public int handleUpload(String file) {
        this.transfer(file);
        return 0;
    }

    @Override
    public int download(String file) {
        this.transfer(file);
        return 0;
    }

    @Override
    public int upload(String file) {
        this.transfer(file);
        return 0;
    }

    private void transferDir(String dir, String out) {
        this.fileCount = 0;
        this.shortProgress = true;
        this.baseFile = StringUtils.getDir(dir);
        File f2 = new File(dir);
        String[] tmp = f2.list();
        if (tmp == null) {
            return;
        }
        File fx = new File(out);
        if (!fx.mkdir()) {
            Log.debug("Can not create directory: " + out + " - already exist or permission denied?");
        }
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = tmp[i].replace('\\', '/');
            File f3 = new File(dir + tmp[i]);
            if (f3.isDirectory()) {
                if (!tmp[i].endsWith("/")) {
                    tmp[i] = tmp[i] + "/";
                }
                this.transferDir(dir + tmp[i], out + tmp[i]);
                continue;
            }
            this.fireProgressUpdate(this.baseFile, "DGET:" + this.fileCount, -1);
            this.work(dir + tmp[i], out + tmp[i]);
        }
        this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
        this.shortProgress = false;
    }

    private void transfer(String file) {
        String out = StringUtils.getDir(file);
        if (StringUtils.isRelative(file)) {
            file = this.getPWD() + file;
        }
        file = file.replace('\\', '/');
        out = out.replace('\\', '/');
        String outfile = StringUtils.getFile(file);
        if (file.endsWith("/")) {
            this.transferDir(file, this.getLocalPath() + out);
            return;
        }
        this.work(file, this.getLocalPath() + outfile);
    }

    private void work(String file, String outfile) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outfile));
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[filesystemBuffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                this.fireProgressUpdate(StringUtils.getFile(file), "GET", reallen += len);
            }
            out.flush();
            out.close();
            in.close();
            this.fireProgressUpdate(file, "FINISHED", -1);
        }
        catch (IOException ex) {
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
        }
    }

    @Override
    public int upload(String file, InputStream in) {
        if (StringUtils.isRelative(file)) {
            file = this.getPWD() + file;
        }
        file = file.replace('\\', '/');
        try {
            this.work(new BufferedInputStream(in), file, file);
            return 0;
        }
        catch (Exception ex) {
            Log.debug("Error: " + ex.toString());
            ex.printStackTrace();
            return -1;
        }
    }

    private void work(BufferedInputStream in, String outfile, String file) {
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outfile));
            byte[] buf = new byte[filesystemBuffer];
            int len = 0;
            int reallen = 0;
            while (true) {
                len = in.read(buf);
                System.out.print(".");
                if (len == -1) break;
                out.write(buf, 0, len);
                this.fireProgressUpdate(StringUtils.getFile(file), "GET", reallen += len);
            }
            out.flush();
            out.close();
            in.close();
            this.fireProgressUpdate(file, "FINISHED", -1);
        }
        catch (IOException ex) {
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
        }
    }

    @Override
    public InputStream getDownloadInputStream(String file) {
        if (StringUtils.isRelative(file)) {
            file = this.getPWD() + file;
        }
        file = file.replace('\\', '/');
        try {
            return new FileInputStream(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @Filesystemconnection::getDownloadInputStream");
            return null;
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.listeners.add(l);
        this.fireDirectoryUpdate();
    }

    @Override
    public void setConnectionListeners(Vector<ConnectionListener> l) {
        this.listeners = l;
        this.fireDirectoryUpdate();
    }

    public void fireDirectoryUpdate() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.elementAt(i).updateRemoteDirectory(this);
        }
    }

    public boolean login(String user, String pass) {
        return true;
    }

    public void fireProgressUpdate(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = this.listeners.elementAt(i);
            if (this.shortProgress && Settings.shortProgress) {
                if (type.startsWith("DFINISHED")) {
                    listener.updateProgress(this.baseFile, "DFINISHED:" + this.fileCount, bytes);
                }
                listener.updateProgress(this.baseFile, "DGET:" + this.fileCount, bytes);
                continue;
            }
            listener.updateProgress(file, type, bytes);
        }
    }

    @Override
    public Date[] sortDates() {
        if (this.dateVector.size() > 0) {
            return (Date[])this.dateVector.toArray();
        }
        return null;
    }

    @Override
    public boolean rename(String file, String to) {
        if (StringUtils.isRelative(file)) {
            file = this.getPWD() + file;
        }
        file = file.replace('\\', '/');
        File f = new File(file);
        if (StringUtils.isRelative(to)) {
            to = this.getPWD() + to;
        }
        to = to.replace('\\', '/');
        return f.renameTo(new File(to));
    }
}

