/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import net.sf.jftp.system.logging.Log;

public class FtpServerSocket
extends Thread {
    public static final int port = 21;
    public static final int dataPort = 20;
    private static ArrayList commands = null;
    private Socket socket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private Hashtable methods = new Hashtable();
    private File directory = new File(".");
    private ResourceBundle bundle = ResourceBundle.getBundle("responses", Locale.US);
    private ServerSocket pasvSocket = null;
    private boolean passive = false;
    private int activePort = 0;
    private String structure = "file";
    private String transferMode = "stream";
    private String type = "ascii";
    private String rootDir = null;
    private String currentDir = null;

    public FtpServerSocket(Socket s) throws IOException {
        this.socket = s;
        this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.out = new PrintWriter(this.socket.getOutputStream(), true);
        Method[] m = this.getClass().getDeclaredMethods();
        String methodName = null;
        for (int i = 0; i < m.length; ++i) {
            methodName = m[i].getName();
            if (!commands.contains(methodName)) continue;
            this.methods.put(methodName, m[i]);
        }
        this.start();
    }

    private void send(String bundleId) {
        this.out.print(this.bundle.getString(bundleId));
        this.out.flush();
    }

    private void send(String bundleId, Object[] args) {
        MessageFormat fmt = new MessageFormat(this.bundle.getString(bundleId));
        this.out.print(fmt.format(args));
        this.out.flush();
    }

    public void motd() {
        this.send("220motd");
    }

    public void user(String line) {
        this.send("331user");
    }

    public void pass(String line) {
        this.send("230pass");
    }

    public void syst(String line) {
        this.send("215syst");
    }

    public void type(String line) {
        Object[] args = new Object[]{"I"};
        this.send("200type", args);
    }

    public void stru(String line) {
        Object[] args = new Object[]{line.toUpperCase()};
        this.send("200ok", args);
    }

    public void mode(String line) {
        Object[] args = new Object[]{line.toUpperCase()};
        this.send("200ok", args);
    }

    public void rein(String line) {
        Object[] args = new Object[]{"REIN"};
        this.send("502", args);
    }

    public void smnt(String line) {
        Object[] args = new Object[]{"SMNT"};
        this.send("502", args);
    }

    public void quit(String line) {
        this.out.print("221-You have transferred 0 bytes in 0 files.\r\n");
        this.out.print("221-Total traffic for this session was 0 bytes in 0 transfers.\r\n");
        this.out.print("221 Thank you for using the FTP service on pikachu.\r\n");
        this.out.flush();
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pwd(String line) {
        Object[] args = new Object[]{this.currentDir};
        this.send("257pwd", args);
    }

    public void cwd(String line) {
        String arg = line.substring(4);
        String tmpDir = arg.startsWith("/") ? this.removeTrailingSlash(this.rootDir) + arg : this.addTrailingSlash(this.currentDir) + arg;
        File tmp = new File(tmpDir);
        if (tmp.exists() && tmp.isDirectory()) {
            this.currentDir = tmpDir;
            this.send("250cwd");
        } else {
            this.out.print("550 " + arg + ": No such file or directory.\r\n");
            this.out.flush();
        }
    }

    public void cdup(String line) {
        Object[] args = new Object[]{"CDUP"};
        File tmp = this.directory.getParentFile();
        if (tmp != null) {
            this.directory = tmp;
        }
        this.send("200", args);
    }

    public void noop(String line) {
        Object[] args = new Object[]{"NOOP"};
        this.send("200", args);
    }

    public void help(String line) {
        this.out.print("214-The following commands are recognized.\r\n");
        this.out.print("214 Direct comments to root@localhost.\r\n");
        this.out.flush();
    }

    public void stat(String line) {
        this.out.print("211-FTP server status:\r\n");
        this.out.print("211 End of status\r\n");
        this.out.flush();
    }

    private String addTrailingSlash(String s) {
        if (s.endsWith("/")) {
            return s;
        }
        return s + "/";
    }

    private String removeTrailingSlash(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    public void mkd(String line) {
        String arg = line.substring(4);
        arg = arg.startsWith("/") ? this.removeTrailingSlash(this.rootDir) + arg : this.addTrailingSlash(this.currentDir) + arg;
        File f = new File(arg);
        Object fmt = null;
        Object[] args = new Object[]{f.getAbsolutePath()};
        if (f.exists()) {
            this.send("521mkd", args);
        } else if (f.mkdirs()) {
            this.send("257mkd", args);
        } else {
            this.send("550mkd", args);
        }
    }

    public void feat(String line) {
        this.out.print("211-Extensions supported\r\n");
        this.out.print(" LANG EN*;FR\r\n");
        this.out.print("211 END\r\n");
        this.out.flush();
    }

    public void pasv(String line) {
        InetAddress address = this.socket.getLocalAddress();
        String pasvAddress = address.getHostAddress().replace('.', ',');
        try {
            this.pasvSocket = new ServerSocket(0, 5, address);
            this.passive = true;
        }
        catch (IOException ioe) {
            // empty catch block
        }
        int pasvPort = this.pasvSocket.getLocalPort();
        Object[] args = new Object[]{pasvAddress + "," + pasvPort / 256 + "," + pasvPort % 256};
        this.send("227pasv", args);
    }

    public void list(String line) {
        this.send("150list");
        if (!this.passive) {
            try {
                Socket activeSocket = new Socket(this.socket.getInetAddress(), this.activePort);
                PrintStream ps = new PrintStream(activeSocket.getOutputStream());
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.flush();
                ps.close();
                this.send("226");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void nlst(String line) {
        this.send("150nlst");
        if (!this.passive) {
            try {
                Socket activeSocket = new Socket(this.socket.getInetAddress(), this.activePort);
                PrintStream ps = new PrintStream(activeSocket.getOutputStream());
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.print("bleah\r\n");
                ps.flush();
                ps.close();
                this.send("225");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void port(String line) {
        int start = line.lastIndexOf(",");
        int end = line.length();
        String lo = null;
        if (start != -1 && end != -1) {
            lo = line.substring(start + 1, end);
        }
        end = start;
        start = line.lastIndexOf(",", start - 1);
        String hi = null;
        if (start != -1 && end != -1) {
            hi = line.substring(start + 1, end);
        }
        this.activePort = Integer.parseInt(hi) * 256 + Integer.parseInt(lo);
        Object[] args = new Object[]{"PORT"};
        this.send("200", args);
    }

    public void opts(String line) {
    }

    public void lang(String line) {
        this.out.print("200 Responses changed to english\r\n");
        this.out.flush();
    }

    public void auth(String line) {
    }

    public void setRoot(String line) {
        if (new File(line).exists()) {
            this.rootDir = line;
        } else {
            System.err.println("invalid root directory");
        }
    }

    @Override
    public void run() {
        try {
            String line = null;
            this.motd();
            while ((line = this.in.readLine()) != null) {
                String command;
                Method o;
                System.out.println(line);
                int index = line.indexOf(32);
                if (index == -1) {
                    index = line.length();
                }
                if ((o = (Method)this.methods.get(command = line.substring(0, index).toLowerCase())) != null) {
                    try {
                        o.invoke((Object)this, line);
                    }
                    catch (Exception e) {}
                    continue;
                }
                this.send("500");
            }
        }
        catch (IOException ioe) {
            Log.debug("Socket error: " + ioe);
        }
    }

    public static void main(String[] args) {
    }

    static {
        commands = new ArrayList();
        commands.add("auth");
        commands.add("cdup");
        commands.add("cwd");
        commands.add("feat");
        commands.add("help");
        commands.add("lang");
        commands.add("list");
        commands.add("mkd");
        commands.add("mode");
        commands.add("motd");
        commands.add("nlst");
        commands.add("noop");
        commands.add("opts");
        commands.add("pass");
        commands.add("pasv");
        commands.add("port");
        commands.add("pwd");
        commands.add("quit");
        commands.add("rein");
        commands.add("smnt");
        commands.add("stat");
        commands.add("stru");
        commands.add("syst");
        commands.add("type");
        commands.add("user");
    }
}

