/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.net.wrappers;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Vector;
import jcifs.smb.NtlmAuthenticator;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileOutputStream;
import net.sf.jftp.config.Settings;
import net.sf.jftp.net.BasicConnection;
import net.sf.jftp.net.ConnectionListener;
import net.sf.jftp.net.wrappers.SmbTransfer;
import net.sf.jftp.system.StringUtils;
import net.sf.jftp.system.logging.Log;

public class SmbConnection
extends NtlmAuthenticator
implements BasicConnection {
    public static int smbBuffer = 128000;
    private String path = "";
    private String pwd = "smb://";
    private Vector listeners = new Vector();
    private String[] files;
    private String[] size = new String[0];
    private int[] perms = null;
    private String user;
    private String pass;
    private String host;
    private String domain = null;
    private String baseFile;
    private int fileCount;
    private boolean isDirUpload = false;
    private boolean shortProgress = false;
    private boolean dummy = false;

    public SmbConnection() {
    }

    public SmbConnection(String url, String domain, String user, String pass, ConnectionListener l) {
        if (l != null) {
            this.listeners.add(l);
        }
        this.user = user;
        this.pass = pass;
        if (domain.equals("NONE")) {
            domain = null;
        }
        this.domain = domain;
        if (url.equals("(LAN)")) {
            this.chdir(this.getPWD());
        } else {
            this.chdir(url);
        }
    }

    @Override
    protected NtlmPasswordAuthentication getNtlmPasswordAuthentication() {
        try {
            return new NtlmPasswordAuthentication(this.domain, this.user, this.pass);
        }
        catch (Exception ex) {
            Log.debug("Error logging in: " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    private NtlmPasswordAuthentication getAuth() {
        return this.getNtlmPasswordAuthentication();
    }

    @Override
    public int removeFileOrDir(String file) {
        file = this.toSMB(file);
        try {
            SmbFile f = new SmbFile(file, this.getAuth());
            if (f.exists() && f.isDirectory()) {
                this.cleanSmbDir(file);
            }
            f.delete();
        }
        catch (Exception ex) {
            Log.debug("Removal failed (" + ex + ").");
            return -1;
        }
        return 1;
    }

    private void cleanSmbDir(String dir) throws Exception {
        SmbFile f2 = new SmbFile(dir = this.toSMB(dir), this.getAuth());
        String[] tmp = f2.list();
        if (tmp == null) {
            return;
        }
        for (int i = 0; i < tmp.length; ++i) {
            SmbFile f3 = new SmbFile(dir + tmp[i], this.getAuth());
            if (f3.isDirectory()) {
                this.cleanSmbDir(dir + tmp[i]);
                f3.delete();
                continue;
            }
            f3.delete();
        }
    }

    @Override
    public void sendRawCommand(String cmd) {
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public String getPWD() {
        return this.toSMB(this.pwd);
    }

    @Override
    public boolean cdup() {
        String tmp = this.pwd;
        if (this.pwd.endsWith("/") && !this.pwd.equals("smb://")) {
            tmp = this.pwd.substring(0, this.pwd.lastIndexOf("/"));
        }
        return this.chdir(tmp.substring(0, tmp.lastIndexOf("/") + 1));
    }

    @Override
    public boolean mkdir(String dirName) {
        try {
            if (!dirName.endsWith("/")) {
                dirName = dirName + "/";
            }
            dirName = this.toSMB(dirName);
            SmbFile f = new SmbFile(dirName, this.getAuth());
            f.mkdir();
            this.fireDirectoryUpdate();
            return true;
        }
        catch (Exception ex) {
            Log.debug("Failed to create directory (" + ex + ").");
            return false;
        }
    }

    @Override
    public void list() throws IOException {
    }

    @Override
    public boolean chdir(String p) {
        return this.chdir(p, true);
    }

    public boolean chdir(String p, boolean refresh) {
        try {
            if (p.endsWith("..")) {
                return this.cdup();
            }
            String tmp = this.toSMB(p);
            if (!tmp.endsWith("/")) {
                tmp = tmp + "/";
            }
            SmbFile f = new SmbFile(tmp, this.getAuth());
            f.list();
            this.pwd = tmp;
            if (refresh) {
                this.fireDirectoryUpdate();
            }
            this.dummy = false;
            return true;
        }
        catch (Exception ex) {
            if (ex.getMessage().indexOf("MSBROWSE") > 0 && !this.dummy) {
                Log.debug("\nCould not find a master server.");
                Log.debug("Please make sure you have the local IP set to the interface you want to use, and if");
                Log.debug("that does not work try \"<default>\"...");
                Log.debug("If you still can not find a master make sure that there is one your LAN and submit a bug report.");
                this.dummy = true;
            } else {
                Log.debug("Could not change directory (" + ex + ").");
            }
            return false;
        }
    }

    @Override
    public boolean chdirNoRefresh(String p) {
        return this.chdir(p, false);
    }

    @Override
    public String getLocalPath() {
        return this.path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setLocalPath(String p) {
        File f;
        if (StringUtils.isRelative(p)) {
            p = this.path + p;
        }
        if ((f = new File(p = p.replace('\\', '/'))).exists()) {
            try {
                this.path = f.getCanonicalPath();
                this.path = this.path.replace('\\', '/');
                if (this.path.endsWith("/")) return true;
                this.path = this.path + "/";
                return true;
            }
            catch (IOException ex) {
                Log.debug("Error: can not get pathname (local)!");
                return false;
            }
        } else {
            Log.debug("(local) No such path: \"" + p + "\"");
            return false;
        }
    }

    @Override
    public String[] sortLs() {
        try {
            this.chdirNoRefresh(this.getPWD());
            SmbFile fx = new SmbFile(this.pwd, this.getAuth());
            SmbFile[] f = fx.listFiles();
            this.files = new String[f.length];
            this.size = new String[f.length];
            this.perms = new int[f.length];
            for (int i = 0; i < f.length; ++i) {
                this.files[i] = f[i].toURL().toString();
                int x = 0;
                for (int j = 0; j < this.files[i].length(); ++j) {
                    if (this.files[i].charAt(j) != '/') continue;
                    ++x;
                }
                if (this.files[i].endsWith("/") && x > 3) {
                    this.files[i] = StringUtils.getDir(this.files[i]);
                } else if (x > 3) {
                    this.files[i] = StringUtils.getFile(this.files[i]);
                }
                this.size[i] = "" + f[i].length();
                this.perms[i] = f[i].canRead() ? 23 : (f[i].canWrite() ? 23 : -666);
            }
            return this.files;
        }
        catch (Exception ex) {
            if (ex instanceof SmbAuthException) {
                Log.debug("Access denied: " + ex);
            } else {
                Log.debug("Error: " + ex);
            }
            return new String[0];
        }
    }

    @Override
    public String[] sortSize() {
        return this.size;
    }

    @Override
    public int[] getPermissions() {
        return this.perms;
    }

    @Override
    public int handleUpload(String f) {
        if (Settings.getEnableSmbMultiThreading()) {
            SmbTransfer smbTransfer = new SmbTransfer(this.getPWD(), this.getLocalPath(), f, this.user, this.pass, this.domain, this.listeners, "UPLOAD");
        } else {
            this.upload(f);
        }
        return 0;
    }

    @Override
    public int handleDownload(String f) {
        if (Settings.getEnableSmbMultiThreading()) {
            SmbTransfer smbTransfer = new SmbTransfer(this.getPWD(), this.getLocalPath(), f, this.user, this.pass, this.domain, this.listeners, "DOWNLOAD");
        } else {
            this.download(f);
        }
        return 0;
    }

    @Override
    public int upload(String f) {
        String file = this.toSMB(f);
        if (file.endsWith("/")) {
            String out = StringUtils.getDir(file);
            this.uploadDir(file, this.getLocalPath() + out);
            this.fireActionFinished(this);
        } else {
            String outfile = StringUtils.getFile(file);
            this.work(this.getLocalPath() + outfile, file);
            this.fireActionFinished(this);
        }
        return 0;
    }

    @Override
    public int download(String f) {
        String file = this.toSMB(f);
        if (file.endsWith("/")) {
            String out = StringUtils.getDir(file);
            this.downloadDir(file, this.getLocalPath() + out);
            this.fireActionFinished(this);
        } else {
            String outfile = StringUtils.getFile(file);
            this.work(file, this.getLocalPath() + outfile);
            this.fireActionFinished(this);
        }
        return 0;
    }

    private void downloadDir(String dir, String out) {
        try {
            this.fileCount = 0;
            this.shortProgress = true;
            this.baseFile = StringUtils.getDir(dir);
            SmbFile f2 = new SmbFile(dir, this.getAuth());
            String[] tmp = f2.list();
            if (tmp == null) {
                return;
            }
            File fx = new File(out);
            fx.mkdir();
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = tmp[i].replace('\\', '/');
                SmbFile f3 = new SmbFile(dir + tmp[i], this.getAuth());
                if (f3.isDirectory()) {
                    if (!tmp[i].endsWith("/")) {
                        tmp[i] = tmp[i] + "/";
                    }
                    this.downloadDir(dir + tmp[i], out + tmp[i]);
                    continue;
                }
                ++this.fileCount;
                this.fireProgressUpdate(this.baseFile, "DGET:" + this.fileCount, -1);
                this.work(dir + tmp[i], out + tmp[i]);
            }
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Transfer error: " + ex);
            this.fireProgressUpdate(this.baseFile, "FAILED:" + this.fileCount, -1);
        }
        this.shortProgress = false;
    }

    private void uploadDir(String dir, String out) {
        try {
            this.isDirUpload = true;
            this.fileCount = 0;
            this.shortProgress = true;
            this.baseFile = StringUtils.getDir(dir);
            File f2 = new File(out);
            String[] tmp = f2.list();
            if (tmp == null) {
                return;
            }
            SmbFile fx = new SmbFile(dir, this.getAuth());
            fx.mkdir();
            for (int i = 0; i < tmp.length; ++i) {
                tmp[i] = tmp[i].replace('\\', '/');
                File f3 = new File(out + tmp[i]);
                if (f3.isDirectory()) {
                    if (!tmp[i].endsWith("/")) {
                        tmp[i] = tmp[i] + "/";
                    }
                    this.uploadDir(dir + tmp[i], out + tmp[i]);
                    continue;
                }
                ++this.fileCount;
                this.fireProgressUpdate(this.baseFile, "DPUT:" + this.fileCount, -1);
                this.work(out + tmp[i], dir + tmp[i]);
            }
            this.fireProgressUpdate(this.baseFile, "DFINISHED:" + this.fileCount, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug("Transfer error: " + ex);
            this.fireProgressUpdate(this.baseFile, "FAILED:" + this.fileCount, -1);
        }
        this.isDirUpload = false;
        this.shortProgress = true;
    }

    private String toSMB(String f) {
        if (f.lastIndexOf("smb://") > 0) {
            f = f.substring(f.lastIndexOf("smb://"));
        }
        String file = f.startsWith("smb://") ? f : this.getPWD() + f;
        file = file.replace('\\', '/');
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work(String file, String outfile) {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            boolean outflag = false;
            if (outfile.startsWith("smb://")) {
                outflag = true;
                out = new BufferedOutputStream(new SmbFileOutputStream(new SmbFile(outfile, this.getAuth())));
            } else {
                out = new BufferedOutputStream(new FileOutputStream(outfile));
            }
            in = file.startsWith("smb://") ? new BufferedInputStream(new SmbFile(file, this.getAuth()).getInputStream()) : new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[smbBuffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                reallen += len;
                if (outflag) {
                    this.fireProgressUpdate(StringUtils.getFile(outfile), "PUT", reallen);
                    continue;
                }
                this.fireProgressUpdate(StringUtils.getFile(file), "GET", reallen);
            }
            this.fireProgressUpdate(file, "FINISHED", -1);
        }
        catch (IOException ex) {
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void update(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.listeners.elementAt(i);
            listener.updateProgress(file, type, bytes);
        }
    }

    @Override
    public void addConnectionListener(ConnectionListener l) {
        this.listeners.add(l);
    }

    public void setConnectionListeners(Vector l) {
        this.listeners = l;
    }

    public void fireDirectoryUpdate() {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).updateRemoteDirectory(this);
        }
    }

    public boolean login(String user, String pass) {
        return true;
    }

    public void fireProgressUpdate(String file, String type, int bytes) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ConnectionListener listener = (ConnectionListener)this.listeners.elementAt(i);
            if (this.shortProgress && Settings.shortProgress) {
                if (type.startsWith("DFINISHED")) {
                    listener.updateProgress(this.baseFile, "DFINISHED:" + this.fileCount, bytes);
                    continue;
                }
                if (this.isDirUpload) {
                    listener.updateProgress(this.baseFile, "DPUT:" + this.fileCount, bytes);
                    continue;
                }
                listener.updateProgress(this.baseFile, "DGET:" + this.fileCount, bytes);
                continue;
            }
            listener.updateProgress(file, type, bytes);
        }
    }

    public void fireActionFinished(SmbConnection con) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ConnectionListener)this.listeners.elementAt(i)).actionFinished(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int upload(String file, InputStream i) {
        BufferedOutputStream out = null;
        BufferedInputStream in = null;
        try {
            file = this.toSMB(file);
            out = new BufferedOutputStream(new SmbFileOutputStream(new SmbFile(file, this.getAuth())));
            in = new BufferedInputStream(i);
            byte[] buf = new byte[smbBuffer];
            int len = 0;
            int reallen = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                this.fireProgressUpdate(StringUtils.getFile(file), "PUT", reallen += len);
            }
            this.fireProgressUpdate(file, "FINISHED", -1);
            int n = 0;
            return n;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Log.debug("Error with file IO (" + ex + ")!");
            this.fireProgressUpdate(file, "FAILED", -1);
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return -1;
    }

    @Override
    public InputStream getDownloadInputStream(String file) {
        file = this.toSMB(file);
        try {
            return new BufferedInputStream(new SmbFile(file, this.getAuth()).getInputStream());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @SmbConnection::getDownloadInputStream");
            return null;
        }
    }

    @Override
    public Date[] sortDates() {
        return null;
    }

    @Override
    public boolean rename(String file, String to) {
        try {
            file = this.toSMB(file);
            to = this.toSMB(to);
            SmbFile src = new SmbFile(file, this.getAuth());
            src.renameTo(new SmbFile(to, this.getAuth()));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Log.debug(ex.toString() + " @SmbConnection::rename");
            return false;
        }
    }
}

