/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jftp.system.logging.Log;

public class ZipFileCreator {
    private ZipOutputStream z;

    public ZipFileCreator(String[] files, String path, String name) throws Exception {
        this.z = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(path + name)));
        this.perform(files, path, "");
        this.z.finish();
        this.z.flush();
        this.z.close();
    }

    private void perform(String[] files, String path, String offset) {
        byte[] buf = new byte[4096];
        for (int i = 0; i < files.length; ++i) {
            try {
                File f = new File(path + offset + files[i]);
                BufferedInputStream in = null;
                if (f.exists() && !f.isDirectory()) {
                    in = new BufferedInputStream(new FileInputStream(path + offset + files[i]));
                } else if (f.exists()) {
                    if (!files[i].endsWith("/")) {
                        files[i] = files[i] + "/";
                    }
                    this.perform(f.list(), path, offset + files[i]);
                }
                ZipEntry tmp = new ZipEntry(offset + files[i]);
                this.z.putNextEntry(tmp);
                int len = 0;
                while (in != null && len != -1 && (len = in.read(buf)) != -1) {
                    this.z.write(buf, 0, len);
                }
                this.z.closeEntry();
                continue;
            }
            catch (Exception ex) {
                Log.debug("Skipping a file (no permission?)");
            }
        }
    }
}

