/*
 * Decompiled with CFR 0.152.
 */
package org.objenesis.tck;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.objenesis.Objenesis;
import org.objenesis.strategy.PlatformDescription;
import org.objenesis.tck.AbstractLoader;
import org.objenesis.tck.Candidate;
import org.objenesis.tck.CandidateLoader;
import org.objenesis.tck.Reporter;
import org.objenesis.tck.features.Feature;

public class TCK {
    private final Objenesis objenesisStandard;
    private final Objenesis objenesisSerializer;
    private final Reporter reporter;
    private final List<Candidate> candidates = new ArrayList<Candidate>();

    public TCK(Objenesis objenesisStandard, Objenesis objenesisSerializer, Reporter reporter) {
        this.objenesisStandard = objenesisStandard;
        this.objenesisSerializer = objenesisSerializer;
        this.reporter = reporter;
        try {
            this.loadCandidates();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Collections.sort(this.candidates);
    }

    protected void loadCandidates() throws IOException {
        CandidateLoader candidateLoader = new CandidateLoader(this, (AbstractLoader.ErrorHandler)new AbstractLoader.LoggingErrorHandler(System.err));
        candidateLoader.loadFromResource("org/objenesis/tck/candidates/standard-candidates.properties", Candidate.CandidateType.STANDARD);
        candidateLoader.loadFromResource("org/objenesis/tck/candidates/serializable-candidates.properties", Candidate.CandidateType.SERIALIZATION);
    }

    public void registerCandidate(Class<?> candidateClass, String description, Candidate.CandidateType type) {
        Candidate candidate = new Candidate(candidateClass, description, type);
        int index = this.candidates.indexOf(candidate);
        if (index >= 0) {
            Candidate existingCandidate = this.candidates.get(index);
            if (!description.equals(existingCandidate.getDescription())) {
                throw new IllegalStateException("Two different descriptions for candidate " + candidateClass.getName());
            }
            existingCandidate.getTypes().add(type);
        } else {
            this.candidates.add(candidate);
        }
    }

    public void runTests() {
        this.reporter.startTests(this.describePlatform(), this.objenesisStandard, this.objenesisSerializer);
        for (Candidate candidate : this.candidates) {
            this.reporter.startTest(candidate);
            if (candidate.getTypes().contains((Object)Candidate.CandidateType.STANDARD)) {
                this.runTest(this.reporter, candidate.getClazz(), this.objenesisStandard, Candidate.CandidateType.STANDARD);
            }
            if (!candidate.getTypes().contains((Object)Candidate.CandidateType.SERIALIZATION)) continue;
            this.runTest(this.reporter, candidate.getClazz(), this.objenesisSerializer, Candidate.CandidateType.SERIALIZATION);
        }
        this.reporter.endTests();
    }

    private void runTest(Reporter reporter, Class<?> candidate, Objenesis objenesis, Candidate.CandidateType type) {
        if (Feature.class.isAssignableFrom(candidate)) {
            this.runFeature(reporter, candidate, objenesis, type);
        } else {
            this.runCandidate(reporter, candidate, objenesis, type);
        }
    }

    private void runFeature(Reporter reporter, Class<?> clazz, Objenesis objenesis, Candidate.CandidateType type) {
        try {
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            Feature feature = (Feature)constructor.newInstance(new Object[0]);
            boolean compliant = feature.isCompliant(objenesis);
            reporter.result(type, compliant);
        }
        catch (Exception e) {
            reporter.exception(type, e);
        }
    }

    private void runCandidate(Reporter reporter, Class<?> candidate, Objenesis objenesis, Candidate.CandidateType type) {
        try {
            Object instance = objenesis.newInstance(candidate);
            boolean success = instance != null && instance.getClass() == candidate;
            reporter.result(type, success);
        }
        catch (Exception e) {
            reporter.exception(type, e);
        }
    }

    protected String describePlatform() {
        return PlatformDescription.describePlatform();
    }
}

