/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.collection;

import de.esoco.lib.datatype.Pair;
import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.CollectionFunctions;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.text.TextUtil;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.filter.RelationComparator;

public class CollectionUtil {
    public static Comparator<Enum<?>> ENUM_COMPARATOR = new Comparator<Enum<?>>(){

        @Override
        public int compare(Enum<?> e1, Enum<?> e2) {
            return e1.name().compareTo(e2.name());
        }
    };
    private static final BinaryFunction<?, ?, ?> COLLECT = CollectionFunctions.collect(null);
    private static final BinaryFunction<?, ?, ?> FIND = CollectionFunctions.find(null);
    private static final BinaryFunction<?, ?, ?> MAP = CollectionFunctions.map(null);
    private static final BinaryFunction<?, ?, ?> CREATE_MAP = CollectionFunctions.createMap(null);

    private CollectionUtil() {
    }

    @SafeVarargs
    public static <T, C extends Collection<? super T>> C add(C rCollection, T ... rValues) {
        for (T value : rValues) {
            rCollection.add(value);
        }
        return rCollection;
    }

    public static <T, C extends Collection<? super T>> C add(C collection, int count, T value) {
        while (count-- > 0) {
            collection.add(value);
        }
        return collection;
    }

    public static <T, C extends Collection<T>> C addAll(C rCollection, Iterable<T> rValues) {
        for (T value : rValues) {
            rCollection.add(value);
        }
        return rCollection;
    }

    public static <K, V> void addMapEntry(Map<K, V> rTargetMap, String sEntry, Class<K> rKeyType, Class<V> rValueType) {
        Matcher aMatcher = CollectionUtil.splitMapEntry(sEntry);
        Object aKey = TextUtil.parseObject(aMatcher.group(1));
        Object aValue = TextUtil.parseObject(aMatcher.group(2));
        rTargetMap.put(rKeyType.cast(aKey), rValueType.cast(aValue));
    }

    public static <T> void apply(Collection<T> rValues, Function<? super T, ?> fFunction) {
        for (T value : rValues) {
            fFunction.evaluate(value);
        }
    }

    public static <T, C extends Collection<T>> C collect(C rCollection, Predicate<? super T> pCollect) {
        return (C)((Collection)COLLECT.evaluate(rCollection, pCollect));
    }

    public static <K, V, C extends Collection<? extends K>> List<V> collect(Map<K, V> rFromMap, C rKeys) {
        ArrayList<V> rValues = new ArrayList<V>();
        for (K rKey : rKeys) {
            if (!rFromMap.containsKey(rKey)) continue;
            rValues.add(rFromMap.get(rKey));
        }
        return rValues;
    }

    public static <K, V> Map<K, List<V>> collect(List<V> rInput, Function<? super V, K> fKey, Comparator<? super V> rComparator) {
        HashMap aMap;
        if (rComparator != null) {
            Collections.sort(rInput, rComparator);
            aMap = new LinkedHashMap();
        } else {
            aMap = new HashMap();
        }
        for (V value : rInput) {
            CollectionUtil.collectInto(aMap, fKey.evaluate(value), value);
        }
        return aMap;
    }

    public static <K, V> void collectInto(Map<K, List<V>> rMap, K rKey, V value) {
        List<V> rValues = rMap.get(rKey);
        if (rValues == null) {
            rValues = new ArrayList<V>();
            rMap.put(rKey, rValues);
        }
        rValues.add(value);
    }

    @SafeVarargs
    public static <T, C extends Collection<T>> C combine(C rCollection, T ... rValues) {
        return CollectionUtil.combine(rCollection, Arrays.asList(rValues), new Collection[0]);
    }

    @SafeVarargs
    public static <T, C extends Collection<T>> C combine(C rFirst, Collection<? extends T> rSecond, Collection<? extends T> ... rAdditional) {
        C aNewCollection = CollectionUtil.newCollectionLike(rFirst);
        aNewCollection.addAll(rFirst);
        aNewCollection.addAll(rSecond);
        for (Collection<? extends T> rCollection : rAdditional) {
            aNewCollection.addAll(rCollection);
        }
        return aNewCollection;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> combine(Map<K, V> rFirst, Map<? extends K, ? extends V> rSecond, Map<? extends K, ? extends V> ... rAdditional) {
        int count = rFirst.size() + rSecond.size();
        HashMap aNewMap = rFirst instanceof LinkedHashMap ? new LinkedHashMap(count) : new HashMap(count);
        aNewMap.putAll(rFirst);
        aNewMap.putAll(rSecond);
        for (Map<? extends K, ? extends V> rMap : rAdditional) {
            aNewMap.putAll(rMap);
        }
        return aNewMap;
    }

    public static <T> boolean contains(T[] rArray, T rSearch) {
        for (T rElement : rArray) {
            if (rElement != rSearch) continue;
            return true;
        }
        return false;
    }

    public static <T> void convert(List<T> rValues, Function<? super T, ? extends T> fConversion) {
        for (int i = 0; i < rValues.size(); ++i) {
            rValues.set(i, fConversion.evaluate(rValues.get(i)));
        }
    }

    public static <K, V, C extends Collection<V>> Map<K, Integer> count(C rInput, Function<? super V, K> fKey) {
        HashMap<K, Integer> aCountMap = new HashMap<K, Integer>();
        for (V value : rInput) {
            K aKey = fKey.evaluate(value);
            Integer rCount = (Integer)aCountMap.get(aKey);
            if (rCount == null) {
                rCount = 0;
            }
            aCountMap.put(aKey, rCount + 1);
        }
        return aCountMap;
    }

    public static <K, V, C extends Collection<V>> Map<K, V> createMap(C rCollection, Function<? super V, K> fKey) {
        return (Map)CREATE_MAP.evaluate(rCollection, fKey);
    }

    public static <E extends Enum<E>> Comparator<E> enumComparator() {
        return ENUM_COMPARATOR;
    }

    public static <T> T find(Collection<T> rCollection, Predicate<? super T> pCriteria) {
        return (T)FIND.evaluate(rCollection, pCriteria);
    }

    public static <T> T firstElementOf(Iterable<T> rIterable) {
        Iterator<T> rIterator = rIterable.iterator();
        T rResult = null;
        if (rIterator.hasNext()) {
            rResult = rIterator.next();
        }
        return rResult;
    }

    @SafeVarargs
    public static <T> List<T> fixedListOf(T ... rValues) {
        return Collections.unmodifiableList(Arrays.asList(rValues));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> fixedMapOf(Pair<K, V> ... rEntries) {
        return Collections.unmodifiableMap(CollectionUtil.mapOf(rEntries));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> fixedOrderedMapOf(Pair<K, V> ... rEntries) {
        return Collections.unmodifiableMap(CollectionUtil.orderedMapOf(rEntries));
    }

    @SafeVarargs
    public static <T> Set<T> fixedOrderedSetOf(T ... rValues) {
        return Collections.unmodifiableSet(CollectionUtil.orderedSetOf(rValues));
    }

    @SafeVarargs
    public static <T> Set<T> fixedSetOf(T ... rValues) {
        return Collections.unmodifiableSet(CollectionUtil.setOf(rValues));
    }

    public static <T, C extends Collection<T>> T get(C rCollection, int nIndex) {
        if (nIndex < 0 || nIndex >= rCollection.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + nIndex);
        }
        for (T value : rCollection) {
            if (nIndex-- != 0) continue;
            return value;
        }
        return null;
    }

    public static <T, C extends Collection<T>> int indexOf(C rCollection, T rElement) {
        int nIndex = -1;
        for (T value : rCollection) {
            ++nIndex;
            if (rElement != value) continue;
            break;
        }
        return nIndex;
    }

    @SafeVarargs
    public static <T, L extends List<? super T>> void insert(L rList, T rBeforeValue, T ... rNewValues) {
        CollectionUtil.insert(rList, rBeforeValue, Arrays.asList(rNewValues));
    }

    public static <T, L extends List<? super T>> void insert(L rList, T rBeforeValue, Collection<T> rNewValues) {
        int nPos = rList.indexOf(rBeforeValue);
        if (nPos == -1) {
            nPos = rList.size();
        }
        rList.addAll(nPos, rNewValues);
    }

    public static <T, C extends Collection<T>> C intersect(C rFirst, C rSecond) {
        C aResult = CollectionUtil.newCollectionLike(rFirst);
        for (T value : rFirst) {
            if (!rSecond.contains(value)) continue;
            aResult.add(value);
        }
        return aResult;
    }

    public static boolean intersects(Collection<?> rFirst, Collection<?> rSecond) {
        for (Object rObject : rSecond) {
            if (!rFirst.contains(rObject)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> T[] join(T[] rArray, T ... rAdd) {
        Object[] aResult = (Object[])Array.newInstance(rArray.getClass().getComponentType(), rArray.length + rAdd.length);
        System.arraycopy(rArray, 0, aResult, 0, rArray.length);
        System.arraycopy(rAdd, 0, aResult, rArray.length, rAdd.length);
        return aResult;
    }

    @SafeVarargs
    public static <T> T[] join(T[] rFirst, T[] rSecond, T[] ... rArrays) {
        T[] aResult = CollectionUtil.join(rFirst, rSecond);
        for (T[] rArray : rArrays) {
            aResult = CollectionUtil.join(aResult, rArray);
        }
        return aResult;
    }

    public static <T> List<T> listOf(Iterable<T> rValues) {
        return CollectionUtil.addAll(new ArrayList(), rValues);
    }

    @SafeVarargs
    public static <T> List<T> listOf(T ... rValues) {
        return CollectionUtil.add(new ArrayList(), rValues);
    }

    public static <I, O, C extends Collection<I>> Collection<O> map(C rCollection, Function<? super I, O> fMapping) {
        return (Collection)MAP.evaluate(rCollection, fMapping);
    }

    public static <I, O, L extends List<I>> List<O> map(L rList, Function<? super I, O> fMapping) {
        return (List)MAP.evaluate(rList, fMapping);
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mapOf(Pair<K, V> ... rEntries) {
        HashMap<Object, Object> aMap = new HashMap<Object, Object>(rEntries.length);
        for (Pair<K, V> rEntry : rEntries) {
            aMap.put(rEntry.first(), rEntry.second());
        }
        return aMap;
    }

    public static <T, C extends Collection<T>> C newCollectionLike(C rCollection) {
        AbstractCollection rResult = rCollection instanceof List ? new ArrayList() : (rCollection instanceof LinkedHashSet ? new LinkedHashSet() : (rCollection instanceof TreeSet ? new TreeSet() : (rCollection instanceof LinkedList ? new LinkedList() : (rCollection instanceof Set ? new HashSet() : new LinkedHashSet()))));
        return (C)rResult;
    }

    public static <E> E next(Collection<E> rCollection, E rElement, boolean bWrap) {
        Iterator<E> i = rCollection.iterator();
        E rFirst = null;
        while (i.hasNext()) {
            E rCurrent = i.next();
            if (rFirst == null) {
                rFirst = rCurrent;
            }
            if (rCurrent != rElement) continue;
            if (i.hasNext()) {
                return i.next();
            }
            if (!bWrap) continue;
            return rFirst;
        }
        return null;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> orderedMapOf(Pair<K, V> ... rEntries) {
        LinkedHashMap<Object, Object> aMap = new LinkedHashMap<Object, Object>(rEntries.length);
        for (Pair<K, V> rEntry : rEntries) {
            aMap.put(rEntry.first(), rEntry.second());
        }
        return aMap;
    }

    public static <T> Set<T> orderedSetOf(Iterable<T> rValues) {
        return CollectionUtil.addAll(new LinkedHashSet(), rValues);
    }

    @SafeVarargs
    public static <T> Set<T> orderedSetOf(T ... rValues) {
        return CollectionUtil.add(new LinkedHashSet(), rValues);
    }

    public static Map<Object, Object> parseMap(String ... rEntries) {
        return CollectionUtil.parseMap(Object.class, Object.class, rEntries);
    }

    public static Map<Object, Object> parseMap(String sEntries, char cSeparator) {
        return CollectionUtil.parseMap(sEntries.split("" + cSeparator));
    }

    public static <K, V> Map<K, V> parseMap(Class<K> rKeyType, Class<V> rValueType, String ... rEntries) {
        LinkedHashMap aMap = new LinkedHashMap();
        CollectionUtil.parseMapEntries(aMap, rKeyType, rValueType, rEntries);
        return aMap;
    }

    public static <K, V> void parseMapEntries(Map<K, V> rTargetMap, Class<K> rKeyType, Class<V> rValueType, String ... rEntries) {
        for (String sEntry : rEntries) {
            CollectionUtil.addMapEntry(rTargetMap, sEntry, rKeyType, rValueType);
        }
    }

    public static Map<String, String> parseStringMap(String ... rEntries) {
        LinkedHashMap<String, String> aMap = new LinkedHashMap<String, String>();
        for (String sEntry : rEntries) {
            Matcher aMatcher = CollectionUtil.splitMapEntry(sEntry);
            aMap.put(aMatcher.group(1), aMatcher.group(2));
        }
        return aMap;
    }

    public static <E> E previous(Collection<E> rCollection, E rElement, boolean bWrap) {
        Iterator<E> i = rCollection.iterator();
        E rPrevious = null;
        while (i.hasNext()) {
            E rCurrent = i.next();
            if (rCurrent == rElement) {
                if (rPrevious != null) {
                    return rPrevious;
                }
                if (bWrap) {
                    while (i.hasNext()) {
                        rCurrent = i.next();
                    }
                    return rCurrent;
                }
            }
            rPrevious = rCurrent;
        }
        return null;
    }

    public static void print(Map<?, ?> rData, PrintStream rOut) {
        CollectionUtil.print(rData, rOut, "");
    }

    public static <K> void removeAll(Map<K, ?> rMap, K ... rKeys) {
        CollectionUtil.removeAll(rMap, Arrays.asList(rKeys));
    }

    public static <K> void removeAll(Map<K, ?> rMap, Collection<K> rKeys) {
        for (K rKey : rKeys) {
            rMap.remove(rKey);
        }
    }

    public static <T> Set<T> setOf(Iterable<T> rValues) {
        return CollectionUtil.addAll(new HashSet(), rValues);
    }

    @SafeVarargs
    public static <T> Set<T> setOf(T ... rValues) {
        return CollectionUtil.add(new HashSet(), rValues);
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> sort(Map<K, V> rInputMap) {
        return CollectionUtil.sort(rInputMap, null);
    }

    public static <K extends Comparable<? super K>, V> Map<K, V> sort(Map<K, V> rInputMap, Comparator<K> rComparator) {
        LinkedHashMap<Comparable, V> aSortedMap = new LinkedHashMap<Comparable, V>(rInputMap.size());
        ArrayList<K> aSortedKeys = new ArrayList<K>(rInputMap.keySet());
        Collections.sort(aSortedKeys, rComparator);
        for (Comparable rKey : aSortedKeys) {
            aSortedMap.put(rKey, rInputMap.get(rKey));
        }
        return aSortedMap;
    }

    @SafeVarargs
    public static <T extends Relatable> void sortBy(List<T> rList, RelationType<? extends Comparable<?>> ... rTypes) {
        Collections.sort(rList, new RelationComparator(rTypes));
    }

    public static Matcher splitMapEntry(String sEntry) {
        Matcher aMatcher = Pattern.compile("\\s*(.+)\\s*[:=]\\s*(.*)\\s*").matcher(sEntry);
        if (!aMatcher.matches()) {
            throw new IllegalArgumentException("Invalid map entry: " + sEntry);
        }
        return aMatcher;
    }

    public static <T, C extends Collection<T>> C subtract(C rFirst, C rSecond) {
        C aResult = CollectionUtil.newCollectionLike(rFirst);
        aResult.addAll(rFirst);
        aResult.removeAll(rSecond);
        return aResult;
    }

    public static String toString(Object[] rInput, String sSeparator) {
        return CollectionUtil.toString(Arrays.asList(rInput), sSeparator);
    }

    public static String toString(Iterable<?> rInput, String sSeparator) {
        StringBuilder sb = new StringBuilder();
        for (Object rElement : rInput) {
            sb.append(rElement);
            sb.append(sSeparator);
        }
        if (sb.length() >= sSeparator.length()) {
            sb.setLength(sb.length() - sSeparator.length());
        }
        return sb.toString();
    }

    public static <T> String toString(Iterable<T> rInput, Function<? super T, ?> rElementConversion, String sSeparator) {
        StringBuilder sb = new StringBuilder();
        for (T rElement : rInput) {
            sb.append(rElementConversion.evaluate(rElement));
            sb.append(sSeparator);
        }
        if (sb.length() >= sSeparator.length()) {
            sb.setLength(sb.length() - sSeparator.length());
        }
        return sb.toString();
    }

    public static String toString(Map<?, ?> rMap, String sJunction, String sSeparator) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> rEntry : rMap.entrySet()) {
            sb.append(rEntry.getKey());
            sb.append(sJunction);
            sb.append(rEntry.getValue());
            sb.append(sSeparator);
        }
        if (sb.length() >= sSeparator.length()) {
            sb.setLength(sb.length() - sSeparator.length());
        }
        return sb.toString();
    }

    public static <I, O> Collection<O> transform(Collection<I> rInput, Function<? super I, O> rFunction) {
        try {
            Collection aResult = (Collection)rInput.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            for (I t : rInput) {
                aResult.add(rFunction.evaluate(t));
            }
            return aResult;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create result collection", e);
        }
    }

    private static void print(Object rData, PrintStream rOut, String sIndent) {
        if (rData instanceof Map) {
            for (Map.Entry rEntry : ((Map)rData).entrySet()) {
                Object sKey = rEntry.getKey();
                rOut.print(sIndent);
                rOut.print(sKey);
                rOut.print(": ");
                CollectionUtil.print(rEntry.getValue(), rOut, sIndent + '\t');
            }
        } else if (rData instanceof Collection) {
            for (Object value : (Collection)rData) {
                CollectionUtil.print(value, rOut, sIndent + '\t');
                rOut.print(", ");
            }
        } else {
            rOut.print(rData);
        }
        rOut.println();
    }
}

