/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.datatype;

import java.io.Serializable;

public abstract class ObjectId<T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    protected ObjectId() {
    }

    public static <T> ObjectId<T> intId(int nId) {
        return new IntegerId(nId);
    }

    public static <T> ObjectId<T> longId(long nId) {
        return new LongId(nId);
    }

    public static <T> ObjectId<T> stringId(String sId) {
        return new StringId(sId);
    }

    public abstract Object internalValue();

    public abstract String toString();

    public final boolean equals(Object rOther) {
        if (this == rOther) {
            return true;
        }
        if (rOther == null || this.getClass() != rOther.getClass()) {
            return false;
        }
        return this.toString().equals(rOther.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public static class StringId<T>
    extends ObjectId<T> {
        private static final long serialVersionUID = 1L;
        private final String sId;

        public StringId(String sId) {
            this.sId = sId;
        }

        @Override
        public Object internalValue() {
            return this.sId;
        }

        @Override
        public String toString() {
            return this.sId;
        }
    }

    public static class LongId<T>
    extends ObjectId<T> {
        private static final long serialVersionUID = 1L;
        private final long nId;

        public LongId(long nId) {
            this.nId = nId;
        }

        @Override
        public Object internalValue() {
            return this.nId;
        }

        @Override
        public String toString() {
            return Long.toString(this.nId);
        }
    }

    public static class IntegerId<T>
    extends ObjectId<T> {
        private static final long serialVersionUID = 1L;
        private final int nId;

        public IntegerId(int nId) {
            this.nId = nId;
        }

        @Override
        public Object internalValue() {
            return this.nId;
        }

        @Override
        public String toString() {
            return Integer.toString(this.nId);
        }
    }
}

