/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.datatype;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.datatype.Pair;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Range<T extends Comparable<T>>
implements Iterable<T> {
    private static final long END_EXCLUSIVE = -9223372036854775807L;
    private static final Map<Class<?>, Comparable<?>> DEFAULT_STEPS = CollectionUtil.fixedMapOf(Pair.t(Long.class, (Object)1L), Pair.t(Integer.class, (Object)1), Pair.t(Short.class, (Object)1), Pair.t(Byte.class, (Object)1), Pair.t(BigInteger.class, (Object)BigInteger.ONE), Pair.t(BigDecimal.class, (Object)BigDecimal.ONE), Pair.t(Double.class, (Object)1.0), Pair.t(Float.class, (Object)Float.valueOf(1.0f)), Pair.t(Character.class, (Object)Character.valueOf('\u0001')));
    private static final Map<Class<?>, Comparable<?>> ZERO_VALUES = CollectionUtil.fixedMapOf(Pair.t(Long.class, (Object)0L), Pair.t(Integer.class, (Object)0), Pair.t(Short.class, (Object)0), Pair.t(Byte.class, (Object)0), Pair.t(BigInteger.class, (Object)BigInteger.ZERO), Pair.t(BigDecimal.class, (Object)BigDecimal.ZERO), Pair.t(Double.class, (Object)0.0), Pair.t(Float.class, (Object)Float.valueOf(0.0f)), Pair.t(Character.class, (Object)Character.valueOf('\u0000')));
    private final T aStart;
    private final Function<RangeIterator, T> fGetNextValue;
    private T aEnd = null;
    private T aStep = null;
    private long nSize = Long.MIN_VALUE;
    private boolean bAscending;

    private Range(T rStart, Function<RangeIterator, T> fGetNextValue) {
        Objects.requireNonNull(rStart, "Start value must not be NULL");
        this.aStart = rStart;
        this.fGetNextValue = fGetNextValue;
    }

    public static Range<Long> from(long nStart) {
        return new Range<Long>(nStart, i -> (Long)((RangeIterator)i).aNext + (Long)i.range().aStep);
    }

    public static Range<Integer> from(int nStart) {
        return new Range<Integer>(nStart, i -> (Integer)((RangeIterator)i).aNext + (Integer)i.range().aStep);
    }

    public static Range<Float> from(float fStart) {
        return new Range<Float>(Float.valueOf(fStart), i -> Float.valueOf(((Float)((RangeIterator)i).aNext).floatValue() + ((Float)i.range().aStep).floatValue()));
    }

    public static Range<Double> from(double fStart) {
        return new Range<Double>(fStart, i -> (Double)((RangeIterator)i).aNext + (Double)i.range().aStep);
    }

    public static Range<Short> from(short nStart) {
        return new Range<Short>(nStart, i -> (short)((Short)((RangeIterator)i).aNext + (Short)i.range().aStep));
    }

    public static Range<Byte> from(byte nStart) {
        return new Range<Byte>(nStart, i -> (byte)((Byte)((RangeIterator)i).aNext + (Byte)i.range().aStep));
    }

    public static Range<BigInteger> from(BigInteger rStart) {
        return new Range<BigInteger>(rStart, i -> ((BigInteger)((RangeIterator)i).aNext).add((BigInteger)i.range().aStep));
    }

    public static Range<BigDecimal> from(BigDecimal dStart) {
        return new Range<BigDecimal>(dStart, i -> ((BigDecimal)((RangeIterator)i).aNext).add((BigDecimal)i.range().aStep));
    }

    public static Range<Character> from(char cStart) {
        return new Range<Character>(Character.valueOf(cStart), i -> Character.valueOf((char)(((Character)((RangeIterator)i).aNext).charValue() + (i.range().bAscending ? ((Character)i.range().aStep).charValue() : -((Character)i.range().aStep).charValue()))));
    }

    public boolean contains(T rValue) {
        this.checkInitialized();
        return this.bAscending ? rValue.compareTo(this.aStart) >= 0 && rValue.compareTo(this.aEnd) <= 0 : rValue.compareTo(this.aEnd) >= 0 && rValue.compareTo(this.aStart) <= 0;
    }

    public boolean equals(Object rObj) {
        this.checkInitialized();
        if (this == rObj) {
            return true;
        }
        if (rObj == null || this.getClass() != rObj.getClass()) {
            return false;
        }
        Range rOther = (Range)rObj;
        rOther.checkInitialized();
        return this.aStart.equals(rOther.aStart) && Objects.equals(this.aEnd, rOther.aEnd) && Objects.equals(this.aStep, rOther.aStep);
    }

    public T getEnd() {
        this.checkInitialized();
        return this.aEnd;
    }

    public T getStart() {
        return this.aStart;
    }

    public T getStep() {
        this.checkInitialized();
        return this.aStep;
    }

    public int hashCode() {
        this.checkInitialized();
        int nPrime = 31;
        int nHash = 1;
        nHash = 31 * nHash + this.aStart.hashCode();
        nHash = 31 * nHash + this.aEnd.hashCode();
        nHash = 31 * nHash + this.aStep.hashCode();
        return nHash;
    }

    public boolean isAscending() {
        return this.bAscending;
    }

    @Override
    public Iterator<T> iterator() {
        this.checkInitialized();
        return new RangeIterator(this, this.aStart);
    }

    public long size() {
        this.checkInitialized();
        return this.nSize;
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), this.size(), 17749);
    }

    public Range<T> step(T rStep) {
        Objects.requireNonNull(rStep, "Range step must not be NULL");
        if (this.aStep != null) {
            throw new IllegalArgumentException("Range step already set to " + this.aStep);
        }
        if (rStep.compareTo(ZERO_VALUES.get(this.aStart.getClass())) <= 0) {
            throw new IllegalArgumentException("Step must be a positive number");
        }
        this.aStep = rStep;
        return this;
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Range<T> to(T rEnd) {
        Objects.requireNonNull(rEnd, "End value must not be NULL");
        if (this.aEnd != null) {
            throw new IllegalArgumentException("Range end already set to " + this.aEnd);
        }
        this.aEnd = rEnd;
        this.bAscending = this.aStart.compareTo(this.aEnd) <= 0;
        return this;
    }

    public Range<T> toBefore(T rBefore) {
        Range<T> rThis = this.to(rBefore);
        this.nSize = -9223372036854775807L;
        return rThis;
    }

    public List<T> toList() {
        return this.stream().collect(Collectors.toList());
    }

    public String toString() {
        this.checkInitialized();
        StringBuilder aResult = new StringBuilder(this.aStart.toString());
        aResult.append("..");
        aResult.append(this.aEnd);
        if (this.aStep != DEFAULT_STEPS.get(this.aStart.getClass())) {
            aResult.append(" step ").append(this.aStep);
        }
        return aResult.toString();
    }

    private void calcSize() {
        if (this.aEnd != null && this.aStep != null && this.nSize <= -9223372036854775807L) {
            Class<?> rRangeType;
            if (!this.bAscending) {
                this.aStep = this.negate(this.aStep);
            }
            if (this.nSize == -9223372036854775807L) {
                this.bAscending = !this.bAscending;
                this.aStep = this.negate(this.aStep);
                this.aEnd = (Comparable)this.fGetNextValue.apply(new RangeIterator(this, this.aEnd));
                this.aStep = this.negate(this.aStep);
                boolean bl = this.bAscending = !this.bAscending;
            }
            if ((rRangeType = this.aEnd.getClass()) == BigDecimal.class) {
                this.nSize = ((BigDecimal)this.aEnd).subtract((BigDecimal)this.aStart).add((BigDecimal)this.aStep).divide((BigDecimal)this.aStep).longValue();
            } else if (rRangeType == BigInteger.class) {
                this.nSize = ((BigInteger)this.aEnd).subtract((BigInteger)this.aStart).add((BigInteger)this.aStep).divide((BigInteger)this.aStep).longValue();
            } else if (Number.class.isAssignableFrom(rRangeType)) {
                if (rRangeType == Double.class || rRangeType == Float.class) {
                    double fStep = ((Number)this.aStep).doubleValue();
                    this.nSize = (long)((((Number)this.aEnd).doubleValue() - ((Number)this.aStart).doubleValue() + fStep) / fStep);
                } else {
                    long nStep = ((Number)this.aStep).longValue();
                    this.nSize = (((Number)this.aEnd).longValue() - ((Number)this.aStart).longValue() + nStep) / nStep;
                }
            } else if (rRangeType == Character.class) {
                char nStep = ((Character)this.aStep).charValue();
                if (!this.bAscending) {
                    nStep = -nStep;
                }
                this.nSize = (((Character)this.aEnd).charValue() - ((Character)this.aStart).charValue() + nStep) / nStep;
            }
        }
    }

    private void checkInitialized() {
        if (this.aEnd == null) {
            throw new IllegalStateException("Range end has not been set");
        }
        if (this.aStep == null) {
            this.step(DEFAULT_STEPS.get(this.aStart.getClass()));
            if (this.aStep == null) {
                throw new IllegalArgumentException("No range mapping for type " + this.aStart.getClass());
            }
        }
        this.calcSize();
    }

    private T negate(T rValue) {
        Class<?> rValueType = rValue.getClass();
        if (rValueType == Integer.class) {
            rValue = -((Integer)rValue).intValue();
        } else if (rValueType == Long.class) {
            rValue = -((Long)rValue).longValue();
        } else if (rValueType == Short.class) {
            rValue = -((Short)rValue).shortValue();
        } else if (rValueType == Byte.class) {
            rValue = -((Byte)rValue).byteValue();
        } else if (rValueType == BigDecimal.class) {
            rValue = ((BigDecimal)rValue).negate();
        } else if (rValueType == BigInteger.class) {
            rValue = ((BigInteger)rValue).negate();
        } else if (rValueType == Double.class) {
            rValue = -((Double)rValue).doubleValue();
        } else if (rValueType == Float.class) {
            rValue = Float.valueOf(-((Float)rValue).floatValue());
        } else if (rValueType == Character.class) {
            // empty if block
        }
        return rValue;
    }

    static class RangeIterator
    implements Iterator<T> {
        private T aNext;
        final /* synthetic */ Range this$0;

        RangeIterator(T rStartValue) {
            this.this$0 = this$0;
            this.aNext = rStartValue;
        }

        @Override
        public boolean hasNext() {
            return this.aNext != null;
        }

        @Override
        public T next() {
            Object rCurrent = this.aNext;
            this.aNext = (Comparable)this.this$0.fGetNextValue.apply(this);
            int nNextCompared = this.aNext.compareTo((Comparable)this.this$0.aEnd);
            if (this.this$0.bAscending && nNextCompared > 0 || !this.this$0.bAscending && nNextCompared < 0) {
                this.aNext = null;
            }
            return rCurrent;
        }

        public final Range<T> range() {
            return this.this$0;
        }
    }
}

