/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.event;

import de.esoco.lib.event.Event;
import de.esoco.lib.event.EventHandler;
import de.esoco.lib.property.Immutability;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class EventDispatcher<E extends Event<?>>
implements Immutability,
Serializable {
    private static final long serialVersionUID = 1L;
    private Set<EventHandler<E>> aEventHandlers = new LinkedHashSet<EventHandler<E>>();

    public void add(EventHandler<? extends E> rHandler) {
        this.aEventHandlers.add(rHandler);
    }

    public void dispatch(E rEvent) {
        for (EventHandler<E> rHandler : this.aEventHandlers) {
            rHandler.handleEvent(rEvent);
        }
    }

    public int getEventHandlerCount() {
        return this.aEventHandlers.size();
    }

    public void remove(EventHandler<? extends E> rHandler) {
        this.aEventHandlers.remove(rHandler);
    }

    public void setImmutable() {
        this.aEventHandlers = Collections.unmodifiableSet(this.aEventHandlers);
    }
}

