/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.Action;
import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.FunctionException;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;
import de.esoco.lib.expression.function.BinaryFunctionChain;
import de.esoco.lib.expression.function.BinaryFunctionGroup;
import de.esoco.lib.expression.function.CachingSupplier;
import de.esoco.lib.expression.function.ConditionalFunction;
import de.esoco.lib.expression.function.DualFunctionChain;
import de.esoco.lib.expression.function.FunctionChain;
import de.esoco.lib.expression.function.GetElement;
import de.esoco.lib.expression.function.Group;
import de.esoco.lib.expression.function.Print;
import de.esoco.lib.expression.function.SetElement;
import de.esoco.lib.expression.monad.Try;
import de.esoco.lib.reflect.ReflectUtil;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;

public class Functions {
    public static final Runnable NO_OPERATION = () -> {};

    private Functions() {
    }

    public static <T> Action<T> asAction(Function<T, ?> rFunction) {
        return rFunction::evaluate;
    }

    public static <T> Consumer<T> asConsumer(java.util.function.Function<T, ?> fFunction) {
        return fFunction::apply;
    }

    public static <T> java.util.function.Function<T, T> asFunction(Consumer<T> fConsumer) {
        return v -> {
            fConsumer.accept(v);
            return v;
        };
    }

    public static <T, U> BiFunction<T, U, T> asFunction(BiConsumer<T, U> fConsumer) {
        return (t, u) -> {
            fConsumer.accept(t, u);
            return t;
        };
    }

    public static <I, O> java.util.function.Function<I, O> asFunction(Supplier<O> fSupplier) {
        return i -> fSupplier.get();
    }

    public static <T> java.util.function.Function<T, Void> asFunction(Runnable fRunnable) {
        return v -> {
            fRunnable.run();
            return null;
        };
    }

    public static <T> Function<T, String> asString() {
        return v -> v != null ? v.toString() : "null";
    }

    public static <T> CachingSupplier<T> cached(Supplier<T> fSupplyValue) {
        return CachingSupplier.cached(fSupplyValue);
    }

    public static <I, V, O> Function<I, O> chain(Function<V, O> rOuter, Function<I, ? extends V> rInner) {
        return new FunctionChain<I, V, O>(rOuter, rInner);
    }

    public static <L, R, V, W, O> BinaryFunction<L, R, O> chain(BinaryFunction<V, W, O> rOuter, Function<L, ? extends V> rLeft, Function<R, ? extends W> rRight) {
        return new DualFunctionChain<L, R, V, W, O>(rOuter, rLeft, rRight);
    }

    public static <L, R, V, O> BinaryFunction<L, R, O> chainLeft(BinaryFunction<V, R, O> rOuter, BinaryFunction<L, R, ? extends V> rInner) {
        return new BinaryFunctionChain.LeftFunctionChain<L, R, V, O>(rOuter, rInner);
    }

    public static <L, R, V, O> BinaryFunction<L, R, O> chainRight(BinaryFunction<L, V, O> rOuter, BinaryFunction<L, R, ? extends V> rInner) {
        return new BinaryFunctionChain.RightFunctionChain<L, R, V, O>(rOuter, rInner);
    }

    public static <I, O> Function<I, O> coerce(Function<?, ?> fFunction) {
        return fFunction;
    }

    public static <T, C extends Comparable<C>> Comparator<T> compare(final Function<? super T, C> fGetComparable) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Comparable c1 = (Comparable)fGetComparable.evaluate(o1);
                Comparable c2 = (Comparable)fGetComparable.evaluate(o2);
                return c1 != null && c2 != null ? c1.compareTo(c2) : (c1 == null && c2 == null ? 0 : (c2 == null ? 1 : -1));
            }
        };
    }

    @SafeVarargs
    public static <I> Function<I, I> doAll(Consumer<? super I> fFirst, Consumer<? super I> ... rAdditionalFunctions) {
        return Group.of(fFirst, rAdditionalFunctions);
    }

    @SafeVarargs
    public static <L, R> BinaryFunction<L, R, L> doAll(R rRightValue, BinaryFunction<? super L, ? super R, ?> fFirst, BinaryFunction<? super L, ? super R, ?> fSecond, BinaryFunction<? super L, ? super R, ?> ... rFunctions) {
        ArrayList aFunctions = new ArrayList();
        aFunctions.add(fFirst);
        aFunctions.add(fSecond);
        if (rFunctions != null) {
            aFunctions.addAll(Arrays.asList(rFunctions));
        }
        return new BinaryFunctionGroup(rRightValue, aFunctions);
    }

    public static <I, O> ConditionalFunction<I, O> doIf(Predicate<? super I> rPredicate, Function<? super I, O> rFunction) {
        return new ConditionalFunction<I, O>(rPredicate, rFunction);
    }

    public static <I> Consumer<I> doIf(Predicate<? super I> pCondition, Consumer<? super I> fConsumer) {
        return Functions.asConsumer(new ConditionalFunction<Object, Object>(pCondition, i -> {
            fConsumer.accept((Object)i);
            return i;
        }));
    }

    public static <I, O> Function<I, O> doIfElse(Predicate<? super I> rPredicate, Function<? super I, ? extends O> fIf, Function<? super I, ? extends O> fElse) {
        return new ConditionalFunction<I, O>(rPredicate, fIf, fElse);
    }

    public static <I> Consumer<I> doIfElse(Predicate<? super I> pCondition, Consumer<? super I> fIf, Consumer<? super I> fElse) {
        return Functions.asConsumer(new ConditionalFunction<Object, Object>(pCondition, i -> {
            fIf.accept((Object)i);
            return i;
        }, i -> {
            fElse.accept((Object)i);
            return i;
        }));
    }

    public static <I, O> BinaryFunction<I, String, O> error(String sMessage, final Class<? extends Exception> rExceptionClass) {
        return new AbstractBinaryFunction<I, String, O>(sMessage, "error"){
            final Constructor<? extends Exception> rConstructor;
            {
                super(rRightValue, sToken);
                this.rConstructor = ReflectUtil.getPublicConstructor(rExceptionClass, String.class);
            }

            @Override
            public O evaluate(I rValue, String sMessage) {
                Exception eError;
                sMessage = String.format(sMessage, rValue);
                try {
                    eError = this.rConstructor.newInstance(sMessage);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not create " + rExceptionClass, e);
                }
                if (eError instanceof RuntimeException) {
                    throw (RuntimeException)eError;
                }
                throw new FunctionException((Object)this, (Throwable)eError);
            }
        };
    }

    public static Function<?, ?> firstInChain(Function<?, ?> rFunction) {
        if (rFunction instanceof FunctionChain) {
            rFunction = Functions.firstInChain(((FunctionChain)rFunction).getInner());
        }
        return rFunction;
    }

    public static <I, O> GetElement.GetField<I, O> getField(String sField) {
        return new GetElement.GetField(sField);
    }

    public static <I extends Relatable, O> Function<I, Relation<O>> getRelation(RelationType<O> rType) {
        return new GetElement.GetRelation(rType);
    }

    public static <I extends Relatable, O> Function<I, O> getRelationValue(RelationType<O> rType) {
        return new GetElement.GetRelationValue(rType);
    }

    public static <T> InvertibleFunction<T, T> identity() {
        return InvertibleFunction.of(t -> t, t -> t);
    }

    public static <I, O> BinaryFunction<I, String, O> illegalArgument(String sMessage) {
        return Functions.error(sMessage, IllegalArgumentException.class);
    }

    public static <I, O> BinaryFunction<I, String, O> illegalState(String sMessage) {
        return Functions.error(sMessage, IllegalStateException.class);
    }

    public static <I, O> InvertibleFunction<O, I> invert(InvertibleFunction<I, O> fToInvert) {
        return InvertibleFunction.of(fToInvert::invert, fToInvert::evaluate);
    }

    public static Function<?, ?> lastInChain(Function<?, ?> rFunction) {
        if (rFunction instanceof FunctionChain) {
            rFunction = Functions.lastInChain(((FunctionChain)rFunction).getOuter());
        }
        return rFunction;
    }

    public static void measure(String sDescription, Runnable rProfiledCode) {
        long t = System.currentTimeMillis();
        rProfiledCode.run();
        t = System.currentTimeMillis() - t;
        System.out.printf("[TIME] %s: %d.%03ds\n", sDescription, t / 1000L, t % 1000L);
    }

    public static <T> BinaryFunction<T, PrintWriter, T> print(PrintWriter rOut, String sFormat) {
        return new Print(rOut, sFormat, false);
    }

    public static <T> Function<T, T> println(String sFormat) {
        return new Print(sFormat);
    }

    public static <T> BinaryFunction<T, PrintWriter, T> println(PrintWriter rOut, String sFormat) {
        return new Print(rOut, sFormat, true);
    }

    public static <I, O> GetElement.ReadField<I, O> readField(String sFieldName) {
        return new GetElement.ReadField(sFieldName);
    }

    public static <T extends Relatable, V> BinaryFunction<T, V, T> setRelationValue(RelationType<V> rType, V rValue) {
        return new SetElement.SetRelationValue(rType, rValue);
    }

    public static Consumer<Long> sleep() {
        return time -> Try.run(() -> Thread.sleep(time)).orUse(null);
    }

    public static <L, R, O> BinaryFunction<R, L, O> swapParams(final BinaryFunction<L, R, O> rFunction, L rNewRightValue) {
        return new AbstractBinaryFunction<R, L, O>(rNewRightValue, rFunction.getToken()){

            @Override
            public O evaluate(R rLeftValue, L rRightValue) {
                return rFunction.evaluate(rRightValue, rLeftValue);
            }

            @Override
            public String toString() {
                return this.getToken() + "(" + this.getRightValue() + ", " + "#" + ")";
            }
        };
    }

    public static Supplier<Long> unixTimestamp() {
        return () -> System.currentTimeMillis() / 1000L;
    }

    public static <I, O> Function<I, O> value(final O rValue) {
        return new AbstractFunction<I, O>("value"){

            @Override
            public O evaluate(I rInput) {
                return rValue;
            }

            @Override
            public String toString() {
                return "value=" + rValue;
            }
        };
    }
}

