/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.BinaryPredicate;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.GetElement;
import de.esoco.lib.expression.predicate.BinaryPredicateChain;
import de.esoco.lib.expression.predicate.Comparison;
import de.esoco.lib.expression.predicate.ElementPredicate;
import de.esoco.lib.expression.predicate.FunctionPredicate;
import de.esoco.lib.expression.predicate.PredicateChain;
import de.esoco.lib.expression.predicate.PredicateJoin;
import de.esoco.lib.expression.predicate.ThrowingBinaryPredicate;
import de.esoco.lib.expression.predicate.ThrowingPredicate;
import java.util.regex.Pattern;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;

public class Predicates {
    private static final Predicate<?> TRUE = v -> true;
    private static final Predicate<?> FALSE = v -> false;
    private static final Predicate<?> IS_NULL = new Comparison.EqualTo<Object>(null){

        @Override
        public final Boolean evaluate(Object rValue, Object rNull) {
            return rValue == null;
        }
    };
    private static final Predicate<?> NOT_NULL = Predicates.not(IS_NULL);

    private Predicates() {
    }

    public static <T> Predicate<T> alwaysFalse() {
        return FALSE;
    }

    public static <T> Predicate<T> alwaysTrue() {
        return TRUE;
    }

    public static <T> Predicate<T> and(Predicate<? super T> rFirst, Predicate<? super T> rSecond) {
        if (rSecond == null) {
            return rFirst;
        }
        if (rFirst == null) {
            return rSecond;
        }
        return new And<T>(rFirst, rSecond);
    }

    public static <T, I> Predicate<T> chain(Predicate<I> rOuter, Function<T, ? extends I> rInner) {
        return new PredicateChain<T, I>(rOuter, rInner);
    }

    public static <L, R, V, W> BinaryPredicate<L, R> chain(BinaryPredicate<V, W> rOuter, Function<L, ? extends V> rLeft, Function<R, ? extends W> rRight) {
        return new BinaryPredicateChain<L, R, V, W>(rOuter, rLeft, rRight);
    }

    public static <T> Comparison<T, Object> equalTo(Object rValue) {
        return new Comparison.EqualTo(rValue);
    }

    public static Predicate<?> firstInChain(Predicate<?> rPredicate) {
        if (rPredicate instanceof PredicateJoin) {
            rPredicate = Predicates.firstInChain(((PredicateJoin)rPredicate).getLeft());
        }
        return rPredicate;
    }

    public static <T extends Comparable<T>> Comparison<T, T> greaterOrEqual(T rValue) {
        return new Comparison.GreaterOrEqual<T>(rValue);
    }

    public static <T extends Comparable<T>> Comparison<T, T> greaterThan(T rValue) {
        return new Comparison.GreaterThan<T>(rValue);
    }

    public static <T, V> ElementPredicate<T, V> ifField(String sField, Predicate<V> rPredicate) {
        return new ElementPredicate(new GetElement.ReadField(sField), rPredicate);
    }

    public static <T, V> ElementPredicate<T, V> ifProperty(String sProperty, Predicate<V> rPredicate) {
        return new ElementPredicate(new GetElement.GetField(sProperty), rPredicate);
    }

    public static <T extends Relatable, V> Predicate<T> ifProperty(RelationType<V> rType, Predicate<? super V> rPredicate) {
        return Predicates.ifRelation(rType, rPredicate);
    }

    public static <T extends Relatable, V> ElementPredicate<T, V> ifRelation(RelationType<V> rType, Predicate<? super V> rPredicate) {
        return new ElementPredicate(rType, rPredicate);
    }

    public static <T> Predicate<T> isNull() {
        return IS_NULL;
    }

    public static <T extends Comparable<T>> Comparison<T, T> lessOrEqual(T rValue) {
        return new Comparison.LessOrEqual<T>(rValue);
    }

    public static <T extends Comparable<T>> Comparison<T, T> lessThan(T rValue) {
        return new Comparison.LessThan<T>(rValue);
    }

    public static <T> Predicate<T> matching(String sRegularExpression) {
        return new Comparison.Matching(sRegularExpression);
    }

    public static <T> Predicate<T> matching(Pattern rPattern) {
        return new Comparison.Matching(rPattern);
    }

    public static <T> Predicate<T> not(Predicate<T> rPredicate) {
        return new Not<T>(rPredicate);
    }

    public static <T> Predicate<T> notNull() {
        return NOT_NULL;
    }

    public static <T> Predicate<T> or(Predicate<? super T> rFirst, Predicate<? super T> rSecond) {
        if (rSecond == null) {
            return rFirst;
        }
        if (rFirst == null) {
            return rSecond;
        }
        return new Or<T>(rFirst, rSecond);
    }

    public static <T> Comparison<T, Object> sameAs(Object rValue) {
        return new Comparison.SameAs(rValue);
    }

    public static <T> Predicate<T> unchecked(ThrowingPredicate<T> pChecked) {
        return pChecked;
    }

    public static <L, R> BinaryPredicate<L, R> unchecked(ThrowingBinaryPredicate<L, R> pChecked) {
        return pChecked;
    }

    public static <T> Predicate<T> untilCountDown(final int nValue) {
        return new Predicate<T>(){
            int nCountValue;
            {
                this.nCountValue = nValue;
            }

            @Override
            public Boolean evaluate(T rValue) {
                return this.nCountValue-- > 0;
            }
        };
    }

    public static <I, O, T extends I> Predicate<T> when(Function<I, O> rFunction, Predicate<? super O> rPredicate) {
        return new FunctionPredicate<I, O>(rFunction, rPredicate);
    }

    public static class Or<T>
    extends PredicateJoin<T> {
        Or(Predicate<? super T> rLeft, Predicate<? super T> rRight) {
            super(rLeft, rRight, "||");
        }

        @Override
        protected Boolean evaluate(Predicate<? super T> rLeft, Predicate<? super T> rRight, T rValue) {
            return (Boolean)rLeft.evaluate(rValue) != false || (Boolean)rRight.evaluate(rValue) != false;
        }
    }

    public static class Not<T>
    implements Predicate<T> {
        private final Predicate<T> rPredicate;

        public Not(Predicate<T> rPredicate) {
            this.rPredicate = rPredicate;
        }

        @Override
        public Boolean evaluate(T rTarget) {
            return (Boolean)this.rPredicate.evaluate(rTarget) == false;
        }

        public final Predicate<T> getInvertedPredicate() {
            return this.rPredicate;
        }

        public String toString() {
            return this.getToken() + " " + this.rPredicate;
        }
    }

    public static class And<T>
    extends PredicateJoin<T> {
        And(Predicate<? super T> rLeft, Predicate<? super T> rRight) {
            super(rLeft, rRight, "&&");
        }

        @Override
        protected Boolean evaluate(Predicate<? super T> rLeft, Predicate<? super T> rRight, T rValue) {
            return (Boolean)rLeft.evaluate(rValue) != false && (Boolean)rRight.evaluate(rValue) != false;
        }
    }
}

