/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;
import de.esoco.lib.expression.function.Cast;

public class ReflectionFuntions {
    private static final Function<?, ?> GET_CLASS = new AbstractFunction<Object, Class<?>>("GetClass"){

        @Override
        public Class<?> evaluate(Object rObject) {
            return rObject.getClass();
        }
    };
    private static final Function<Class<?>, String> GET_CLASS_NAME = new AbstractFunction<Class<?>, String>("GetClassName"){

        @Override
        public String evaluate(Class<?> rClass) {
            return rClass.getName();
        }
    };
    private static final Function<Class<?>, String> GET_SIMPLE_NAME = new AbstractFunction<Class<?>, String>("GetSimpleName"){

        @Override
        public String evaluate(Class<?> rClass) {
            return rClass.getSimpleName();
        }
    };
    private static final Function<?, ?> NEW_INSTANCE = new AbstractFunction<Class<?>, Object>("NewInstance"){

        @Override
        public Object evaluate(Class<?> rClass) {
            try {
                return rClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
    };
    private static final Function<?, ?> NEW_INSTANCE_OF_CLASS = ReflectionFuntions.newInstance().from(ReflectionFuntions.getObjectClass());

    private ReflectionFuntions() {
    }

    public static <I, O> BinaryFunction<I, Class<O>, O> cast(Class<O> rCastType) {
        return new Cast(rCastType);
    }

    public static final Function<Class<?>, String> getClassName() {
        return GET_CLASS_NAME;
    }

    public static <E extends Enum<E>> BinaryFunction<String, Class<E>, E> getEnumValue(Class<E> rEnumClass) {
        return new AbstractBinaryFunction<String, Class<E>, E>(rEnumClass, "getEnumValue"){

            @Override
            public E evaluate(String sName, Class<E> rEnumClass) {
                return Enum.valueOf(rEnumClass, sName);
            }
        };
    }

    public static final <T> Function<T, Class<? extends T>> getObjectClass() {
        return GET_CLASS;
    }

    public static final Function<Class<?>, String> getSimpleName() {
        return GET_SIMPLE_NAME;
    }

    public static <T> Function<Class<? extends T>, T> newInstance() {
        return NEW_INSTANCE;
    }

    public static <T> Function<Object, T> newInstanceOf(Class<T> rClass) {
        return ReflectionFuntions.newInstance().from(Functions.value(rClass));
    }

    public static <T> Function<T, T> newInstanceOfClass() {
        return NEW_INSTANCE_OF_CLASS;
    }
}

