/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.GetSubstring;
import de.esoco.lib.expression.monad.Try;
import de.esoco.lib.reflect.ReflectUtil;
import de.esoco.lib.text.TextConvert;
import java.net.IDN;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringFunctions {
    private static final Function<String, String> TO_LOWER_CASE = s -> s.toLowerCase();
    private static final Function<String, String> TO_UPPER_CASE = s -> s.toUpperCase();
    private static final InvertibleFunction<String, byte[]> TO_BYTE_ARRAY = InvertibleFunction.of(s -> s != null ? s.getBytes() : null, b -> b != null ? new String((byte[])b) : null);
    private static final Predicate<CharSequence> IS_EMPTY = s -> s == null || s.length() == 0;
    private static final Predicate<CharSequence> NOT_EMPTY = s -> s != null && s.length() > 0;
    private static final Predicate<String> IS_VALID_IDN_UNICODE = s -> (Boolean)Try.now(() -> IDN.toASCII(s) != null).orUse((Object)false);
    private static final Function<String, String> IDN_UNICODE_TO_ASCII = s -> IDN.toASCII(s);
    private static final Function<String, String> IDN_ASCII_TO_UNICODE = s -> IDN.toUnicode(s);

    private StringFunctions() {
    }

    public static BinaryFunction<String, String, String> capitalize(String sSeparator) {
        return new AbstractBinaryFunction<String, String, String>(sSeparator, "Capitalize"){

            @Override
            public String evaluate(String sText, String sSeparator) {
                return TextConvert.capitalize((String)sText, (String)sSeparator);
            }
        };
    }

    public static Function<String, String> capitalizedIdentifier() {
        return TextConvert::capitalizedIdentifier;
    }

    public static BinaryFunction<String, String, String> find(String sRegex) {
        return new AbstractBinaryFunction<String, String, String>(sRegex, "Find"){

            @Override
            public String evaluate(String sInput, String sRegex) {
                Matcher aMatcher = Pattern.compile(sRegex).matcher(sInput);
                return aMatcher.find() ? aMatcher.group() : null;
            }
        };
    }

    public static <T> BinaryFunction<T, String, String> format(String sPattern) {
        return new AbstractBinaryFunction<T, String, String>(sPattern, "StringFormat"){

            @Override
            public String evaluate(T rValue, String sPattern) {
                return String.format(sPattern, rValue);
            }
        };
    }

    public static Function<String, String> idnAsciiToUnicode() {
        return IDN_ASCII_TO_UNICODE;
    }

    public static Function<String, String> idnUnicodeToAscii() {
        return IDN_UNICODE_TO_ASCII;
    }

    public static Predicate<CharSequence> isEmpty() {
        return IS_EMPTY;
    }

    public static boolean isEmpty(CharSequence sString) {
        return IS_EMPTY.test(sString);
    }

    public static Predicate<String> isValidIdnUnicode() {
        return IS_VALID_IDN_UNICODE;
    }

    public static Predicate<CharSequence> notEmpty() {
        return NOT_EMPTY;
    }

    public static BinaryFunction<String, String, String[]> split(String sPattern) {
        return new AbstractBinaryFunction<String, String, String[]>(sPattern, "StringSplit"){

            @Override
            public String[] evaluate(String sValue, String sPattern) {
                return sValue.split(sPattern);
            }
        };
    }

    public static GetSubstring substring(int nBeginIndex, int nEndIndex) {
        return new GetSubstring(nBeginIndex, nEndIndex);
    }

    public static InvertibleFunction<String, byte[]> toByteArray() {
        return TO_BYTE_ARRAY;
    }

    public static <C extends Collection<String>> BinaryFunction<String, String, C> toCollection(final Class<C> rCollectionClass, String sSplitPattern, final boolean bTrim) {
        return new AbstractBinaryFunction<String, String, C>(sSplitPattern, "StringSplit"){

            @Override
            public C evaluate(String sValue, String sPattern) {
                Collection aResult = (Collection)ReflectUtil.newInstance(rCollectionClass);
                if (sValue != null && sValue.length() > 0) {
                    String[] aSplit;
                    for (String sElement : aSplit = sValue.split(sPattern)) {
                        aResult.add(bTrim ? sElement.trim() : sElement);
                    }
                }
                return aResult;
            }
        };
    }

    public static <C extends Collection<String>> BinaryFunction<String, String, List<String>> toList(String sSplitPattern, boolean bTrim) {
        Class<ArrayList> rListClass = ArrayList.class;
        return StringFunctions.toCollection(rListClass, sSplitPattern, bTrim);
    }

    public static List<String> toList(String sInput, String sSplitPattern, boolean bTrim) {
        return StringFunctions.toList(sSplitPattern, bTrim).evaluate(sInput);
    }

    public static Function<String, String> toLowerCase() {
        return TO_LOWER_CASE;
    }

    public static <C extends Collection<String>> BinaryFunction<String, String, Set<String>> toSet(String sSplitPattern, boolean bTrim, boolean bOrdered) {
        Class rSetClass = bOrdered ? LinkedHashSet.class : HashSet.class;
        return StringFunctions.toCollection(rSetClass, sSplitPattern, bTrim);
    }

    public static Set<String> toSet(String sInput, String sSplitPattern, boolean bTrim, boolean bOrdered) {
        return StringFunctions.toSet(sSplitPattern, bTrim, bOrdered).evaluate(sInput);
    }

    public static Function<String, String> toUpperCase() {
        return TO_UPPER_CASE;
    }

    public static Function<String, String> uppercaseIdentifier() {
        return TextConvert::uppercaseIdentifier;
    }
}

