/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;

public abstract class BinaryFunctionChain<L, R, V, O>
extends AbstractBinaryFunction<L, R, O> {
    public BinaryFunctionChain() {
        super(null, null);
    }

    public abstract BinaryFunction<L, R, ? extends V> getInner();

    public abstract BinaryFunction<?, ?, O> getOuter();

    @Override
    public String toString() {
        String sResult = this.getOuter().toString();
        sResult = sResult.indexOf("#") >= 0 ? sResult.replace("#", this.getInner().toString()) : sResult + "(" + this.getInner().toString() + ")";
        return sResult;
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        BinaryFunctionChain rOtherFunction = (BinaryFunctionChain)rOther;
        return this.getOuter().equals(rOtherFunction.getOuter()) && this.getInner().equals(rOtherFunction.getInner());
    }

    @Override
    protected int paramsHashCode() {
        return 31 * this.getOuter().hashCode() + this.getInner().hashCode();
    }

    public static class RightFunctionChain<L, R, V, O>
    extends BinaryFunctionChain<L, R, V, O> {
        private final BinaryFunction<L, V, O> rOuter;
        private final BinaryFunction<L, R, ? extends V> rInner;

        public RightFunctionChain(BinaryFunction<L, V, O> rOuter, BinaryFunction<L, R, ? extends V> rInner) {
            this.rOuter = rOuter;
            this.rInner = rInner;
        }

        @Override
        public O evaluate(L rLeftValue, R rRightValue) {
            return this.rOuter.evaluate(rLeftValue, this.rInner.evaluate(rLeftValue, rRightValue));
        }

        @Override
        public BinaryFunction<L, R, ? extends V> getInner() {
            return this.rInner;
        }

        @Override
        public BinaryFunction<L, V, O> getOuter() {
            return this.rOuter;
        }
    }

    public static class LeftFunctionChain<L, R, V, O>
    extends BinaryFunctionChain<L, R, V, O> {
        private final BinaryFunction<V, R, O> rOuter;
        private final BinaryFunction<L, R, ? extends V> rInner;

        public LeftFunctionChain(BinaryFunction<V, R, O> rOuter, BinaryFunction<L, R, ? extends V> rInner) {
            this.rOuter = rOuter;
            this.rInner = rInner;
        }

        @Override
        public O evaluate(L rLeftValue, R rRightValue) {
            return this.rOuter.evaluate(this.rInner.evaluate(rLeftValue, rRightValue), rRightValue);
        }

        @Override
        public BinaryFunction<L, R, ? extends V> getInner() {
            return this.rInner;
        }

        @Override
        public BinaryFunction<V, R, O> getOuter() {
            return this.rOuter;
        }
    }
}

