/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.BinaryFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.expression.function.AbstractFunction;
import java.util.List;

public class BinaryFunctionGroup<L, R>
extends AbstractBinaryFunction<L, R, L> {
    private final List<BinaryFunction<? super L, ? super R, ?>> rFunctions;

    public BinaryFunctionGroup(R rRightValue, List<BinaryFunction<? super L, ? super R, ?>> rFunctions) {
        super(rRightValue, "Group" + rFunctions);
        this.rFunctions = rFunctions;
    }

    @Override
    public L evaluate(L rLeft, R rRight) {
        for (BinaryFunction<L, R, ?> rFunction : this.rFunctions) {
            rFunction.evaluate(rLeft, rRight);
        }
        return rLeft;
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        BinaryFunctionGroup rOtherFunction = (BinaryFunctionGroup)rOther;
        int nCount = this.rFunctions.size();
        if (nCount != rOtherFunction.rFunctions.size()) {
            return false;
        }
        for (int i = 0; i < nCount; ++i) {
            if (this.rFunctions.get(i).equals(rOtherFunction.rFunctions.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int paramsHashCode() {
        int nHashCode = 17;
        for (Function function : this.rFunctions) {
            nHashCode = nHashCode * 31 + function.hashCode();
        }
        return nHashCode;
    }
}

