/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.Predicates;
import de.esoco.lib.expression.ThrowingSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class CachingSupplier<T>
implements ThrowingSupplier<T> {
    private final ThrowingSupplier<T> fSupplyValue;
    private final Predicate<? super T> pCheckInvalid;
    private T rCachedValue = null;

    private CachingSupplier(ThrowingSupplier<T> fSupplyValue, Predicate<? super T> pCheckInvalid) {
        this.fSupplyValue = fSupplyValue;
        this.pCheckInvalid = pCheckInvalid;
    }

    public static <T> CachingSupplier<T> cached(Supplier<T> fSupplyValue) {
        return new CachingSupplier(() -> fSupplyValue.get(), Predicates.alwaysFalse());
    }

    public static <T> CachingSupplier<T> cached(ThrowingSupplier<T> fSupplyValue) {
        return new CachingSupplier<T>(fSupplyValue, Predicates.alwaysFalse());
    }

    public T tryGet() throws Exception {
        if (this.rCachedValue == null || this.pCheckInvalid.test(this.rCachedValue)) {
            this.rCachedValue = this.fSupplyValue.tryGet();
        }
        return this.rCachedValue;
    }

    public CachingSupplier<T> until(Predicate<? super T> pCheckInvalid) {
        return new CachingSupplier<T>(this.fSupplyValue, pCheckInvalid);
    }
}

