/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.function.AbstractFunction;
import java.util.Calendar;
import java.util.Date;

public class CalendarFunctions {
    private static final int[] ORDERED_CALENDAR_FIELDS = new int[]{14, 13, 12, 11, 5, 2, 1, 0};
    private static final Function<Calendar, Calendar> CLEAR_TIME = new AbstractFunction<Calendar, Calendar>("clearTime"){

        @Override
        public Calendar evaluate(Calendar rCalendar) {
            return CalendarFunctions.clearTime(rCalendar);
        }
    };
    private static final Function<Calendar, Date> GET_TIME = new AbstractFunction<Calendar, Date>("getTime"){

        @Override
        public Date evaluate(Calendar rCalendar) {
            return rCalendar.getTime();
        }
    };

    private CalendarFunctions() {
    }

    public static Function<Calendar, Calendar> clearTime() {
        return CLEAR_TIME;
    }

    public static Calendar clearTime(Calendar rCalendar) {
        rCalendar.set(11, 0);
        rCalendar.set(12, 0);
        rCalendar.set(13, 0);
        rCalendar.set(14, 0);
        return rCalendar;
    }

    public static Function<Calendar, Date> getTime() {
        return GET_TIME;
    }

    public static boolean isTimeField(int nCalendarField) {
        return nCalendarField == 14 || nCalendarField == 13 || nCalendarField == 12 || nCalendarField == 10 || nCalendarField == 11 || nCalendarField == 9;
    }

    public static boolean isZeroBased(int nCalendarField) {
        return nCalendarField != 7 && nCalendarField != 5 && nCalendarField != 4 && nCalendarField != 3;
    }

    public static Calendar resetBelow(int nCalendarField, Calendar rCalendar, boolean bMaximum) {
        int nFieldIndex;
        for (nFieldIndex = 0; nFieldIndex < ORDERED_CALENDAR_FIELDS.length && ORDERED_CALENDAR_FIELDS[nFieldIndex] != nCalendarField; ++nFieldIndex) {
        }
        if (nFieldIndex < ORDERED_CALENDAR_FIELDS.length) {
            for (int i = nFieldIndex - 1; i >= 0; --i) {
                int nField = ORDERED_CALENDAR_FIELDS[i];
                rCalendar.set(nField, bMaximum ? rCalendar.getActualMaximum(nField) : rCalendar.getActualMinimum(nField));
            }
        }
        return rCalendar;
    }

    public static Date today() {
        Calendar aToday = Calendar.getInstance();
        aToday.setTimeInMillis(System.currentTimeMillis());
        return CalendarFunctions.clearTime(aToday).getTime();
    }
}

