/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.function.AbstractFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class ConditionalFunction<I, O>
extends AbstractFunction<I, O> {
    private final Predicate<? super I> pCondition;
    private final Function<? super I, ? extends O> fTrue;
    private final Function<? super I, ? extends O> fFalse;

    public ConditionalFunction(Predicate<? super I> pCondition, Function<? super I, O> fTrue) {
        this(pCondition, fTrue, null);
    }

    public ConditionalFunction(Predicate<? super I> pCondition, Function<? super I, ? extends O> fTrue, Function<? super I, ? extends O> fFalse) {
        super("IF");
        assert (pCondition != null && fTrue != null);
        this.pCondition = pCondition;
        this.fTrue = fTrue;
        this.fFalse = fFalse;
    }

    public Function<I, O> elseDo(Function<? super I, ? extends O> rFunction) {
        return new ConditionalFunction<I, O>(this.pCondition, this.fTrue, rFunction);
    }

    @Override
    public O evaluate(I rInput) {
        O rResult = null;
        if (this.pCondition.test(rInput)) {
            rResult = this.fTrue.apply(rInput);
        } else if (this.fFalse != null) {
            rResult = this.fFalse.apply(rInput);
        }
        return rResult;
    }

    @Override
    public String toString() {
        return "IF " + this.pCondition + " DO " + this.fTrue + " ELSE " + (this.fFalse != null ? this.fFalse : "value=NULL");
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        boolean bEqual;
        ConditionalFunction rOtherFunction = (ConditionalFunction)rOther;
        boolean bl = bEqual = this.pCondition.equals(rOtherFunction.pCondition) && this.fTrue.equals(rOtherFunction.fTrue);
        if (bEqual) {
            bEqual = this.fFalse != null ? this.fFalse.equals(rOtherFunction.fFalse) : rOtherFunction.fFalse == null;
        }
        return bEqual;
    }

    @Override
    protected int paramsHashCode() {
        int nHashCode = this.pCondition.hashCode();
        nHashCode = nHashCode * 31 + this.fTrue.hashCode();
        nHashCode = nHashCode * 31 + (this.fFalse != null ? this.fFalse.hashCode() : 0);
        return nHashCode;
    }
}

