/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.ElementAccessFunction;
import de.esoco.lib.expression.function.AbstractBinaryFunction;
import de.esoco.lib.reflect.ReflectUtil;
import java.util.List;
import java.util.Map;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;

public abstract class GetElement<I, E, O>
extends AbstractBinaryFunction<I, E, O>
implements ElementAccessFunction<E, I, O> {
    public GetElement(E rElementDescriptor, String sDescription) {
        super(rElementDescriptor, sDescription);
    }

    @Override
    public final O evaluate(I rObject, E rElementDescriptor) {
        return this.getElementValue(rObject, rElementDescriptor);
    }

    @Override
    public E getElementDescriptor() {
        return (E)this.getRightValue();
    }

    protected abstract O getElementValue(I var1, E var2);

    public static class ReadField<I, O>
    extends GetElement<I, String, O> {
        public ReadField(String sFieldName) {
            super(sFieldName, "ReadField");
        }

        @Override
        protected O getElementValue(I rObject, String sFieldName) {
            return (O)ReflectUtil.getFieldValue(sFieldName, rObject);
        }
    }

    public static class GetRelationValue<I extends Relatable, O>
    extends GetElement<I, RelationType<O>, O> {
        public GetRelationValue(RelationType<O> rType) {
            super(rType, "GetRelationValue");
        }

        @Override
        protected O getElementValue(I rObject, RelationType<O> rType) {
            return rObject.get(rType);
        }
    }

    public static class GetRelation<I extends Relatable, O>
    extends GetElement<I, RelationType<O>, Relation<O>> {
        public GetRelation(RelationType<O> rType) {
            super(rType, "GetRelation");
        }

        @Override
        protected Relation<O> getElementValue(I rObject, RelationType<O> rType) {
            return rObject.getRelation(rType);
        }
    }

    public static class GetMapValue<K, V>
    extends GetElement<Map<K, V>, K, V> {
        public GetMapValue(K rKey) {
            super(rKey, "GetMapValue");
        }

        @Override
        protected V getElementValue(Map<K, V> rMap, K rKey) {
            return rMap.get(rKey);
        }
    }

    public static class GetListElement<O>
    extends GetElement<List<O>, Integer, O> {
        public GetListElement(int nIndex) {
            super(nIndex, "GetListElement");
        }

        @Override
        protected O getElementValue(List<O> rList, Integer rIndex) {
            return rList.get(rIndex);
        }
    }

    public static class GetField<I, O>
    extends GetElement<I, String, O> {
        public GetField(String sField) {
            super(GetField.getFieldAccessMethodName(sField), GetField.getFieldAccessMethodName(sField));
        }

        private static String getFieldAccessMethodName(String sField) {
            return "get" + sField.substring(0, 1).toUpperCase() + sField.substring(1);
        }

        @Override
        protected O getElementValue(I rObject, String sFieldQueryMethod) {
            return (O)ReflectUtil.invokePublic(rObject, sFieldQueryMethod);
        }
    }
}

