/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import de.esoco.lib.expression.function.AbstractFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class Group<I>
extends AbstractFunction<I, I> {
    private final List<Consumer<? super I>> aConsumers;

    public Group(Collection<Consumer<? super I>> rFunctions) {
        super(Group.class.getSimpleName());
        this.aConsumers = new ArrayList<Consumer<I>>(rFunctions);
    }

    @SafeVarargs
    public static <I> Group<I> of(Consumer<? super I> fFirst, Consumer<? super I> ... rAdditionalConsumers) {
        ArrayList<Consumer<I>> aFunctions = new ArrayList<Consumer<I>>();
        aFunctions.add(fFirst);
        if (rAdditionalConsumers != null && rAdditionalConsumers.length > 0) {
            aFunctions.addAll(Arrays.asList(rAdditionalConsumers));
        }
        return new Group<I>(aFunctions);
    }

    @Override
    public I evaluate(I rInput) {
        for (Consumer<I> fConsumer : this.aConsumers) {
            fConsumer.accept(rInput);
        }
        return rInput;
    }

    public List<Consumer<? super I>> getMembers() {
        return new ArrayList<Consumer<? super I>>(this.aConsumers);
    }

    @Override
    protected boolean paramsEqual(AbstractFunction<?, ?> rOther) {
        Group rOtherFunction = (Group)rOther;
        int nCount = this.aConsumers.size();
        if (nCount != rOtherFunction.aConsumers.size()) {
            return false;
        }
        for (int i = 0; i < nCount; ++i) {
            if (this.aConsumers.get(i).equals(rOtherFunction.aConsumers.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int paramsHashCode() {
        int nHashCode = 17;
        for (Consumer<I> fConsumer : this.aConsumers) {
            nHashCode = nHashCode * 31 + fConsumer.hashCode();
        }
        return nHashCode;
    }
}

