/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.function;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Validation<T>
extends Function<T, ValidationResult> {
    public static <T> Validation<T> ensure(Predicate<T> pIsValid, String sInvalidMessage) {
        return v -> pIsValid.test(v) ? ValidationResult.valid() : ValidationResult.invalid(sInvalidMessage);
    }

    @Override
    default public ValidationResult apply(T rValue) {
        return this.validate(rValue);
    }

    public ValidationResult validate(T var1);

    public static class ValidationResult {
        private final String sMessage;

        protected ValidationResult(String sMessage) {
            this.sMessage = sMessage;
        }

        public static ValidationResult invalid(String sMessage) {
            Objects.requireNonNull(sMessage);
            return new ValidationResult(sMessage);
        }

        public static ValidationResult valid() {
            return new ValidationResult(null);
        }

        public String getMessage() {
            return this.sMessage;
        }

        public boolean isValid() {
            return this.sMessage == null;
        }
    }
}

