/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.predicate;

import de.esoco.lib.expression.predicate.AbstractBinaryPredicate;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class Comparison<L, R>
extends AbstractBinaryPredicate<L, R> {
    public Comparison(R rValue, String sToken) {
        super(rValue, sToken);
    }

    public static class SameAs<T>
    extends Comparison<T, Object> {
        public SameAs(Object rValue) {
            super(rValue, "==");
        }

        @Override
        public Boolean evaluate(T rLeftValue, Object rRightValue) {
            return rLeftValue == rRightValue;
        }
    }

    public static class Matching<T>
    extends Comparison<T, Pattern> {
        public Matching(String sRegularExpression) {
            this(Pattern.compile(sRegularExpression));
        }

        public Matching(Pattern rPattern) {
            super(rPattern, "matches");
        }

        @Override
        public Boolean evaluate(T rInput, Pattern rPattern) {
            return rPattern.matcher(rInput.toString()).matches();
        }
    }

    public static class LessThan<T extends Comparable<T>>
    extends Comparison<T, T> {
        public LessThan(T rValue) {
            super(rValue, "<");
        }

        @Override
        public Boolean evaluate(T rLeftValue, T rRightValue) {
            return rLeftValue.compareTo(rRightValue) < 0;
        }
    }

    public static class LessOrEqual<T extends Comparable<T>>
    extends Comparison<T, T> {
        public LessOrEqual(T rValue) {
            super(rValue, "<=");
        }

        @Override
        public Boolean evaluate(T rLeftValue, T rRightValue) {
            return rLeftValue.compareTo(rRightValue) <= 0;
        }
    }

    public static class GreaterThan<T extends Comparable<T>>
    extends Comparison<T, T> {
        public GreaterThan(T rValue) {
            super(rValue, ">");
        }

        @Override
        public Boolean evaluate(T rLeftValue, T rRightValue) {
            return rLeftValue.compareTo(rRightValue) > 0;
        }
    }

    public static class GreaterOrEqual<T extends Comparable<T>>
    extends Comparison<T, T> {
        public GreaterOrEqual(T rValue) {
            super(rValue, ">=");
        }

        @Override
        public Boolean evaluate(T rLeftValue, T rRightValue) {
            return rLeftValue.compareTo(rRightValue) >= 0;
        }
    }

    public static class EqualTo<T>
    extends Comparison<T, Object> {
        public EqualTo(Object rValue) {
            super(rValue, "=");
        }

        @Override
        public Boolean evaluate(T rLeftValue, Object rRightValue) {
            return Objects.equals(rLeftValue, rRightValue);
        }
    }

    public static class ElementOf<T>
    extends Comparison<T, Collection<?>> {
        public ElementOf(Collection<?> rValue) {
            super(rValue, "ElementOf");
        }

        @Override
        public Boolean evaluate(T rValue, Collection<?> rCollection) {
            return rCollection.contains(rValue);
        }
    }
}

