/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.expression.predicate;

import de.esoco.lib.expression.Predicate;

public abstract class PredicateJoin<T>
implements Predicate<T> {
    private final Predicate<? super T> rLeft;
    private final Predicate<? super T> rRight;
    private final String sJoinToken;

    public PredicateJoin(Predicate<? super T> rLeft, Predicate<? super T> rRight, String sJoinToken) {
        if (rLeft == null || rRight == null) {
            throw new IllegalArgumentException("Predicates must not be NULL");
        }
        this.rLeft = rLeft;
        this.rRight = rRight;
        this.sJoinToken = sJoinToken;
    }

    public boolean equals(Object rObj) {
        if (rObj == this) {
            return true;
        }
        if (rObj == null || rObj.getClass() != this.getClass()) {
            return false;
        }
        PredicateJoin rOther = (PredicateJoin)rObj;
        return this.rLeft.equals(rOther.rLeft) && this.rRight.equals(rOther.rRight);
    }

    @Override
    public final Boolean evaluate(T rValue) {
        return this.evaluate(this.rLeft, this.rRight, rValue);
    }

    public final Predicate<? super T> getLeft() {
        return this.rLeft;
    }

    public final Predicate<? super T> getRight() {
        return this.rRight;
    }

    public int hashCode() {
        return 31 * (this.rLeft.hashCode() + 31 * this.rRight.hashCode());
    }

    public String toString() {
        return "(" + this.rLeft + " " + this.sJoinToken + " " + this.rRight + ")";
    }

    protected abstract Boolean evaluate(Predicate<? super T> var1, Predicate<? super T> var2, T var3);
}

