/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.json;

import de.esoco.lib.json.JsonBuilder;
import de.esoco.lib.json.JsonObject;
import de.esoco.lib.json.JsonParser;
import de.esoco.lib.text.TextConvert;
import de.esoco.lib.text.TextUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public class Json {
    public static final DateFormat JSON_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
    public static final RelationType<TextConvert.IdentifierStyle> JSON_PROPERTY_NAMING = RelationTypes.newType(new RelationTypeModifier[0]);
    public static final RelationType<Collection<RelationType<?>>> JSON_SERIALIZED_TYPES = RelationTypes.newType(new RelationTypeModifier[0]);
    public static final RelationType<Map<String, Object>> JSON_PROPERTIES = RelationTypes.newMapType(true, new RelationTypeModifier[0]);

    private Json() {
    }

    public static String escape(String sOriginal) {
        StringBuilder aResult = new StringBuilder();
        int nLength = sOriginal.length();
        block10: for (int nChar = 0; nChar < nLength; ++nChar) {
            char c = sOriginal.charAt(nChar);
            switch (c) {
                case '\"': {
                    aResult.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    aResult.append("\\\\");
                    continue block10;
                }
                case '/': {
                    aResult.append("\\/");
                    continue block10;
                }
                case '\b': {
                    aResult.append("\\b");
                    continue block10;
                }
                case '\f': {
                    aResult.append("\\f");
                    continue block10;
                }
                case '\n': {
                    aResult.append("\\n");
                    continue block10;
                }
                case '\r': {
                    aResult.append("\\r");
                    continue block10;
                }
                case '\t': {
                    aResult.append("\\t");
                    continue block10;
                }
                default: {
                    if (TextUtil.isControlCharacter(c)) {
                        String sHexValue = Integer.toHexString(c).toUpperCase();
                        aResult.append("\\u");
                        aResult.append(TextConvert.padLeft((String)sHexValue, (int)4, (char)'0'));
                        continue block10;
                    }
                    aResult.append(c);
                }
            }
        }
        return aResult.toString();
    }

    public static Object parse(String sJson) {
        return new JsonParser().parse(sJson);
    }

    public static <T> T parse(String sJson, Class<T> rDatatype) {
        return new JsonParser().parse(sJson, rDatatype);
    }

    public static List<Object> parseArray(String sJsonArray) {
        return new JsonParser().parseArray(sJsonArray);
    }

    public static List<Object> parseArray(String sJsonArray, int nDepth) {
        return new JsonParser(nDepth).parseArray(sJsonArray);
    }

    public static <T> List<T> parseArray(String sJsonArray, Class<T> rElementType) {
        return new JsonParser().parseArray(sJsonArray, rElementType);
    }

    public static JsonObject parseObject(String sJson) {
        return new JsonParser().parseObject(sJson);
    }

    public static JsonObject parseObject(String sJson, int nDepth) {
        return new JsonParser(nDepth).parseObject(sJson);
    }

    public static String restore(String sEscaped) {
        StringBuilder aResult = new StringBuilder();
        int nMax = sEscaped.length() - 1;
        int i = 0;
        while (i <= nMax) {
            char c;
            if ((c = sEscaped.charAt(i++)) == '\\' && i <= nMax) {
                c = sEscaped.charAt(i++);
                switch (c) {
                    case '\"': {
                        aResult.append('\"');
                        break;
                    }
                    case '\\': {
                        aResult.append('\\');
                        break;
                    }
                    case '/': {
                        aResult.append('/');
                        break;
                    }
                    case 'b': {
                        aResult.append('\b');
                        break;
                    }
                    case 'f': {
                        aResult.append('\f');
                        break;
                    }
                    case 'n': {
                        aResult.append('\n');
                        break;
                    }
                    case 'r': {
                        aResult.append('\r');
                        break;
                    }
                    case 't': {
                        aResult.append('\t');
                        break;
                    }
                    case 'u': {
                        try {
                            String sHex = sEscaped.substring(i, i + 4);
                            char cHex = (char)Integer.parseInt(sHex, 16);
                            if (TextUtil.isControlCharacter(cHex)) {
                                aResult.append(cHex);
                                i += 4;
                                break;
                            }
                            aResult.append("\\u");
                        }
                        catch (Exception e) {
                            aResult.append("\\u");
                        }
                        break;
                    }
                    default: {
                        aResult.append('\\');
                        aResult.append(c);
                        break;
                    }
                }
                continue;
            }
            aResult.append(c);
        }
        return aResult.toString();
    }

    public static String toCompactJson(Object rValue) {
        return new JsonBuilder().noLinefeeds().noWhitespace().toJson(rValue);
    }

    public static String toJson(Object rValue) {
        return new JsonBuilder().toJson(rValue);
    }

    static {
        RelationTypes.init(Json.class);
    }

    public static enum JsonStructure {
        OBJECT('{', '}'),
        ARRAY('[', ']'),
        STRING('\"', '\"');

        char cOpen;
        char cClose;

        private JsonStructure(char cOpen, char cClose) {
            this.cOpen = cOpen;
            this.cClose = cClose;
        }
    }
}

