/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.json;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.expression.Conversions;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.json.Json;
import de.esoco.lib.json.JsonParser;
import de.esoco.lib.json.JsonSerializable;
import de.esoco.lib.text.TextConvert;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.type.ListenerTypes;
import org.obrel.type.MetaTypes;

public class JsonBuilder {
    private static final ConvertJson CONVERT_JSON = new ConvertJson();
    private static final Predicate<Relation<?>> IS_NOT_TRANSIENT = r -> !r.getType().hasModifier(RelationTypeModifier.TRANSIENT);
    private static final Collection<RelationType<?>> DEFAULT_EXCLUDED_RELATION_TYPES = CollectionUtil.setOf(ListenerTypes.RELATION_LISTENERS, ListenerTypes.RELATION_TYPE_LISTENERS, ListenerTypes.RELATION_UPDATE_LISTENERS, MetaTypes.IMMUTABLE);
    private final StringBuilder aJson = new StringBuilder();
    private String sIndent;
    private String sCurrentIndent = this.sIndent = "";
    private boolean bWhitespace = true;
    private boolean bMultiLine = true;
    private boolean bRecursiveRelations = false;
    private boolean bNamespaces = false;
    private final Collection<RelationType<?>> aExcludedRelationTypes = new HashSet(DEFAULT_EXCLUDED_RELATION_TYPES);

    public static <T> Function<T, String> buildJson(String sIndent) {
        return rValue -> new JsonBuilder().indent(sIndent).append(rValue).toString();
    }

    public static InvertibleFunction<Object, String> convertJson() {
        return CONVERT_JSON;
    }

    public JsonBuilder append(Object rValue) {
        if (rValue == null) {
            this.aJson.append("null");
        } else if (rValue instanceof JsonSerializable) {
            ((JsonSerializable)rValue).appendTo(this);
        } else if (rValue instanceof Boolean || rValue instanceof Number) {
            this.aJson.append(rValue);
        } else if (rValue instanceof Date) {
            this.appendString(Json.JSON_DATE_FORMAT.format((Date)rValue));
        } else if (rValue.getClass().isArray()) {
            if (rValue.getClass().getComponentType().isPrimitive()) {
                int nCount = Array.getLength(rValue);
                Object[] aWrappedValues = new Object[nCount];
                for (int i = 0; i < nCount; ++i) {
                    aWrappedValues[i] = Array.get(rValue, i);
                }
                rValue = aWrappedValues;
            }
            this.appendArray(Arrays.asList((Object[])rValue));
        } else if (rValue instanceof Iterable) {
            this.appendArray((Iterable)rValue);
        } else if (rValue instanceof Map) {
            this.appendObject((Map)rValue);
        } else if (rValue instanceof RelationType) {
            this.appendString(Json.escape(rValue.toString()));
        } else if (this.bRecursiveRelations && rValue instanceof Relatable) {
            this.appendRelatable((Relatable)rValue, null, this.bRecursiveRelations);
        } else {
            String sValue;
            try {
                sValue = Conversions.asString(rValue);
            }
            catch (Exception e) {
                sValue = rValue.toString();
            }
            this.appendString(Json.escape(sValue));
        }
        return this;
    }

    public boolean append(Relation<?> rRelation, TextConvert.IdentifierStyle eNamingStyle, boolean bAppendNullValues) {
        boolean bHasValue;
        Object rValue = rRelation.getTarget();
        boolean bl = bHasValue = rValue != null || bAppendNullValues;
        if (bHasValue) {
            String sNamespace;
            RelationType<?> rRelationType = rRelation.getType();
            String sName = rRelationType.getSimpleName();
            if (eNamingStyle != TextConvert.IdentifierStyle.UPPERCASE) {
                sName = TextConvert.convertTo((TextConvert.IdentifierStyle)eNamingStyle, (String)sName);
            }
            if (this.bNamespaces && !(sNamespace = rRelationType.getNamespace()).isEmpty()) {
                sName = sNamespace + '.' + sName;
            }
            this.appendName(sName);
            this.append(rValue);
        }
        return bHasValue;
    }

    public JsonBuilder appendArray(Iterable<?> rElements) {
        this.aJson.append(Json.JsonStructure.ARRAY.cOpen);
        if (rElements != null) {
            Iterator<?> rIterator = rElements.iterator();
            boolean bHasNext = rIterator.hasNext();
            while (bHasNext) {
                this.append(rIterator.next());
                bHasNext = rIterator.hasNext();
                if (!bHasNext) continue;
                this.aJson.append(',');
                if (!this.bWhitespace) continue;
                this.aJson.append(' ');
            }
        }
        this.aJson.append(Json.JsonStructure.ARRAY.cClose);
        return this;
    }

    public JsonBuilder appendName(String sName) {
        this.appendString(sName);
        this.aJson.append(':');
        if (this.bWhitespace) {
            this.aJson.append(' ');
        }
        return this;
    }

    public JsonBuilder appendObject(Map<?, ?> rMap) {
        this.beginObject();
        if (rMap != null && !rMap.isEmpty()) {
            int nCount = rMap.size();
            for (Map.Entry<?, ?> rEntry : rMap.entrySet()) {
                this.appendName(rEntry.getKey().toString());
                this.append(rEntry.getValue());
                if (--nCount <= 0) continue;
                this.aJson.append(',');
                this.newLine();
            }
        }
        this.endObject();
        return this;
    }

    public JsonBuilder appendRelatable(Relatable rObject, Collection<RelationType<?>> rRelationTypes, boolean bRecursive) {
        this.bRecursiveRelations = bRecursive;
        this.beginObject();
        this.appendRelations(rObject, rRelationTypes);
        this.endObject();
        return this;
    }

    public JsonBuilder appendRelations(Relatable rObject, Collection<RelationType<?>> rRelationTypes) {
        Predicate pMatchesType;
        TextConvert.IdentifierStyle eNamingStyle = rObject.get(Json.JSON_PROPERTY_NAMING);
        if (rRelationTypes == null && rObject.hasRelation(Json.JSON_SERIALIZED_TYPES)) {
            rRelationTypes = rObject.get(Json.JSON_SERIALIZED_TYPES);
            if (eNamingStyle == null) {
                eNamingStyle = TextConvert.IdentifierStyle.LOWER_CAMELCASE;
            }
        } else if (eNamingStyle == null) {
            eNamingStyle = TextConvert.IdentifierStyle.UPPERCASE;
        }
        if (rRelationTypes != null) {
            Collection<RelationType<?>> rTypes = rRelationTypes;
            pMatchesType = r -> rTypes.contains(r.getType());
        } else {
            pMatchesType = r -> !this.aExcludedRelationTypes.contains(r.getType());
        }
        this.appendRelations(rObject.getRelations(IS_NOT_TRANSIENT.and(pMatchesType)), eNamingStyle, true);
        return this;
    }

    public JsonBuilder appendString(String sStringValue) {
        this.aJson.append(Json.JsonStructure.STRING.cOpen);
        this.aJson.append(sStringValue);
        this.aJson.append(Json.JsonStructure.STRING.cClose);
        return this;
    }

    public JsonBuilder appendText(String sText) {
        this.aJson.append(sText);
        return this;
    }

    public JsonBuilder beginObject() {
        this.aJson.append(Json.JsonStructure.OBJECT.cOpen);
        this.sCurrentIndent = this.sCurrentIndent + this.sIndent;
        this.newLine();
        return this;
    }

    public JsonBuilder compact() {
        return this.noWhitespace().noLinefeeds();
    }

    public JsonBuilder endObject() {
        this.sCurrentIndent = this.sCurrentIndent.substring(0, this.sCurrentIndent.length() - this.sIndent.length());
        this.newLine();
        this.aJson.append(Json.JsonStructure.OBJECT.cClose);
        return this;
    }

    public JsonBuilder exclude(RelationType<?> rExcludedType) {
        this.aExcludedRelationTypes.add(rExcludedType);
        return this;
    }

    public JsonBuilder indent(String sIndent) {
        this.sIndent = sIndent;
        return this;
    }

    public int length() {
        return this.aJson.length();
    }

    public JsonBuilder noLinefeeds() {
        this.bMultiLine = false;
        return this;
    }

    public JsonBuilder noWhitespace() {
        this.bWhitespace = false;
        return this;
    }

    public String toJson(Object rValue) {
        JsonBuilder aJsonBuilder = new JsonBuilder();
        if (rValue instanceof JsonSerializable) {
            ((JsonSerializable)rValue).appendTo(aJsonBuilder);
        } else if (rValue instanceof Relatable) {
            aJsonBuilder.appendRelatable((Relatable)rValue, null, false);
        } else {
            aJsonBuilder.append(rValue);
        }
        return aJsonBuilder.toString();
    }

    public String toString() {
        return this.aJson.toString();
    }

    public JsonBuilder withNamespaces() {
        this.bNamespaces = true;
        return this;
    }

    private JsonBuilder appendRelations(Collection<Relation<?>> rRelations, TextConvert.IdentifierStyle eNamingStyle, boolean bAppendNullValues) {
        int nCount = rRelations.size();
        for (Relation<?> rRelation : rRelations) {
            this.append(rRelation, eNamingStyle, bAppendNullValues);
            if (--nCount <= 0) continue;
            this.aJson.append(',');
            this.newLine();
        }
        return this;
    }

    private JsonBuilder newLine() {
        if (this.bMultiLine) {
            this.aJson.append('\n');
            this.aJson.append(this.sCurrentIndent);
        }
        return this;
    }

    public static class ConvertJson
    implements InvertibleFunction<Object, String> {
        @Override
        public String evaluate(Object rValue) {
            return new JsonBuilder().append(rValue).toString();
        }

        @Override
        public Object invert(String sJson) {
            return new JsonParser().parse(sJson);
        }
    }
}

