/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.json;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.datatype.Pair;
import de.esoco.lib.expression.monad.Option;
import de.esoco.lib.expression.monad.Try;
import de.esoco.lib.json.Json;
import de.esoco.lib.json.JsonBuilder;
import de.esoco.lib.json.JsonParser;
import de.esoco.lib.json.JsonSerializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obrel.core.RelatedObject;

public class JsonObject
extends RelatedObject
implements JsonSerializable<JsonObject> {
    public JsonObject() {
    }

    @SafeVarargs
    public JsonObject(Pair<String, Object> ... rProperties) {
        this(CollectionUtil.orderedMapOf(rProperties));
    }

    public JsonObject(Map<String, Object> rProperties) {
        this.setProperties(rProperties);
    }

    public JsonObject(String sName, Object rValue) {
        this.set(sName, rValue);
    }

    public static JsonObject valueOf(String sJson) {
        return new JsonObject().fromJson(sJson);
    }

    @Override
    public void appendTo(JsonBuilder rBuilder) {
        rBuilder.appendObject(this.getProperties());
    }

    public boolean equals(Object rOther) {
        if (rOther == this) {
            return true;
        }
        if (rOther == null || rOther.getClass() != this.getClass()) {
            return false;
        }
        return this.relationsEqual((JsonObject)rOther);
    }

    @Override
    public JsonObject fromJson(String sJson) {
        this.setProperties(new JsonParser().parseObjectMap(sJson));
        return this;
    }

    public <T> Option<T> get(String sName, Class<? extends T> rDatatype) {
        return this.getProperty(sName).map(v -> Try.now(() -> rDatatype.cast(v)).orUse(null));
    }

    public Option<List<Object>> getArray(String sName) {
        return this.getProperty(sName).map(v -> (List)Try.now(() -> (List)v).orUse(null));
    }

    public int getInt(String sName, int nDefault) {
        Number rValue;
        Option<Object> rRawProperty = this.getProperty(sName);
        Number number = rValue = rRawProperty instanceof Number ? (Number)((Number)rRawProperty) : (Number)null;
        return rValue != null ? rValue.intValue() : (rRawProperty instanceof String ? Integer.parseInt((String)rRawProperty) : nDefault);
    }

    public long getLong(String sName, long nDefault) {
        Number rValue;
        Option<Object> rRawProperty = this.getProperty(sName);
        Number number = rValue = rRawProperty instanceof Number ? (Number)((Number)rRawProperty) : (Number)null;
        return rValue != null ? rValue.longValue() : (rRawProperty instanceof String ? Long.parseLong((String)rRawProperty) : nDefault);
    }

    public Option<Number> getNumber(String sName) {
        return this.get(sName, Number.class);
    }

    public Option<JsonObject> getObject(String sName) {
        return this.get(sName, JsonObject.class);
    }

    public final Map<String, Object> getProperties() {
        return this.get(Json.JSON_PROPERTIES);
    }

    public Option<Object> getProperty(String sName) {
        return Option.of(this.hasRelation(Json.JSON_PROPERTIES) ? this.getProperties().get(sName) : null);
    }

    public final Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public final Collection<Object> getPropertyValues() {
        return this.getProperties().values();
    }

    public Option<String> getString(String sName) {
        return this.get(sName, String.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasFlag(String sName) {
        Option<Object> oValue = this.getProperty(sName);
        if (!oValue.is(Boolean.class)) return false;
        if ((Boolean)oValue.map(Boolean.class::cast).orFail() == false) return false;
        return true;
    }

    public int hashCode() {
        return 11 + this.relationsHashCode();
    }

    public boolean hasProperty(String sName) {
        return this.hasRelation(Json.JSON_PROPERTIES) && this.getProperties().containsKey(sName);
    }

    public boolean hasPropertyValue(String sName) {
        return this.getProperty(sName) != null;
    }

    public boolean isEmpty() {
        return this.getProperties().isEmpty();
    }

    public void remove(String sName) {
        this.getProperties().remove(sName);
    }

    public void set(String sName, Object rValue) {
        this.getProperties().put(sName, rValue);
    }

    public void setProperties(Map<String, Object> rProperties) {
        if (!rProperties.isEmpty()) {
            this.get(Json.JSON_PROPERTIES).putAll(rProperties);
        }
    }

    @Override
    public String toString() {
        return this.toJson();
    }

    public JsonObject with(String sName, Object rValue) {
        this.getProperties().put(sName, rValue);
        return this;
    }
}

