/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.json;

import de.esoco.lib.expression.Action;
import de.esoco.lib.expression.Conversions;
import de.esoco.lib.expression.Function;
import de.esoco.lib.json.Json;
import de.esoco.lib.json.JsonObject;
import de.esoco.lib.json.JsonSerializable;
import de.esoco.lib.property.ErrorHandling;
import de.esoco.lib.reflect.ReflectUtil;
import de.esoco.lib.text.TextConvert;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;

public class JsonParser {
    private int nDepth;

    public JsonParser() {
        this(Short.MAX_VALUE);
    }

    public JsonParser(int nDepth) {
        this.nDepth = nDepth;
    }

    public static Function<String, Object> parseJson() {
        return sJson -> new JsonParser().parse((String)sJson);
    }

    public static <T> Function<String, T> parseJson(Class<T> rDatatype) {
        return sJson -> new JsonParser().parse((String)sJson, rDatatype);
    }

    public static <T> Function<String, List<T>> parseJsonArray(Class<T> rElementType) {
        return sJson -> new JsonParser().parseArray((String)sJson, rElementType);
    }

    public static Function<String, Map<String, Object>> parseJsonMap() {
        return sJson -> new JsonParser().parseObjectMap((String)sJson);
    }

    public Object parse(String sJson) {
        Object aValue = sJson == null || sJson.isEmpty() ? null : (this.nDepth <= 0 ? sJson : (sJson.charAt(0) == Json.JsonStructure.STRING.cOpen ? Json.restore(sJson.substring(1, sJson.length() - 1)) : (sJson.charAt(0) == Json.JsonStructure.OBJECT.cOpen ? this.parseObject(sJson) : (sJson.charAt(0) == Json.JsonStructure.ARRAY.cOpen ? this.parseArray(sJson, new ArrayList()) : (sJson.equals("null") ? null : (sJson.equals("true") || sJson.equals("false") ? (Serializable)Boolean.valueOf(sJson) : (Serializable)this.parseNumber(sJson)))))));
        return aValue;
    }

    public <T> T parse(String sJsonValue, Class<? extends T> rDatatype) {
        Object rValue;
        if ("null".equals(sJsonValue)) {
            rValue = null;
        } else if (JsonSerializable.class.isAssignableFrom(rDatatype)) {
            rValue = ReflectUtil.newInstance(rDatatype);
            ((JsonSerializable)rValue).fromJson(sJsonValue);
        } else if (rDatatype == Boolean.class || rDatatype == Boolean.TYPE) {
            rValue = Boolean.valueOf(sJsonValue);
        } else if (rDatatype.isPrimitive()) {
            rValue = this.parseNumber(sJsonValue, ReflectUtil.getWrapperType(rDatatype));
        } else if (Number.class.isAssignableFrom(rDatatype)) {
            rValue = this.parseNumber(sJsonValue, rDatatype);
        } else if (rDatatype.isArray()) {
            rValue = this.parseIntoArray(sJsonValue, rDatatype);
        } else if (Collection.class.isAssignableFrom(rDatatype)) {
            AbstractCollection aCollection = Set.class.isAssignableFrom(rDatatype) ? new HashSet() : new ArrayList();
            rValue = this.parseArray(sJsonValue, aCollection);
        } else if (Map.class.isAssignableFrom(rDatatype)) {
            rValue = this.parseObject(sJsonValue);
        } else if (Date.class.isAssignableFrom(rDatatype)) {
            rValue = this.parseDate(sJsonValue);
        } else if (Relatable.class.isAssignableFrom(rDatatype)) {
            rValue = this.parseRelatable(sJsonValue, rDatatype);
        } else {
            sJsonValue = this.getContent(sJsonValue, Json.JsonStructure.STRING);
            sJsonValue = Json.restore(sJsonValue);
            rValue = Conversions.parseValue(sJsonValue, rDatatype);
        }
        return (T)rValue;
    }

    public List<Object> parseArray(String sJsonArray) {
        return this.parseArray(sJsonArray, new ArrayList());
    }

    public <C extends Collection<Object>> C parseArray(String sJsonArray, C rTargetCollection) {
        this.parseStructure(sJsonArray, Json.JsonStructure.ARRAY, sArrayElement -> rTargetCollection.add(this.parse((String)sArrayElement)));
        return rTargetCollection;
    }

    public <T> List<T> parseArray(String sJsonArray, Class<T> rElementType) {
        return this.parseArray(sJsonArray, new ArrayList(), rElementType);
    }

    public <T, C extends Collection<T>> C parseArray(String sJsonArray, C rTargetCollection, Class<T> rElementType) {
        this.parseStructure(sJsonArray, Json.JsonStructure.ARRAY, sArrayElement -> rTargetCollection.add(this.parse((String)sArrayElement, rElementType)));
        return rTargetCollection;
    }

    public Number parseNumber(String sJsonNumber) {
        BigInteger aBigInt;
        int nBitLength;
        Number aNumber = sJsonNumber.indexOf(46) > 0 ? new BigDecimal(sJsonNumber) : ((nBitLength = (aBigInt = new BigInteger(sJsonNumber)).bitLength()) <= 32 ? (Number)aBigInt.intValue() : (Number)(nBitLength <= 64 ? Long.valueOf(aBigInt.longValue()) : aBigInt));
        return aNumber;
    }

    public Number parseNumber(String sJsonNumber, Class<? extends Number> rDatatype) {
        Number rValue = null;
        if (rDatatype == Integer.class) {
            rValue = Integer.valueOf(sJsonNumber);
        } else if (rDatatype == Long.class) {
            rValue = Long.valueOf(sJsonNumber);
        } else if (rDatatype == Short.class) {
            rValue = Short.valueOf(sJsonNumber);
        } else if (rDatatype == Byte.class) {
            rValue = Byte.valueOf(sJsonNumber);
        } else if (rDatatype == BigInteger.class) {
            rValue = new BigInteger(sJsonNumber);
        } else if (rDatatype == BigDecimal.class) {
            rValue = new BigDecimal(sJsonNumber);
        } else if (rDatatype == Float.class) {
            rValue = Float.valueOf(sJsonNumber);
        } else if (rDatatype == Double.class) {
            rValue = Double.valueOf(sJsonNumber);
        }
        return rValue;
    }

    public JsonObject parseObject(String sJsonObject) {
        return new JsonObject(this.parseObjectMap(sJsonObject));
    }

    public Map<String, Object> parseObjectMap(String sJsonObject) {
        LinkedHashMap<String, Object> aMap = new LinkedHashMap<String, Object>();
        this.parseStructure(sJsonObject, Json.JsonStructure.OBJECT, sMapping -> this.parseMapping((String)sMapping, (Map<String, Object>)aMap));
        return aMap;
    }

    public <R extends Relatable> R parseRelatable(String sJsonObject, R rTarget) {
        this.parseStructure(sJsonObject, Json.JsonStructure.OBJECT, sObjectElement -> this.parseRelation((String)sObjectElement, rTarget));
        return rTarget;
    }

    public void parseRelation(String sJson, Relatable rTarget) {
        int nColon = sJson.indexOf(58);
        String sTypeName = sJson.substring(1, nColon - 1).trim();
        String sJsonValue = sJson.substring(nColon + 1).trim();
        RelationType<?> rRelationType = null;
        Collection<RelationType<?>> rJsonTypes = rTarget.get(Json.JSON_SERIALIZED_TYPES);
        if (rJsonTypes != null) {
            sTypeName = TextConvert.uppercaseIdentifier((String)sTypeName);
            for (RelationType<?> rType : rJsonTypes) {
                if (!rType.getSimpleName().equalsIgnoreCase(sTypeName)) continue;
                rRelationType = rType;
                break;
            }
        } else {
            rRelationType = RelationType.valueOf(sTypeName);
        }
        if (rRelationType != null) {
            Class<?> rElementType;
            Class<?> rValueType = rRelationType.getTargetType();
            Object rValue = List.class.isAssignableFrom(rValueType) ? ((rElementType = rRelationType.get(MetaTypes.ELEMENT_DATATYPE)) != null ? this.parseArray(sJsonValue, rElementType) : this.parseArray(sJsonValue)) : this.parse(sJsonValue, rValueType);
            rTarget.set(rRelationType, rValue);
        } else {
            ErrorHandling eErrorHandling = rTarget.get(MetaTypes.ERROR_HANDLING);
            if (eErrorHandling == ErrorHandling.THROW) {
                throw new IllegalArgumentException("Unknown RelationType: " + sTypeName);
            }
            if (eErrorHandling == ErrorHandling.LOG) {
                System.out.printf("Warning: unknown RelationType %s\n", sTypeName);
            }
        }
    }

    private String getContent(String sJsonStructure, Json.JsonStructure eStructure) {
        if ((sJsonStructure = sJsonStructure.trim()).charAt(0) != eStructure.cOpen || sJsonStructure.charAt(sJsonStructure.length() - 1) != eStructure.cClose) {
            throw new IllegalArgumentException("Not a JSON " + eStructure.name().toLowerCase() + ": " + sJsonStructure);
        }
        return sJsonStructure.substring(1, sJsonStructure.length() - 1).trim();
    }

    private Date parseDate(String sJsonDate) {
        sJsonDate = this.getContent(sJsonDate, Json.JsonStructure.STRING);
        try {
            return Json.JSON_DATE_FORMAT.parse(sJsonDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid JSON date", e);
        }
    }

    private Object parseIntoArray(String sJsonArray, Class<?> rArrayType) {
        Class<?> rComponentType = rArrayType.getComponentType();
        List<?> rArrayValues = this.parseArray(sJsonArray, rComponentType);
        int nCount = rArrayValues.size();
        Object rValue = Array.newInstance(rComponentType, nCount);
        for (int i = 0; i < nCount; ++i) {
            Array.set(rValue, i, rArrayValues.get(i));
        }
        return rValue;
    }

    private void parseMapping(String sMapping, Map<String, Object> rMap) {
        int nPos = sMapping.indexOf(58);
        String sKey = sMapping.substring(1, nPos - 1).trim();
        String sJsonValue = sMapping.substring(nPos + 1).trim();
        rMap.put(sKey, this.parse(sJsonValue));
    }

    private <T> Object parseRelatable(String sJsonValue, Class<? extends T> rDatatype) {
        RelatedObject rValue;
        if (RelationType.class.isAssignableFrom(rDatatype)) {
            rValue = RelationType.valueOf(sJsonValue);
        } else {
            Relatable aRelatable = rDatatype == Relatable.class ? new RelatedObject() : (Relatable)ReflectUtil.newInstance(rDatatype);
            rValue = this.parseRelatable(sJsonValue, aRelatable);
        }
        return rValue;
    }

    private void parseStructure(String sJsonData, Json.JsonStructure eStructure, Action<String> fProcessElement) {
        String sJson = this.getContent(sJsonData, eStructure);
        int nMax = sJson.length() - 1;
        int nElementStart = 0;
        int nElementEnd = 0;
        --this.nDepth;
        while (nElementEnd <= nMax) {
            char cCurrentChar;
            Json.JsonStructure eSkippedStructure = null;
            int nStructureLevel = 0;
            boolean bInString = false;
            do {
                if (!((cCurrentChar = sJson.charAt(nElementEnd++)) != Json.JsonStructure.STRING.cOpen || bInString && sJson.charAt(nElementEnd - 2) == '\\')) {
                    boolean bl = bInString = !bInString;
                }
                if (bInString) continue;
                if (cCurrentChar == Json.JsonStructure.ARRAY.cOpen) {
                    if (eSkippedStructure == null) {
                        eSkippedStructure = Json.JsonStructure.ARRAY;
                    }
                    if (eSkippedStructure != Json.JsonStructure.ARRAY) continue;
                    ++nStructureLevel;
                    continue;
                }
                if (cCurrentChar == Json.JsonStructure.OBJECT.cOpen) {
                    if (eSkippedStructure == null) {
                        eSkippedStructure = Json.JsonStructure.OBJECT;
                    }
                    if (eSkippedStructure != Json.JsonStructure.OBJECT) continue;
                    ++nStructureLevel;
                    continue;
                }
                if (eSkippedStructure == null || cCurrentChar != eSkippedStructure.cClose || --nStructureLevel != 0) continue;
                eSkippedStructure = null;
            } while ((bInString || eSkippedStructure != null || cCurrentChar != ',') && nElementEnd <= nMax);
            if (eSkippedStructure != null || bInString) {
                if (bInString) {
                    eSkippedStructure = Json.JsonStructure.STRING;
                }
                throw new IllegalArgumentException(String.format("Unclosed JSON %s in %s", eSkippedStructure.name().toLowerCase(), sJson));
            }
            if (nElementEnd <= nMax) {
                --nElementEnd;
            }
            String sElement = sJson.substring(nElementStart, nElementEnd).trim();
            fProcessElement.execute(sElement);
            nElementStart = ++nElementEnd;
        }
        ++this.nDepth;
    }
}

