/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.logging;

import de.esoco.lib.expression.monad.Option;
import de.esoco.lib.text.TextUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.RelationTypes;

public class Profiler {
    public static final RelationType<Option<Profiler>> PROFILER = RelationTypes.newOptionType(new RelationTypeModifier[0]);
    String sDescription;
    private final long nCreationTime = System.currentTimeMillis();
    private long nStartTime = System.currentTimeMillis();
    private final Map<String, Measurement> aMeasurements = new LinkedHashMap<String, Measurement>();

    public Profiler() {
        this(null);
    }

    public Profiler(String sDescription) {
        this.sDescription = sDescription;
    }

    public final long getCreationTime() {
        return this.nCreationTime;
    }

    public Measurement getResult(String sDescription) {
        return this.aMeasurements.get(sDescription);
    }

    public Map<String, Measurement> getResults() {
        return this.aMeasurements;
    }

    public long measure(String sDescription) {
        return this.measure(sDescription, this.nStartTime);
    }

    public long measure(String sDescription, long nFromTime) {
        Measurement aMeasurement = this.aMeasurements.get(sDescription);
        long nNow = System.currentTimeMillis();
        long nDuration = nNow - nFromTime;
        if (aMeasurement == null) {
            this.aMeasurements.put(sDescription, new Measurement(nDuration));
        } else {
            aMeasurement.add(nDuration);
        }
        this.nStartTime = nNow;
        return nNow;
    }

    public void printResults(String sIndent) {
        for (String sDescription : this.aMeasurements.keySet()) {
            System.out.printf("%sTotal time for %s: %s\n", sIndent, sDescription, this.aMeasurements.get(sDescription));
        }
    }

    public void printSummary() {
        this.printSummary(this.sDescription + ":", "", 1L);
    }

    public void printSummary(String sTitle, String sElementName, long nCount) {
        long nTime = System.currentTimeMillis() - this.nCreationTime;
        String sHeader = String.format("====== %s %s ======", sTitle, TextUtil.formatDuration(nTime));
        System.out.println(sHeader);
        if (nCount > 1L) {
            String sElementTime = String.format(" Time per %s: %s ", sElementName, TextUtil.formatDuration(nTime / nCount));
            System.out.println(TextUtil.padCenter((String)sElementTime, (int)sHeader.length(), (char)'-'));
        }
        this.printResults("");
        System.out.printf("%s\n", sHeader.replaceAll(".", "="));
    }

    static {
        RelationTypes.init(Profiler.class);
    }

    public static class Measurement {
        private long nTotalTime;
        private int nCount;

        private Measurement(long nTime) {
            this.nTotalTime = nTime;
        }

        public long getAverageTime() {
            return this.nCount > 0 ? this.nTotalTime / (long)this.nCount : this.nTotalTime;
        }

        public final int getCount() {
            return this.nCount;
        }

        public long getTotalTime() {
            return this.nTotalTime;
        }

        public String toString() {
            return TextUtil.formatDuration(this.nTotalTime) + "s";
        }

        private void add(long nTime) {
            this.nTotalTime += nTime;
            ++this.nCount;
        }
    }
}

