/*
 * Decompiled with CFR 0.152.
 */
package de.esoco.lib.reflect;

import de.esoco.lib.collection.BidirectionalMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReflectUtil {
    private static final String THIS_CLASS_NAME = ReflectUtil.class.getName();
    private static final String THREAD_CLASS_NAME = Thread.class.getName();
    public static final Class<?>[] NO_ARGS = new Class[0];
    private static final Map<Class<?>, Class<?>> aInterfaceImplementationMap = new HashMap();
    private static final BidirectionalMap<Class<?>, Class<?>> aWrapperPrimitiveMap = new BidirectionalMap();

    public static <T> boolean assertConstantDeclarations(Class<?> rDeclaringClass, Class<? super T> rConstantClass, String sNameMethod, boolean bAllAccessModifiers) {
        ReflectUtil.collectConstants(rDeclaringClass, rConstantClass, sNameMethod, bAllAccessModifiers, false, true);
        return true;
    }

    public static <T extends Member> T checkAccessible(T rMember) {
        if (rMember instanceof AccessibleObject) {
            Class<?> rMemberClass = rMember.getDeclaringClass();
            if (!Modifier.isPublic(rMember.getModifiers()) || !Modifier.isPublic(rMemberClass.getModifiers())) {
                ((AccessibleObject)((Object)rMember)).setAccessible(true);
            }
        }
        return rMember;
    }

    public static <T> List<T> collectConstants(Class<?> rDeclaringClass, Class<? super T> rConstantClass, String sCheckNameMethod, boolean bAllAccessModifiers, boolean bWithSuperclasses, boolean bAllowNamespace) {
        ArrayList<Object> aConstants = new ArrayList<Object>();
        try {
            List<Field> rFields = bWithSuperclasses ? (bAllAccessModifiers ? ReflectUtil.getAllFields(rDeclaringClass) : Arrays.asList(rDeclaringClass.getFields())) : Arrays.asList(rDeclaringClass.getDeclaredFields());
            Method rCheckNameMethod = sCheckNameMethod != null ? rConstantClass.getMethod(sCheckNameMethod, new Class[0]) : null;
            for (Field rField : rFields) {
                int nModifiers = rField.getModifiers();
                if (!Modifier.isStatic(nModifiers) || !bAllAccessModifiers && !Modifier.isPublic(nModifiers) || !rConstantClass.isAssignableFrom(rField.getType())) continue;
                if (bAllAccessModifiers) {
                    ReflectUtil.checkAccessible(rField);
                }
                String sFieldName = rField.getName();
                Object rFieldValue = rField.get(null);
                assert (Modifier.isFinal(nModifiers)) : "Instance not final static: " + sFieldName;
                if (rCheckNameMethod != null) {
                    String sName = rCheckNameMethod.invoke(rFieldValue, new Object[0]).toString();
                    if (bAllowNamespace) {
                        sName = sName.substring(sName.lastIndexOf(46) + 1);
                    }
                    assert (sFieldName.equals(sName)) : "Name mismatch of " + rDeclaringClass.getSimpleName() + " constant " + sFieldName + " (wrong name: " + sName + ")";
                }
                if (rFieldValue != null) {
                    aConstants.add(rFieldValue);
                    continue;
                }
                throw new AssertionError((Object)("Field is NULL: " + rField));
            }
        }
        catch (Exception e) {
            String sMessage = String.format("Could not collect %s constants from %s", rConstantClass.getSimpleName(), rDeclaringClass.getSimpleName());
            throw new IllegalArgumentException(sMessage, e);
        }
        return aConstants;
    }

    public static Method findAnyPublicMethod(Class<?> rClass, String sMethod) {
        for (Method rMethod : rClass.getMethods()) {
            if (!rMethod.getName().equals(sMethod)) continue;
            return rMethod;
        }
        return null;
    }

    public static Method findMethod(Collection<Method> rMethods, Class<?> ... rArgTypes) {
        if (rArgTypes == null) {
            rArgTypes = NO_ARGS;
        }
        for (Method m : rMethods) {
            Class<?>[] rParamTypes = m.getParameterTypes();
            if (rParamTypes.length != rArgTypes.length) continue;
            boolean bMatch = true;
            for (int i = 0; bMatch && i < rParamTypes.length; ++i) {
                bMatch = rArgTypes[i] == null || rParamTypes[i].isAssignableFrom(rArgTypes[i]);
            }
            if (!bMatch) continue;
            return m;
        }
        return null;
    }

    public static Method findMethod(Method[] rMethods, Class<?> ... rArgTypes) {
        return ReflectUtil.findMethod(Arrays.asList(rMethods), rArgTypes);
    }

    public static Method findMethod(Class<?> rClass, String sMethod, Class<?> ... rArgTypes) {
        return ReflectUtil.findMethod(ReflectUtil.getAllMethods(rClass, sMethod), rArgTypes);
    }

    public static Method findPublicMethod(Class<?> rClass, String sMethod, Class<?> ... rArgTypes) {
        return ReflectUtil.findMethod(ReflectUtil.getPublicMethods(rClass, sMethod), rArgTypes);
    }

    public static void forceInit(Class<?> rClass) {
        try {
            Class.forName(rClass.getName(), true, rClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static List<Field> getAllFields(Class<?> rClass) {
        ArrayList<Field> aFields = new ArrayList<Field>();
        while (rClass != null) {
            aFields.addAll(Arrays.asList(rClass.getDeclaredFields()));
            rClass = rClass.getSuperclass();
        }
        return aFields;
    }

    public static List<Method> getAllMethods(Class<?> rClass, String sMethodName) {
        ArrayList<Method> aMethodList = new ArrayList<Method>();
        while (rClass != null) {
            for (Method rMethod : rClass.getDeclaredMethods()) {
                if (!rMethod.getName().equals(sMethodName)) continue;
                aMethodList.add(rMethod);
            }
            rClass = rClass.getSuperclass();
        }
        return aMethodList;
    }

    public static Class<?>[] getArgumentTypes(Object[] rArgs) {
        return ReflectUtil.getArgumentTypes(rArgs, false);
    }

    public static Class<?>[] getArgumentTypes(Object[] rArgs, boolean bUsePrimitives) {
        if (rArgs == null || rArgs.length == 0) {
            return NO_ARGS;
        }
        Class[] argTypes = new Class[rArgs.length];
        for (int i = 0; i < rArgs.length; ++i) {
            if (rArgs[i] != null) {
                Class<?> rArgType = rArgs[i].getClass();
                if (bUsePrimitives) {
                    Class<?> rPrimitive = ReflectUtil.getPrimitiveType(rArgType);
                    argTypes[i] = rPrimitive != null ? rPrimitive : rArgType;
                    continue;
                }
                argTypes[i] = rArgType;
                continue;
            }
            argTypes[i] = null;
        }
        return argTypes;
    }

    public static Class<?> getCallerClass(boolean bDifferentClass) {
        try {
            return Class.forName(ReflectUtil.getCallerClassName(bDifferentClass));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getCallerClassName(boolean bDifferentClass) {
        StackTraceElement[] aStack = Thread.currentThread().getStackTrace();
        String sCaller = null;
        for (StackTraceElement rElement : aStack) {
            String sElementClass = rElement.getClassName();
            if (sElementClass.equals(THIS_CLASS_NAME) || sElementClass.indexOf(THREAD_CLASS_NAME) == 0) continue;
            if (sCaller == null) {
                sCaller = sElementClass;
                continue;
            }
            if (bDifferentClass && sCaller.equals(sElementClass)) continue;
            sCaller = sElementClass;
            break;
        }
        return sCaller;
    }

    public static Class<?> getClass(String sClassName) {
        Class<?> rClass;
        try {
            rClass = Class.forName(sClassName);
        }
        catch (ClassNotFoundException e) {
            rClass = null;
        }
        return rClass;
    }

    public static Field getField(Class<?> rClass, String sFieldName) {
        while (rClass != null) {
            for (Field rField : rClass.getDeclaredFields()) {
                if (!rField.getName().equals(sFieldName)) continue;
                return rField;
            }
            rClass = rClass.getSuperclass();
        }
        return null;
    }

    public static Object getFieldValue(String sFieldName, Object rObject) {
        return ReflectUtil.getFieldValue(ReflectUtil.getField(rObject.getClass(), sFieldName), rObject);
    }

    public static Object getFieldValue(Field rField, Object rObject) {
        if (rField != null) {
            try {
                return ReflectUtil.checkAccessible(rField).get(rObject);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Field access failed: " + rObject.getClass() + "." + rField, e);
            }
        }
        throw new IllegalArgumentException("Invalid field: " + rField);
    }

    public static <T> Class<? extends T> getImplementationClass(Class<T> rClass) {
        if (rClass.isInterface() || Modifier.isAbstract(rClass.getModifiers())) {
            return aInterfaceImplementationMap.get(rClass);
        }
        return rClass;
    }

    public static String getNamespace(String sTypeName) {
        int nPos = sTypeName.lastIndexOf(36);
        String sNamespace = null;
        if (nPos > 0) {
            sNamespace = sTypeName.substring(0, nPos);
        } else {
            nPos = sTypeName.lastIndexOf(46);
            if (nPos > 0) {
                sNamespace = sTypeName.substring(0, nPos);
            }
        }
        return sNamespace;
    }

    public static Class<?> getPrimitiveType(Class<?> rWrapperClass) {
        return aWrapperPrimitiveMap.get(rWrapperClass);
    }

    public static <T> Constructor<T> getPublicConstructor(Class<T> rClass, Class<?> ... rArgTypes) {
        try {
            return rClass.getConstructor(rArgTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No constructor " + rClass.getSimpleName() + "(" + Arrays.asList(rArgTypes) + ")", e);
        }
    }

    public static Method getPublicMethod(Class<?> rClass, String sMethod, Object[] rArgs, Class<?>[] rArgTypes) {
        if (rArgTypes == null) {
            rArgTypes = ReflectUtil.getArgumentTypes(rArgs);
        }
        try {
            return rClass.getMethod(sMethod, rArgTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method not found: " + sMethod + "(" + Arrays.asList(rArgTypes) + ")", e);
        }
    }

    public static List<Method> getPublicMethods(Class<?> rClass, String sMethodName) {
        ArrayList<Method> aMethodList = new ArrayList<Method>();
        for (Method m : rClass.getMethods()) {
            if (!m.getName().equals(sMethodName)) continue;
            aMethodList.add(m);
        }
        return aMethodList;
    }

    public static Class<?> getRawType(Type rType) {
        Class<?> rRawType;
        if (rType instanceof Class) {
            rRawType = (Class<?>)rType;
        } else if (rType instanceof ParameterizedType) {
            rRawType = (Class)((ParameterizedType)rType).getRawType();
        } else if (rType instanceof WildcardType) {
            rRawType = ReflectUtil.getRawType(((WildcardType)rType).getUpperBounds()[0]);
        } else if (rType instanceof GenericArrayType) {
            Type rComponentType = ((GenericArrayType)rType).getGenericComponentType();
            rRawType = Array.newInstance(ReflectUtil.getRawType(rComponentType), 0).getClass();
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type: %s", rType));
        }
        return rRawType;
    }

    public static Class<?> getWrapperType(Class<?> rPrimitiveClass) {
        return aWrapperPrimitiveMap.getKey(rPrimitiveClass);
    }

    public static Object invoke(Object rTarget, Method rMethod, Object ... rArgs) {
        try {
            return ReflectUtil.checkAccessible(rMethod).invoke(rTarget, rArgs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Method invocation failed: " + rMethod.getName(), e);
        }
    }

    public static Object invokeAny(Object rTarget, String sMethod) {
        return ReflectUtil.invokeAny(rTarget, sMethod, null, NO_ARGS);
    }

    public static Object invokeAny(Object rTarget, String sMethod, Object[] rArgs, Class<?>[] rArgTypes) {
        Method rMethod;
        if (rArgTypes == null) {
            rArgTypes = ReflectUtil.getArgumentTypes(rArgs);
        }
        if ((rMethod = ReflectUtil.findMethod(rTarget.getClass(), sMethod, rArgTypes)) == null) {
            throw new IllegalArgumentException("Method not found: " + sMethod);
        }
        return ReflectUtil.invoke(rTarget, rMethod, rArgs);
    }

    public static Object invokeDeclared(Object rTarget, String sMethod, Object[] rArgs, Class<?>[] rArgTypes) {
        Method rMethod;
        if (rArgTypes == null) {
            rArgTypes = ReflectUtil.getArgumentTypes(rArgs);
        }
        try {
            rMethod = rTarget.getClass().getDeclaredMethod(sMethod, rArgTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Method not found: " + sMethod, e);
        }
        return ReflectUtil.invoke(rTarget, rMethod, rArgs);
    }

    public static Object invokePublic(Object rTarget, String sMethod) {
        return ReflectUtil.invokePublic(rTarget, sMethod, null, NO_ARGS);
    }

    public static Object invokePublic(Object rTarget, String sMethod, Object[] rArgs, Class<?>[] rArgTypes) {
        Method m = ReflectUtil.getPublicMethod(rTarget.getClass(), sMethod, rArgs, rArgTypes);
        return ReflectUtil.invoke(rTarget, m, rArgs);
    }

    public static Object invokeStatic(Class<?> rClass, String sMethod) {
        return ReflectUtil.invokeStatic(rClass, sMethod, null, NO_ARGS);
    }

    public static Object invokeStatic(Class<?> rClass, String sMethod, Object[] rArgs, Class<?>[] rArgTypes) {
        Method m = ReflectUtil.getPublicMethod(rClass, sMethod, rArgs, rArgTypes);
        return ReflectUtil.invoke(null, m, rArgs);
    }

    public static <T> T newInstance(Class<T> rClass) {
        try {
            return rClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create instance of " + rClass, e);
        }
    }

    public static <T> T newInstance(Constructor<T> rConstructor, Object[] rArgs) {
        try {
            return rConstructor.newInstance(rArgs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Constructor invocation failed", e);
        }
    }

    public static <T> T newInstance(Class<T> rClass, Object[] rArgs, Class<?>[] rArgTypes) {
        if (rArgTypes == null) {
            rArgTypes = ReflectUtil.getArgumentTypes(rArgs);
        }
        try {
            Constructor<T> c = rClass.getConstructor(rArgTypes);
            return c.newInstance(rArgs);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No matching constructor: " + rClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Method invocation failed", e);
        }
    }

    public static <I> void registerImplementation(Class<I> rInterface, Class<? extends I> rImplementation) {
        aInterfaceImplementationMap.put(rInterface, rImplementation);
    }

    static {
        aWrapperPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        aWrapperPrimitiveMap.put(Character.class, Character.TYPE);
        aWrapperPrimitiveMap.put(Byte.class, Byte.TYPE);
        aWrapperPrimitiveMap.put(Short.class, Short.TYPE);
        aWrapperPrimitiveMap.put(Integer.class, Integer.TYPE);
        aWrapperPrimitiveMap.put(Long.class, Long.TYPE);
        aWrapperPrimitiveMap.put(Float.class, Float.TYPE);
        aWrapperPrimitiveMap.put(Double.class, Double.TYPE);
        ReflectUtil.registerImplementation(List.class, ArrayList.class);
        ReflectUtil.registerImplementation(Set.class, HashSet.class);
        ReflectUtil.registerImplementation(Map.class, HashMap.class);
    }
}

