/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;

public class DirectRelation<T>
extends Relation<T> {
    private static final long serialVersionUID = 1L;
    private T rTarget;

    public DirectRelation(RelationType<T> rType, T rTarget) {
        super(rType);
        this.rTarget = rTarget;
    }

    @Override
    public T getTarget() {
        return this.rTarget;
    }

    @Override
    Relation<T> copyTo(Relatable rTarget) {
        return rTarget.set(this.getType(), this.getTarget());
    }

    @Override
    boolean dataEqual(Relation<?> rOther) {
        DirectRelation rOtherRelation = (DirectRelation)rOther;
        if (this.rTarget == null) {
            return rOtherRelation.rTarget == null;
        }
        return this.rTarget.equals(rOtherRelation.rTarget);
    }

    @Override
    int dataHashCode() {
        return 17 + (this.rTarget != null ? this.rTarget.hashCode() : 0);
    }

    @Override
    void setTarget(T rNewTarget) {
        this.rTarget = rNewTarget;
    }

    private void readObject(ObjectInputStream rIn) throws IOException, ClassNotFoundException {
        rIn.defaultReadObject();
        if (!this.getType().isValidTarget(this.rTarget)) {
            throw new InvalidObjectException("Target value invalid for type: " + this.rTarget + "/" + this.getType());
        }
    }
}

