/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.Predicates;
import de.esoco.lib.json.JsonBuilder;
import de.esoco.lib.json.JsonParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypes;
import org.obrel.space.ObjectSpace;
import org.obrel.space.ObjectSpaceResolver;
import org.obrel.type.MetaTypes;
import org.obrel.type.StandardTypes;

public class ObjectRelations {
    private static final RelatedObject EMPTY_RELATION_CONTAINER = new RelatedObject();
    private static final Map<Object, RelatedObject> aRelationContainerMap = new WeakHashMap<Object, RelatedObject>();

    private ObjectRelations() {
    }

    public static void copyRelations(Relatable rSource, Relatable rTarget, boolean bReplace) {
        ObjectRelations.copyRelations(rSource, rTarget, bReplace, Predicates.alwaysTrue());
    }

    public static void copyRelations(Relatable rSource, Relatable rTarget, boolean bReplace, Predicate<Relation<?>> pFilter) {
        for (Relation<?> rSourceRelation : rSource.getRelations(pFilter)) {
            rSourceRelation.copyTo(rTarget, bReplace);
        }
    }

    public static <T extends Relatable> T fromJson(T rTarget, String sJson) {
        return new JsonParser().parseRelatable(sJson, rTarget);
    }

    public static Relatable getRelatable(Object rForObject) {
        return ObjectRelations.getRelationContainer(rForObject, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RelatedObject getRelationContainer(Object rObject, boolean bCreate) {
        if (rObject instanceof RelatedObject) {
            return (RelatedObject)rObject;
        }
        Map<Object, RelatedObject> map = aRelationContainerMap;
        synchronized (map) {
            RelatedObject rContainer = aRelationContainerMap.get(rObject);
            if (rContainer == null) {
                if (bCreate) {
                    rContainer = new RelatedObject();
                    aRelationContainerMap.put(rObject, rContainer);
                } else {
                    rContainer = EMPTY_RELATION_CONTAINER;
                }
            }
            return rContainer;
        }
    }

    public static void init() {
        ObjectRelations.registerRelationTypes(RelationTypes.class, MetaTypes.class, StandardTypes.class);
    }

    public static void registerRelationTypes(Class<?> ... rClasses) {
        assert (rClasses.length > 0) : "No classes to register";
        for (Class<?> rClass : rClasses) {
            try {
                Class.forName(rClass.getName());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static void removeRelatable(Object rForObject) {
        aRelationContainerMap.remove(rForObject);
    }

    public static void require(Relatable rRelatable, RelationType<?> ... rTypes) {
        ObjectRelations.require(rRelatable, Predicates.alwaysTrue(), rTypes);
    }

    public static void require(Relatable rRelatable, Predicate<Relation<?>> pRequirement, RelationType<?> ... rTypes) {
        LinkedHashSet aMissingTypes = new LinkedHashSet();
        for (RelationType<?> rType : rTypes) {
            Relation<?> rRelation = rRelatable.getRelation(rType);
            if (rRelation != null && pRequirement.test(rRelation)) continue;
            aMissingTypes.add(rType);
        }
        if (!aMissingTypes.isEmpty()) {
            throw new IllegalArgumentException("Relations missing: " + aMissingTypes);
        }
    }

    public static void requireNonNull(Relatable rRelatable, RelationType<?> ... rTypes) {
        ObjectRelations.require(rRelatable, r -> r.getTarget() != null, rTypes);
    }

    public static <T> void setAll(RelationType<T> rType, T rTarget, Relatable ... rObjects) {
        for (Relatable rObject : rObjects) {
            rObject.set(rType, rTarget);
        }
    }

    public static void setFlags(RelationType<Boolean> rFlagType, Relatable ... rObjects) {
        ObjectRelations.setAll(rFlagType, Boolean.TRUE, rObjects);
    }

    public static void shutdown() {
        aRelationContainerMap.clear();
    }

    public static void swapRelations(RelatedObject rFirst, RelatedObject rSecond) {
        Map<RelationType<?>, Relation<?>> rSecondRelations = rSecond.aRelations;
        rSecond.aRelations = rFirst.aRelations;
        rFirst.aRelations = rSecondRelations;
    }

    public static void syncRelations(RelatedObject rTarget, RelatedObject rSource) {
        rTarget.aRelations = rSource.aRelations;
    }

    public static String toJson(Relatable rObject, RelationType<?> ... rRelationTypes) {
        List<RelationType<?>> rTypes = rRelationTypes.length > 0 ? Arrays.asList(rRelationTypes) : null;
        return ObjectRelations.toJson(rObject, rTypes);
    }

    public static String toJson(Relatable rObject, Collection<RelationType<?>> rRelationTypes) {
        return new JsonBuilder().appendRelatable(rObject, rRelationTypes, true).toString();
    }

    public static void urlDelete(Relatable rRoot, String sUrl) {
        ObjectRelations.urlResolve(rRoot, sUrl, true, ObjectSpaceResolver.URL_DELETE);
    }

    public static Object urlGet(Relatable rRoot, String sUrl) {
        return ObjectRelations.urlResolve(rRoot, sUrl, true, ObjectSpaceResolver.URL_GET);
    }

    private static void urlLookupError(String sUrl, String sElement) {
        String sMessage = String.format("Could not resolve element '%s' in URL '%s'", sElement, sUrl);
        throw new NoSuchElementException(sMessage);
    }

    public static void urlPut(Relatable rRoot, String sUrl, Object rValue) {
        ObjectRelations.urlResolve(rRoot, sUrl, true, new ObjectSpaceResolver.PutResolver<Object>(rValue));
    }

    public static Object urlResolve(Relatable rRoot, String sUrl, boolean bForwardToObjectSpace, ObjectSpaceResolver fTargetHandler) {
        String[] rElements = sUrl.split("/");
        Relatable rNextElement = rRoot;
        Relatable rCurrentElement = rRoot;
        RelationType<Object> rType = null;
        int nChildUrlIndex = 0;
        for (String sElement : rElements) {
            if (!sElement.isEmpty()) {
                sElement = sElement.replaceAll("-", "_");
                if (bForwardToObjectSpace && rNextElement instanceof ObjectSpace) {
                    return fTargetHandler.resolve((ObjectSpace)rNextElement, sUrl.substring(nChildUrlIndex));
                }
                if (rNextElement instanceof Relatable) {
                    rCurrentElement = rNextElement;
                } else {
                    ObjectRelations.urlLookupError(sUrl, sElement);
                }
                int nPackageEnd = sElement.lastIndexOf(46) + 1;
                sElement = nPackageEnd > 0 ? sElement.substring(0, nPackageEnd) + sElement.substring(nPackageEnd).toUpperCase() : sElement.toUpperCase();
                rType = RelationType.valueOf(sElement);
                if (rType != null) {
                    rNextElement = rCurrentElement.get(rType);
                } else {
                    String sType = sElement;
                    Relation rElementRelation = rCurrentElement.streamRelations().filter(r -> r.getType().getName().endsWith(sType)).findFirst().orElse(null);
                    if (rElementRelation != null) {
                        rNextElement = rElementRelation.getTarget();
                        rType = rElementRelation.getType();
                    } else {
                        ObjectRelations.urlLookupError(sUrl, sElement);
                    }
                }
            }
            nChildUrlIndex += sElement.length() + 1;
            bForwardToObjectSpace = true;
        }
        if (rType == null) {
            throw new IllegalArgumentException("Could not resolve URL " + sUrl);
        }
        return fTargetHandler.evaluate(rCurrentElement, rType);
    }
}

