/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.monad.Option;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.obrel.core.Relation;
import org.obrel.core.RelationData;
import org.obrel.core.RelationType;
import org.obrel.core.TransformedRelation;

public interface Relatable {
    public void deleteRelation(Relation<?> var1);

    default public void deleteRelation(RelationType<?> rType) {
        Relation<?> rRelation = this.getRelation(rType);
        if (rRelation != null) {
            this.deleteRelation(rRelation);
        }
    }

    default public void deleteRelations(Predicate<? super Relation<?>> rFilter) {
        for (Relation<?> rRelation : this.getRelations(rFilter)) {
            this.deleteRelation(rRelation);
        }
    }

    public <T> T get(RelationType<T> var1);

    default public List<Object> getAll(Predicate<? super Relation<?>> rFilter) {
        List<Relation<?>> rRelations = this.getRelations(rFilter);
        ArrayList<Object> aResult = new ArrayList<Object>(rRelations.size());
        for (Relation<?> rRelation : rRelations) {
            aResult.add(rRelation.getTarget());
        }
        return aResult;
    }

    default public <T> Option<T> getOption(RelationType<T> rType) {
        return this.hasRelation(rType) ? Option.of(this.get(rType)) : Option.none();
    }

    public <T> Relation<T> getRelation(RelationType<T> var1);

    default public int getRelationCount(Predicate<? super Relation<?>> rFilter) {
        return this.getRelations(rFilter).size();
    }

    public List<Relation<?>> getRelations(Predicate<? super Relation<?>> var1);

    default public List<Relation<?>> getRelations() {
        return this.getRelations(null);
    }

    default public boolean hasFlag(RelationType<Boolean> rType) {
        Relation<Boolean> rRelation = this.getRelation(rType);
        return rRelation != null && rRelation.getTarget() == Boolean.TRUE;
    }

    default public boolean hasRelation(RelationType<?> rType) {
        return this.getRelation(rType) != null;
    }

    default public boolean hasRelations(Predicate<? super Relation<?>> rFilter) {
        return this.getRelations(rFilter).size() > 0;
    }

    default public <T> Relation<T> init(RelationType<T> rType) {
        Relation<Object> rRelation = this.get(rType) == null ? this.set(rType, null) : this.getRelation(rType);
        return rRelation;
    }

    public <T> Relation<T> set(RelationType<T> var1, T var2);

    public <T, I> Relation<T> set(RelationType<T> var1, Function<I, T> var2, I var3);

    default public Relation<Boolean> set(RelationType<Boolean> rFlagType) {
        return this.set(rFlagType, Boolean.TRUE);
    }

    default public void set(RelationData<?> ... rRelations) {
        for (RelationData<?> rData : rRelations) {
            rData.applyTo(this);
        }
    }

    default public Relation<Integer> set(RelationType<Integer> rIntType, int nValue) {
        return this.set((RelationType)rIntType, (Object)nValue);
    }

    default public <T> Relation<Option<T>> setOption(RelationType<Option<T>> rType, T rValue) {
        return this.set(rType, Option.of(rValue));
    }

    default public Stream<Relation<?>> streamRelations() {
        return this.getRelations(null).stream();
    }

    public <T, D> TransformedRelation<T, D> transform(RelationType<T> var1, InvertibleFunction<T, D> var2);
}

