/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.event.ElementEvent;
import de.esoco.lib.event.EventDispatcher;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obrel.core.DirectRelation;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypes;
import org.obrel.core.RelationWrapper;
import org.obrel.core.TransformedRelation;
import org.obrel.type.ListenerTypes;

public class RelatedObject
implements Relatable {
    private static final Map<RelationType<?>, Relation<?>> NO_RELATIONS = Collections.emptyMap();
    transient Map<RelationType<?>, Relation<?>> aRelations = NO_RELATIONS;

    @Override
    public void deleteRelation(Relation<?> rRelation) {
        RelationType<?> rType = rRelation.getType();
        rType.checkUpdateAllowed();
        rType.deleteRelation(this, rRelation);
        this.notifyRelationListeners(ElementEvent.EventType.REMOVE, rRelation, null);
        this.aRelations.remove(rType);
        rRelation.removed();
    }

    @Override
    public <T> T get(RelationType<T> rType) {
        assert (rType.getName() != "!INIT") : "Uninitialized relation type";
        Relation<T> rRelation = this.getRelation(rType);
        if (rRelation == null) {
            T rInitialValue = rType.initialValue(this);
            if (rInitialValue == null) {
                return rType.defaultValue(this);
            }
            rRelation = rType.newRelation(this, rInitialValue);
            this.addRelation(rRelation, true);
        }
        return rRelation.getTarget();
    }

    @Override
    public <T> Relation<T> getRelation(RelationType<T> rType) {
        return this.aRelations.get(rType);
    }

    @Override
    public List<Relation<?>> getRelations(Predicate<? super Relation<?>> rFilter) {
        ArrayList aResult = new ArrayList();
        for (Relation<?> rRelation : this.aRelations.values()) {
            if (rRelation.getType().isPrivate() || rFilter != null && !rFilter.test(rRelation)) continue;
            aResult.add(rRelation);
        }
        return aResult;
    }

    public final boolean relationsEqual(RelatedObject rOther) {
        return this.aRelations.equals(rOther.aRelations);
    }

    public String relationsString(String sJoin, String sSeparator, int nIndent) {
        return this.relationsString(sJoin, sSeparator, nIndent, new HashSet<Object>());
    }

    @Override
    public <T> Relation<T> set(RelationType<T> rType, T rTarget) {
        Relation<T> rRelation = this.getRelation(rType);
        if (rRelation != null) {
            rType.checkUpdateAllowed();
            rType.prepareRelationUpdate(rRelation, rTarget);
            this.notifyRelationListeners(ElementEvent.EventType.UPDATE, rRelation, rTarget);
            rRelation.updateTarget(rTarget);
        } else {
            if (!rType.isInitialized()) {
                RelationTypes.init(this.getClass());
            }
            rType.checkReadonly();
            rRelation = new DirectRelation<T>(rType, rTarget);
            this.addRelation(rRelation, true);
        }
        return rRelation;
    }

    @Override
    public final <T, I> Relation<T> set(RelationType<T> rType, Function<I, T> fTargetResolver, I rIntermediateTarget) {
        Relation<T> rRelation = this.getRelation(rType);
        if (rRelation != null) {
            throw new IllegalStateException("Relation already exists: " + rRelation);
        }
        rRelation = rType.newIntermediateRelation(this, fTargetResolver, rIntermediateTarget);
        this.addRelation(rRelation, true);
        return rRelation;
    }

    public String toString() {
        StringBuilder aStringBuilder = new StringBuilder(this.getClass().getSimpleName());
        aStringBuilder.append('[');
        aStringBuilder.append(this.relationsString("=", ",", -1));
        aStringBuilder.append(']');
        return aStringBuilder.toString();
    }

    @Override
    public <T, D> TransformedRelation<T, D> transform(RelationType<T> rType, InvertibleFunction<T, D> fTransformation) {
        T rTarget;
        Relation<T> rRelation = this.getRelation(rType);
        TransformedRelation<T, D> rTransformedRelation = rType.newTransformedRelation(this, fTransformation);
        if (rRelation instanceof RelationWrapper) {
            throw new IllegalStateException("Cannot transform alias relation " + rType);
        }
        if (rRelation != null) {
            rTarget = rRelation.getTarget();
            rTransformedRelation.transferRelationsFrom(rRelation, false);
        } else {
            rTarget = rType.initialValue(this);
        }
        rTransformedRelation.setTarget(rTarget);
        this.addRelation(rTransformedRelation, rRelation == null);
        return rTransformedRelation;
    }

    protected <T> void notifyRelationListeners(ElementEvent.EventType rEventType, Relation<T> rRelation, T rUpdateValue) {
        RelationType<EventDispatcher<RelationEvent<?>>> rType = rRelation.getType();
        if (!rType.isPrivate()) {
            if (this.hasRelation(ListenerTypes.RELATION_LISTENERS)) {
                this.get(ListenerTypes.RELATION_LISTENERS).dispatch(new RelationEvent<T>(rEventType, this, rRelation, rUpdateValue, this));
            }
            if (rRelation.hasRelation(ListenerTypes.RELATION_UPDATE_LISTENERS)) {
                rRelation.get(ListenerTypes.RELATION_UPDATE_LISTENERS).dispatch(new RelationEvent<T>(rEventType, this, rRelation, rUpdateValue, rRelation));
            }
            if (rType.hasRelation(ListenerTypes.RELATION_TYPE_LISTENERS)) {
                rType.get(ListenerTypes.RELATION_TYPE_LISTENERS).dispatch(new RelationEvent<T>(rEventType, this, rRelation, rUpdateValue, rType));
            }
        }
    }

    protected final void readRelations(ObjectInputStream rIn) throws IOException, ClassNotFoundException {
        int nCount = rIn.readInt();
        while (nCount-- > 0) {
            this.addRelation((Relation)rIn.readObject(), false);
        }
    }

    protected final int relationsHashCode() {
        return this.aRelations.hashCode();
    }

    protected final void writeRelations(ObjectOutputStream rOut) throws IOException {
        int nCount = 0;
        for (Relation<?> rRelation : this.aRelations.values()) {
            if (rRelation.getType().isTransient()) continue;
            ++nCount;
        }
        rOut.writeInt(nCount);
        for (Relation<?> rRelation : this.aRelations.values()) {
            if (rRelation.getType().isTransient()) continue;
            rOut.writeObject(rRelation);
        }
    }

    <T> void addRelation(Relation<T> rRelation, boolean bNotify) {
        RelationType<T> rType = rRelation.getType();
        rRelation = rType.addRelation(this, rRelation);
        if (bNotify) {
            this.notifyRelationListeners(ElementEvent.EventType.ADD, rRelation, null);
        }
        if (this.aRelations == NO_RELATIONS) {
            this.aRelations = new LinkedHashMap();
        }
        this.aRelations.put(rType, rRelation);
    }

    String relationsString(String sJoin, String sSeparator, int nIndent, Set<Object> rExcludedObjects) {
        StringBuilder aStringBuilder = new StringBuilder();
        for (Relation<?> rRelation : this.aRelations.values()) {
            RelationType<?> rType = rRelation.getType();
            Object rTarget = rRelation.getTarget();
            rExcludedObjects.add(this);
            if (rType.isPrivate()) continue;
            if (rTarget == this) {
                rTarget = "<this>";
            } else if (rExcludedObjects.contains(rTarget)) {
                rTarget = rTarget.getClass().getSimpleName();
            } else if (rTarget instanceof RelatedObject) {
                int nLevel = nIndent >= 0 ? nIndent + 1 : -1;
                String sTargetRelations = ((RelatedObject)rTarget).relationsString(sJoin, sSeparator, nLevel, rExcludedObjects);
                rTarget = nLevel >= 0 ? rTarget.getClass().getSimpleName() + "\n" + sTargetRelations : rTarget.getClass().getSimpleName() + "[" + sTargetRelations + "]";
            }
            for (int i = 0; i < nIndent; ++i) {
                aStringBuilder.append("  ");
            }
            aStringBuilder.append(rType);
            aStringBuilder.append(sJoin);
            aStringBuilder.append(rTarget);
            aStringBuilder.append(sSeparator);
        }
        if (this.aRelations.size() > 0) {
            aStringBuilder.setLength(aStringBuilder.length() - sSeparator.length());
        }
        return aStringBuilder.toString();
    }

    void transferRelationsFrom(RelatedObject rSource, boolean bNotify) {
        for (Relation<?> rRelation : rSource.aRelations.values()) {
            this.addRelation(rRelation, bNotify);
        }
    }
}

