/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.event.ElementEvent;
import de.esoco.lib.event.EventHandler;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.property.Immutability;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.RelationAlias;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationType;
import org.obrel.core.RelationView;
import org.obrel.core.RelationWrapper;
import org.obrel.core.SerializableRelatedObject;
import org.obrel.type.ListenerTypes;
import org.obrel.type.MetaTypes;

public abstract class Relation<T>
extends SerializableRelatedObject {
    private static final long serialVersionUID = 1L;
    private final RelationType<T> rType;

    public Relation(RelationType<T> rType) {
        this.rType = rType;
    }

    public void addUpdateListener(EventHandler<RelationEvent<T>> rListener) {
        this.get(ListenerTypes.RELATION_UPDATE_LISTENERS).add(rListener);
    }

    public final Relation<T> aliasAs(RelationType<T> rAliasType, Relatable rInParent) {
        return this.aliasAs(rAliasType, rInParent, Functions.identity());
    }

    public final <A> Relation<A> aliasAs(RelationType<A> rAliasType, Relatable rInParent, InvertibleFunction<T, A> fAliasConversion) {
        return this.addAlias(new RelationAlias<A, T>(rInParent, rAliasType, this, fAliasConversion), rInParent);
    }

    public final Relation<T> annotate(RelationType<Boolean> rAnnotationType) {
        return this.annotate(rAnnotationType, Boolean.TRUE);
    }

    public final <V> Relation<T> annotate(RelationType<V> rAnnotationType, V rValue) {
        this.set(rAnnotationType, rValue);
        return this;
    }

    public final boolean equals(Object rObject) {
        if (this == rObject) {
            return true;
        }
        if (rObject == null || this.getClass() != rObject.getClass()) {
            return false;
        }
        Relation rOther = (Relation)rObject;
        return this.rType == rOther.rType && this.dataEqual(rOther) && this.relationsEqual(rOther);
    }

    public final <V> V getAnnotation(RelationType<V> rAnnotationType) {
        Object rValue = this.hasRelation(rAnnotationType) ? this.get(rAnnotationType) : (this.rType.hasRelation(rAnnotationType) ? this.rType.get(rAnnotationType) : null);
        return rValue;
    }

    public abstract T getTarget();

    public final RelationType<T> getType() {
        return this.rType;
    }

    public final boolean hasAnnotation(RelationType<?> rAnnotationType) {
        return this.hasRelation(rAnnotationType) || this.rType.hasRelation(rAnnotationType);
    }

    public final boolean hasFlagAnnotation(RelationType<Boolean> rAnnotationType) {
        Boolean rFlag = this.getAnnotation(rAnnotationType);
        return rFlag != null && rFlag != false;
    }

    public final int hashCode() {
        int nResult = this.rType.hashCode();
        nResult = 31 * nResult + this.dataHashCode();
        nResult = 31 * nResult + this.relationsHashCode();
        return nResult;
    }

    public EventHandler<RelationEvent<T>> onChange(Consumer<T> fChangeHandler) {
        EventHandler<RelationEvent<T>> aHandler = e -> {
            if (e.getType() == ElementEvent.EventType.UPDATE && !Objects.equals(e.getUpdateValue(), ((Relation)e.getElement()).getTarget())) {
                fChangeHandler.accept(e.getUpdateValue());
            }
        };
        this.addUpdateListener(aHandler);
        return aHandler;
    }

    public EventHandler<RelationEvent<T>> onUpdate(Consumer<T> fUpdateHandler) {
        EventHandler<RelationEvent<T>> aHandler = e -> {
            if (e.getType() == ElementEvent.EventType.UPDATE) {
                fUpdateHandler.accept(e.getUpdateValue());
            }
        };
        this.addUpdateListener(aHandler);
        return aHandler;
    }

    public void setImmutable() {
        Class<T> rTargetType = this.rType.getTargetType();
        T rTarget = this.getTarget();
        if (rTarget instanceof Immutability) {
            ((Immutability)rTarget).setImmutable();
        } else if (rTarget instanceof Relatable) {
            Relatable rRelatableTarget = (Relatable)rTarget;
            if (!rRelatableTarget.hasRelation(MetaTypes.IMMUTABLE)) {
                rRelatableTarget.set(MetaTypes.IMMUTABLE);
            }
        } else if (rTargetType == List.class) {
            this.setTarget(Collections.unmodifiableList((List)rTarget));
        } else if (rTargetType == Set.class) {
            this.setTarget(Collections.unmodifiableSet((Set)rTarget));
        } else if (rTargetType == Collection.class) {
            this.setTarget(Collections.unmodifiableCollection((Collection)rTarget));
        } else if (rTargetType == Map.class) {
            this.setTarget(Collections.unmodifiableMap((Map)rTarget));
        }
        if (!this.hasFlag(MetaTypes.IMMUTABLE)) {
            this.set(MetaTypes.IMMUTABLE);
        }
    }

    @Override
    public String toString() {
        return "Relation[" + this.rType + "=" + this.getTarget() + "]";
    }

    public final Relation<T> viewAs(RelationType<? super T> rViewType, Relatable rInParent) {
        return this.viewAs(rViewType, rInParent, Functions.identity());
    }

    public final <V> Relation<V> viewAs(RelationType<V> rViewType, Relatable rInParent, Function<T, V> fViewConversion) {
        return this.addAlias(new RelationView<V, T>(rInParent, rViewType, this, fViewConversion), rInParent);
    }

    protected void removed() {
    }

    final <A> Relation<A> addAlias(RelationWrapper<A, ?, ?> rAlias, Relatable rInParent) {
        ((RelatedObject)rInParent).addRelation(rAlias, true);
        return rAlias;
    }

    abstract Relation<T> copyTo(Relatable var1);

    void copyTo(Relatable rTarget, boolean bReplace) {
        Relation<T> aCopy;
        boolean bExists = rTarget.hasRelation(this.rType);
        if ((!bExists || bReplace && !this.rType.isFinal()) && (aCopy = this.copyTo(rTarget)) != null) {
            ObjectRelations.copyRelations(this, aCopy, bReplace);
        }
    }

    abstract boolean dataEqual(Relation<?> var1);

    abstract int dataHashCode();

    abstract void setTarget(T var1);

    final void updateTarget(T rNewTarget) {
        if (this.hasFlag(MetaTypes.IMMUTABLE)) {
            throw new UnsupportedOperationException("Relation is immutable: " + this.rType);
        }
        if (!this.rType.isValidTarget(rNewTarget)) {
            throw new IllegalArgumentException(String.format("Invalid target for type '%s': %s (is %s - expected %s)", this.rType, rNewTarget, rNewTarget.getClass().getName(), this.rType.getTargetType()));
        }
        this.setTarget(rNewTarget);
    }

    private void readObject(ObjectInputStream rIn) throws IOException, ClassNotFoundException {
        rIn.defaultReadObject();
        if (this.rType == null) {
            throw new InvalidObjectException("RelationType is NULL");
        }
    }
}

