/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.InvertibleFunction;
import org.obrel.core.FluentRelatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationData;
import org.obrel.core.RelationType;
import org.obrel.type.MetaTypes;

public interface RelationBuilder<R extends RelationBuilder<R>>
extends FluentRelatable<R> {
    default public <T> R annotate(RelationType<?> rType, RelationType<T> rAnnotationType, T rValue) {
        return (R)((RelationBuilder)this._with(() -> {
            Relation rRelation = this.getRelation(rType);
            if (rRelation == null) {
                throw new IllegalArgumentException("No relation with type " + rType);
            }
            rRelation.annotate(rAnnotationType, rValue);
        }));
    }

    default public void seal() {
        this.set(MetaTypes.IMMUTABLE);
    }

    default public R with(RelationData<?> ... rRelations) {
        return (R)((RelationBuilder)this._with(() -> this.set(rRelations)));
    }

    @Override
    default public <T, D> R with(RelationType<T> rType, InvertibleFunction<T, D> fTransformation) {
        return (R)((RelationBuilder)this._with(() -> this.transform(rType, fTransformation)));
    }

    default public <T, I> R with(RelationType<T> rType, Function<I, T> fTargetResolver, I rIntermediateTarget) {
        return (R)((RelationBuilder)this._with(() -> this.set(rType, fTargetResolver, rIntermediateTarget)));
    }
}

