/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.collection.CollectionUtil;
import de.esoco.lib.event.EventHandler;
import de.esoco.lib.expression.Action;
import de.esoco.lib.expression.ElementAccessFunction;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.InvertibleFunction;
import de.esoco.lib.expression.Predicate;
import de.esoco.lib.expression.Predicates;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.obrel.core.DirectRelation;
import org.obrel.core.IntermediateRelation;
import org.obrel.core.Relatable;
import org.obrel.core.RelatedObject;
import org.obrel.core.Relation;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationTypeModifier;
import org.obrel.core.TransformedRelation;
import org.obrel.type.ListenerTypes;

public class RelationType<T>
extends RelatedObject
implements ElementAccessFunction<RelationType<T>, Relatable, T>,
Serializable {
    public static final String DEFAULT_NAMESPACE = "";
    public static final Pattern NAME_PATTERN = Pattern.compile("([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*");
    static final String INIT_TYPE = "!INIT";
    private static final long serialVersionUID = 1L;
    private static final Map<String, RelationType<?>> aTypeRegistry = new HashMap();
    private final transient Set<RelationTypeModifier> aModifiers;
    private String sName = "!INIT";
    private transient Class<? super T> rTargetType;
    private transient Function<? super Relatable, ? super T> fDefaultValue = null;
    private transient Function<? super Relatable, ? super T> fInitialValue = null;

    public RelationType(String sName, Class<? super T> rTargetType, RelationTypeModifier ... rModifiers) {
        this(sName, rTargetType, (Function<Relatable, ? super T>)null, rModifiers);
    }

    public RelationType(String sName, Class<? super T> rTargetType, Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        this(sName, rTargetType, null, fInitialValue, rModifiers);
    }

    public RelationType(String sName, Class<? super T> rTargetType, Function<? super Relatable, ? super T> fDefaultValue, Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        this.init(sName != null ? sName : INIT_TYPE, rTargetType, null);
        this.fDefaultValue = fDefaultValue;
        this.fInitialValue = fInitialValue;
        this.aModifiers = rModifiers.length > 0 ? EnumSet.copyOf(Arrays.asList(rModifiers)) : EnumSet.noneOf(RelationTypeModifier.class);
    }

    protected RelationType(RelationTypeModifier ... rModifiers) {
        this.aModifiers = rModifiers.length > 0 ? EnumSet.copyOf(Arrays.asList(rModifiers)) : EnumSet.noneOf(RelationTypeModifier.class);
    }

    protected RelationType(Function<? super Relatable, ? super T> fDefaultValue, Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        this(rModifiers);
        this.fDefaultValue = fDefaultValue;
        this.fInitialValue = fInitialValue;
    }

    static void clearTypeRegistry() {
        aTypeRegistry.clear();
    }

    public static Collection<RelationType<?>> getRegisteredRelationTypes() {
        return Collections.unmodifiableCollection(aTypeRegistry.values());
    }

    public static Collection<RelationType<?>> getRelationTypes(Predicate<? super RelationType<?>> pCriteria) {
        return CollectionUtil.collect(aTypeRegistry.values(), pCriteria);
    }

    public static void unregisterRelationType(RelationType<?> rType) {
        aTypeRegistry.remove(rType.getName());
    }

    public static RelationType<?> valueOf(String sName) {
        RelationType<?> rRelationType = aTypeRegistry.get(sName);
        if (rRelationType == null) {
            try {
                Class.forName(sName.substring(0, sName.lastIndexOf(46)));
                rRelationType = aTypeRegistry.get(sName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return rRelationType;
    }

    public void addTypeListener(EventHandler<RelationEvent<T>> rListener) {
        this.get(ListenerTypes.RELATION_TYPE_LISTENERS).add(rListener);
    }

    @SafeVarargs
    public final RelationType<T> annotate(RelationType<Boolean> ... rAdditionalFlags) {
        for (RelationType<Boolean> rFlag : rAdditionalFlags) {
            this.annotate(rFlag, Boolean.TRUE);
        }
        return this;
    }

    public final <V> RelationType<T> annotate(RelationType<V> rAnnotationType, V rValue) {
        this.set(rAnnotationType, rValue);
        return this;
    }

    public T defaultValue(Relatable rParent) {
        return this.fDefaultValue != null ? (T)this.fDefaultValue.apply(rParent) : null;
    }

    @Override
    public T evaluate(Relatable rObject) {
        return rObject != null ? (T)rObject.get(this) : null;
    }

    @Override
    public <I> Function<I, T> from(Function<I, ? extends Relatable> rOther) {
        return Functions.chain(this, rOther);
    }

    public final Function<? super Relatable, ? super T> getDefaultValueFunction() {
        return this.fDefaultValue;
    }

    @Override
    public RelationType<T> getElementDescriptor() {
        return this;
    }

    public final Function<? super Relatable, ? super T> getInitialValueFunction() {
        return this.fInitialValue;
    }

    public final String getName() {
        return this.sName;
    }

    public final String getNamespace() {
        int nPos = this.sName.lastIndexOf(46);
        if (nPos > 0) {
            return this.sName.substring(0, nPos);
        }
        return DEFAULT_NAMESPACE;
    }

    public final String getSimpleName() {
        return this.sName.substring(this.sName.lastIndexOf(46) + 1);
    }

    public final Class<? super T> getTargetType() {
        return this.rTargetType;
    }

    @Override
    public String getToken() {
        return this.getName();
    }

    public final boolean hasModifier(RelationTypeModifier rModifier) {
        return this.aModifiers.contains((Object)rModifier);
    }

    public T initialValue(Relatable rParent) {
        return this.fInitialValue != null ? (T)this.fInitialValue.apply(rParent) : null;
    }

    @Override
    public <O extends Relatable> Predicate<O> is(Predicate<? super T> pComparison) {
        return Predicates.ifRelation(this, pComparison);
    }

    public final boolean isFinal() {
        return this.hasModifier(RelationTypeModifier.FINAL);
    }

    public final boolean isInitialized() {
        return this.sName != INIT_TYPE;
    }

    public final boolean isPrivate() {
        return this.hasModifier(RelationTypeModifier.PRIVATE);
    }

    public final boolean isReadonly() {
        return this.hasModifier(RelationTypeModifier.READONLY);
    }

    public final boolean isTransient() {
        return this.hasModifier(RelationTypeModifier.TRANSIENT);
    }

    public boolean isValidTarget(Object rTarget) {
        return rTarget == null || this.rTargetType.isAssignableFrom(rTarget.getClass());
    }

    @Override
    public <O> Function<Relatable, O> then(Function<? super T, O> fFollowUp) {
        return Functions.chain(fFollowUp, this);
    }

    @Override
    public final String toString() {
        return this.sName;
    }

    protected Relation<T> addRelation(Relatable rParent, Relation<T> rRelation) {
        return rRelation;
    }

    protected void deleteRelation(Relatable rParent, Relation<?> rRelation) {
        assert (rRelation.getType() == this);
    }

    protected <I> Relation<T> newIntermediateRelation(RelatedObject rParent, Function<I, T> fTargetResolver, I rIntermediateTarget) {
        return new IntermediateRelation<T, I>(this, fTargetResolver, rIntermediateTarget);
    }

    protected Relation<T> newRelation(RelatedObject rParent, T rTarget) {
        return new DirectRelation<T>(this, rTarget);
    }

    protected <D> TransformedRelation<T, D> newTransformedRelation(RelatedObject rParent, InvertibleFunction<T, D> fTransformation) {
        return new TransformedRelation<T, D>(this, fTransformation);
    }

    protected void prepareRelationUpdate(Relation<T> rRelation, T rNewTarget) {
        assert (rRelation.getType() == this);
    }

    protected final Object readResolve() throws ObjectStreamException {
        RelationType<?> rType = aTypeRegistry.get(this.sName);
        if (rType == null) {
            throw new InvalidObjectException("Undefined relation type: " + this.sName);
        }
        return rType;
    }

    protected void setRelationTarget(Relation<T> rRelation, T rValue) {
        if (rRelation.getType() != this) {
            throw new IllegalArgumentException("Relation must be for type " + this);
        }
        rRelation.setTarget(rValue);
    }

    void checkReadonly() {
        assert (this.isInitialized()) : "Uninitialized relation type";
        if (this.isReadonly()) {
            throw new UnsupportedOperationException("Relation is readonly: " + this);
        }
    }

    void checkUpdateAllowed() {
        this.checkReadonly();
        if (this.isFinal()) {
            throw new UnsupportedOperationException("Relation is final: " + this);
        }
    }

    final void init(String sName, Class<? super T> rTargetType, Action<RelationType<?>> fInitAction) {
        this.sName = sName;
        this.rTargetType = rTargetType;
        if (sName != INIT_TYPE) {
            if (!NAME_PATTERN.matcher(sName).matches()) {
                throw new IllegalArgumentException("Invalid relation type name: " + sName);
            }
            if (aTypeRegistry.containsKey(sName)) {
                throw new IllegalArgumentException(String.format("Duplicate relation type name %s; already defined in %s", sName, aTypeRegistry.get(sName)));
            }
            if (fInitAction != null) {
                fInitAction.execute(this);
            }
            aTypeRegistry.put(sName, this);
        }
    }
}

