/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.expression.Action;
import de.esoco.lib.expression.Function;
import de.esoco.lib.expression.Functions;
import de.esoco.lib.expression.ReflectionFuntions;
import de.esoco.lib.expression.monad.Option;
import de.esoco.lib.reflect.ReflectUtil;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.obrel.core.Annotations;
import org.obrel.core.ObjectRelations;
import org.obrel.core.Relatable;
import org.obrel.core.RelationType;
import org.obrel.core.RelationTypeModifier;
import org.obrel.type.MetaTypes;

public class RelationTypes {
    public static final RelationType<Class<?>> DECLARING_CLASS = new RelationType<Class>("DECLARING_CLASS", Class.class, new RelationTypeModifier[0]);
    public static final RelationType<String> RELATION_TYPE_NAMESPACE = new RelationType<String>("RELATION_TYPE_NAMESPACE", String.class, new RelationTypeModifier[0]);
    public static final RelationType<Action<RelationType<?>>> RELATION_TYPE_INIT_ACTION = new RelationType<Action>("RELATION_TYPE_INIT_ACTION", Action.class, new RelationTypeModifier[0]);
    public static final RelationType<Class<?>> ELEMENT_DATATYPE = new RelationType<Class>("ELEMENT_DATATYPE", Class.class, new RelationTypeModifier[0]);
    public static final RelationType<Class<?>> KEY_DATATYPE = new RelationType<Class>("KEY_DATATYPE", Class.class, new RelationTypeModifier[0]);
    public static final RelationType<Class<?>> VALUE_DATATYPE = new RelationType<Class>("VALUE_DATATYPE", Class.class, new RelationTypeModifier[0]);
    public static final RelationType<List<RelationType<?>>> DECLARED_RELATION_TYPES = RelationTypes.newRelationType("DECLARED_RELATION_TYPES", List.class, RelationTypeModifier.FINAL);

    public static String getRelationTypeNamespace(Class<?> rClass) {
        String sClassNamespace = rClass.isAnnotationPresent(Annotations.RelationTypeNamespace.class) ? rClass.getAnnotation(Annotations.RelationTypeNamespace.class).value() : rClass.getName();
        return sClassNamespace;
    }

    public static void init(Class<?> ... rClasses) {
        for (Class<?> rClass : rClasses) {
            RelationTypes.initRelationTypesOf(rClass);
        }
    }

    private static <T> void initRelationType(RelationType<T> rRelationType, String sName, Type rTargetType) {
        Class<?> rDatatype = ReflectUtil.getRawType(rTargetType);
        if (rTargetType instanceof ParameterizedType) {
            ParameterizedType rType = (ParameterizedType)rTargetType;
            Type[] rElemTypes = rType.getActualTypeArguments();
            if (Collection.class.isAssignableFrom(rDatatype)) {
                rRelationType.set(ELEMENT_DATATYPE, ReflectUtil.getRawType(rElemTypes[0]));
            } else if (Map.class.isAssignableFrom(rDatatype)) {
                rRelationType.set(KEY_DATATYPE, ReflectUtil.getRawType(rElemTypes[0]));
                rRelationType.set(VALUE_DATATYPE, ReflectUtil.getRawType(rElemTypes[1]));
            }
        }
        Action<RelationType<?>> fInitAction = rRelationType.get(RELATION_TYPE_INIT_ACTION);
        rRelationType.deleteRelation(RELATION_TYPE_INIT_ACTION);
        rRelationType.init(sName, rDatatype, fInitAction);
    }

    private static void initRelationTypeField(Field rField, RelationType<?> rRelationType, String sClassNamespace) {
        String sFieldName = rField.getName();
        if (rRelationType == null) {
            throw new IllegalArgumentException("Unitialized relation type " + sFieldName);
        }
        Class<?> rDeclaringClass = rField.getDeclaringClass();
        String sTypeName = rRelationType.getName();
        String sTypeNamespace = rRelationType.get(RELATION_TYPE_NAMESPACE);
        Type rTargetType = ((ParameterizedType)rField.getGenericType()).getActualTypeArguments()[0];
        if (sTypeName == "!INIT") {
            String sName = sTypeNamespace != null ? sTypeNamespace + "." + sFieldName : sClassNamespace + sFieldName;
            RelationTypes.initRelationType(rRelationType, sName, rTargetType);
        } else {
            assert (ReflectUtil.getRawType(rTargetType) == rRelationType.getTargetType()) : String.format("Invalid target type for RelationType %s: %s (expected: %s)", sTypeName, rRelationType.getTargetType(), rField.getType());
            assert (rField.isAnnotationPresent(Annotations.NoRelationNameCheck.class) || sFieldName.equals(rRelationType.getSimpleName())) : String.format("RelationType name mismatch for %s.%s: %s", rDeclaringClass.getName(), sFieldName, sTypeName);
            if (sTypeNamespace != null && !sTypeName.startsWith(sTypeNamespace)) {
                RelationTypes.initRelationType(rRelationType, sTypeNamespace + "." + sFieldName, rTargetType);
            }
        }
        if (!rRelationType.hasRelation(DECLARING_CLASS)) {
            rRelationType.annotate(DECLARING_CLASS, rDeclaringClass);
        }
    }

    public static void initRelationTypesOf(Class<?> rClass) {
        Relatable rClassRelatable;
        List<Field> rFields = ReflectUtil.getAllFields(rClass);
        String sClassNamespace = RelationTypes.getRelationTypeNamespace(rClass);
        ArrayList<RelationType> aDeclaredTypes = new ArrayList<RelationType>();
        if (sClassNamespace.length() > 0) {
            sClassNamespace = sClassNamespace + ".";
        }
        for (Field rField : rFields) {
            try {
                int nModifiers = rField.getModifiers();
                if (!RelationType.class.isAssignableFrom(rField.getType()) || !Modifier.isStatic(nModifiers)) continue;
                rField.setAccessible(true);
                RelationType rRelationType = (RelationType)rField.get(null);
                if (Modifier.isFinal(nModifiers)) {
                    RelationTypes.initRelationTypeField(rField, rRelationType, sClassNamespace);
                    if (rRelationType.hasModifier(RelationTypeModifier.PRIVATE)) continue;
                    aDeclaredTypes.add(rRelationType);
                    continue;
                }
                assert (rRelationType == null || rRelationType.getName() != "!INIT") : "Relation type not final static: " + rField.getName();
            }
            catch (Exception e) {
                String sMessage = String.format("Access to %s.%s failed", rField.getDeclaringClass().getSimpleName(), rField.getName());
                throw new IllegalArgumentException(sMessage, e);
            }
        }
        if (!aDeclaredTypes.isEmpty() && !(rClassRelatable = ObjectRelations.getRelatable(rClass)).hasRelation(DECLARED_RELATION_TYPES)) {
            rClassRelatable.set(DECLARED_RELATION_TYPES, Collections.unmodifiableList(aDeclaredTypes));
        }
    }

    public static RelationType<Boolean> newBooleanType(String sName, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, Boolean.class, Functions.value(Boolean.FALSE), rModifiers);
    }

    public static <T> RelationType<Class<? extends T>> newClassType(String sName, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, Class.class, rModifiers);
    }

    public static RelationType<Date> newDateType(String sName, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, Date.class, rModifiers);
    }

    public static RelationType<BigDecimal> newDecimalType(RelationTypeModifier ... rModifiers) {
        return RelationTypes.newInitialValueType(BigDecimal.ZERO, rModifiers);
    }

    public static <T> RelationType<T> newDefaultValueType(T rDefaultValue, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newDefaultValueType(r -> rDefaultValue, rModifiers);
    }

    public static <T> RelationType<T> newDefaultValueType(Function<? super Relatable, ? super T> fDefaultValue, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newType(fDefaultValue, null, rModifiers);
    }

    public static <E extends Enum<E>> RelationType<E> newEnumType(String sName, Class<E> rEnumType, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, rEnumType, rModifiers);
    }

    public static <E extends Enum<E>> RelationType<E> newEnumType(String sName, E rDefaultValue, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, rDefaultValue.getClass(), Functions.value(rDefaultValue), rModifiers);
    }

    public static RelationType<Boolean> newFlagType(RelationTypeModifier ... rModifiers) {
        return RelationTypes.newInitialValueType(Boolean.FALSE, rModifiers);
    }

    public static <T> RelationType<T> newInitialValueType(T rInitialValue, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newInitialValueType(Functions.value(rInitialValue), rModifiers);
    }

    public static <T> RelationType<T> newInitialValueType(Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newType(fInitialValue, rModifiers);
    }

    public static RelationType<Integer> newIntType(RelationTypeModifier ... rModifiers) {
        return RelationTypes.newInitialValueType(0, rModifiers);
    }

    public static RelationType<Integer> newIntType(int nDefault, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newType(Functions.value(nDefault), rModifiers);
    }

    public static RelationType<Integer> newIntegerType(String sName, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newIntegerType(sName, 0, rModifiers);
    }

    public static RelationType<Integer> newIntegerType(String sName, int nDefault, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, Integer.class, Functions.value(nDefault), rModifiers);
    }

    public static <T> RelationType<List<T>> newListType(RelationTypeModifier ... rModifiers) {
        Class<ArrayList> rListClass = ArrayList.class;
        return RelationTypes.newType(null, ReflectionFuntions.newInstanceOf(rListClass), rModifiers);
    }

    public static <T> RelationType<List<T>> newListType(String sName, Class<? super T> rElementType, RelationTypeModifier ... rModifiers) {
        Class<ArrayList> rListClass = ArrayList.class;
        RelationType<List<Class<? super T>>> aType = RelationTypes.newRelationType(sName, List.class, ReflectionFuntions.newInstanceOf(rListClass), rModifiers);
        if (rElementType != null) {
            aType.set((RelationType<List<Class<? super T>>>)ELEMENT_DATATYPE, (List<Class<? super T>>)((Object)rElementType));
        }
        return aType;
    }

    public static RelationType<Long> newLongType(RelationTypeModifier ... rModifiers) {
        return RelationTypes.newInitialValueType(0L, rModifiers);
    }

    public static <K, V> RelationType<Map<K, V>> newMapType(boolean bOrdered, RelationTypeModifier ... rModifiers) {
        Class rMapClass = bOrdered ? LinkedHashMap.class : HashMap.class;
        Function<Object, LinkedHashMap> fInitialValue = ReflectionFuntions.newInstanceOf(rMapClass);
        RelationType<Map<K, Boolean>> aType = RelationTypes.newType(null, fInitialValue, rModifiers);
        aType.annotate(MetaTypes.ORDERED, bOrdered);
        return aType;
    }

    public static <K, V> RelationType<Map<K, V>> newMapType(String sName, Class<? super K> rKeyType, Class<? super V> rValueType, boolean bInitialValue, boolean bOrdered, RelationTypeModifier ... rModifiers) {
        Function<Object, LinkedHashMap> fInitialValue = null;
        if (bInitialValue) {
            Class rMapClass;
            Class rDefaultValueClass = rMapClass = bOrdered ? LinkedHashMap.class : HashMap.class;
            fInitialValue = ReflectionFuntions.newInstanceOf(rDefaultValueClass);
        }
        RelationType<Map<K, V>> aType = RelationTypes.newRelationType(sName, Map.class, fInitialValue, rModifiers);
        aType.set((RelationType<Map<K, V>>)KEY_DATATYPE, (Map<K, V>)((Object)rKeyType));
        aType.set((RelationType<Map<K, V>>)VALUE_DATATYPE, (Map<K, V>)((Object)rValueType));
        aType.set((RelationType<Map<K, V>>)MetaTypes.ORDERED, (Map<K, V>)bOrdered);
        return aType;
    }

    public static RelationType<Object> newObjectType(String sName, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, Object.class, rModifiers);
    }

    public static <E extends Enum<E>> RelationType<E> newObjectTypeType(RelationTypeModifier ... rModifiers) {
        RelationType aType = RelationTypes.newType(rModifiers);
        return aType.annotate(MetaTypes.OBJECT_TYPE_ATTRIBUTE);
    }

    public static <T> RelationType<Option<T>> newOptionType(RelationTypeModifier ... rModifiers) {
        return RelationTypes.newType((? super Relatable r) -> Option.none(), null, rModifiers);
    }

    public static RelationType<Relatable> newRelatableType(String sName, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, Relatable.class, rModifiers);
    }

    public static <T> RelationType<T> newRelationType(String sName, Class<? super T> rDatatype, RelationTypeModifier ... rFlags) {
        return RelationTypes.newRelationType(sName, rDatatype, null, rFlags);
    }

    public static <T> RelationType<T> newRelationType(String sName, Class<? super T> rDatatype, Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        return new RelationType<T>(sName, rDatatype, fInitialValue, rModifiers);
    }

    public static <T> RelationType<T> newRelationType(String sName, Class<? super T> rDatatype, Function<? super Relatable, ? super T> fDefaultValue, Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        return new RelationType<T>(sName, rDatatype, fDefaultValue, fInitialValue, rModifiers);
    }

    public static <T> RelationType<Set<T>> newSetType(boolean bOrdered, RelationTypeModifier ... rModifiers) {
        Class rSetClass = bOrdered ? LinkedHashSet.class : HashSet.class;
        Function<Object, LinkedHashSet> fInitialValue = ReflectionFuntions.newInstanceOf(rSetClass);
        RelationType<Set<T>> aType = RelationTypes.newType(null, fInitialValue, rModifiers);
        aType.annotate(MetaTypes.ORDERED, bOrdered);
        return aType;
    }

    public static <T> RelationType<Set<T>> newSetType(String sName, Class<? super T> rElementType, boolean bInitialValue, boolean bOrdered, RelationTypeModifier ... rModifiers) {
        Function<Object, LinkedHashSet> fInitialValue = null;
        if (bInitialValue) {
            Class rSetClass;
            Class rDefaultValueClass = rSetClass = bOrdered ? LinkedHashSet.class : HashSet.class;
            fInitialValue = ReflectionFuntions.newInstanceOf(rDefaultValueClass);
        }
        RelationType<Set<Constable>> aType = RelationTypes.newRelationType(sName, Set.class, fInitialValue, rModifiers);
        aType.set((RelationType<Set<Constable>>)ELEMENT_DATATYPE, (Set<Constable>)((Object)rElementType));
        aType.set((RelationType<Set<Constable>>)MetaTypes.ORDERED, (Set<Constable>)bOrdered);
        return aType;
    }

    public static RelationType<String> newStringType(RelationTypeModifier ... rModifiers) {
        return RelationTypes.newStringType(null, rModifiers);
    }

    public static RelationType<String> newStringType(String sName, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newRelationType(sName, String.class, rModifiers);
    }

    public static <T> RelationType<T> newType(RelationTypeModifier ... rModifiers) {
        return RelationTypes.newType(null, null, rModifiers);
    }

    public static <T> RelationType<T> newType(RelationType<Boolean> rFlag, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newType(rModifiers).annotate(rFlag);
    }

    public static <T> RelationType<T> newType(Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        return RelationTypes.newType(null, fInitialValue, rModifiers);
    }

    public static <T> RelationType<T> newType(Function<? super Relatable, ? super T> fDefaultValue, Function<? super Relatable, ? super T> fInitialValue, RelationTypeModifier ... rModifiers) {
        return new RelationType<T>("!INIT", null, fDefaultValue, fInitialValue, rModifiers);
    }
}

