/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.event.ElementEvent;
import de.esoco.lib.event.EventHandler;
import de.esoco.lib.expression.Function;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationEvent;
import org.obrel.core.RelationType;
import org.obrel.type.ListenerTypes;

public abstract class RelationWrapper<T, R, F extends Function<R, T>>
extends Relation<T>
implements EventHandler<RelationEvent<R>> {
    private static final long serialVersionUID = 1L;
    private final Relatable rParent;
    private final Relation<R> rWrappedRelation;
    private final F fTargetConversion;

    RelationWrapper(Relatable rParent, RelationType<T> rType, Relation<R> rWrapped, F fConversion) {
        super(rType);
        this.rParent = rParent;
        this.rWrappedRelation = rWrapped;
        this.fTargetConversion = fConversion;
        this.rWrappedRelation.addUpdateListener(this);
    }

    public final F getConversion() {
        return this.fTargetConversion;
    }

    @Override
    public T getTarget() {
        return (T)this.fTargetConversion.evaluate(this.rWrappedRelation.getTarget());
    }

    public final Relation<R> getWrappedRelation() {
        return this.rWrappedRelation;
    }

    @Override
    public void handleEvent(RelationEvent<R> rEvent) {
        if (rEvent.getType() == ElementEvent.EventType.UPDATE) {
            Object rUpdateValue = this.fTargetConversion.evaluate(rEvent.getUpdateValue());
            RelationEvent rConvertedEvent = new RelationEvent(ElementEvent.EventType.UPDATE, this.rParent, this, rUpdateValue, this);
            this.get(ListenerTypes.RELATION_UPDATE_LISTENERS).dispatch(rConvertedEvent);
        }
    }

    protected final Relatable getParent() {
        return this.rParent;
    }

    @Override
    protected void removed() {
        this.rWrappedRelation.get(ListenerTypes.RELATION_UPDATE_LISTENERS).remove(this);
    }

    @Override
    boolean dataEqual(Relation<?> rOther) {
        return this.rWrappedRelation == ((RelationWrapper)rOther).rWrappedRelation;
    }

    @Override
    int dataHashCode() {
        return this.rWrappedRelation.dataHashCode();
    }

    @Override
    void setTarget(T rNewTarget) {
        throw new UnsupportedOperationException("View relation is readonly: " + this);
    }
}

