/*
 * Decompiled with CFR 0.152.
 */
package org.obrel.core;

import de.esoco.lib.expression.InvertibleFunction;
import org.obrel.core.Relatable;
import org.obrel.core.Relation;
import org.obrel.core.RelationType;

public class TransformedRelation<T, D>
extends Relation<T> {
    private static final long serialVersionUID = 1L;
    private final InvertibleFunction<T, D> fTransformation;
    private D rData;

    public TransformedRelation(RelationType<T> rType, InvertibleFunction<T, D> fTransformation) {
        super(rType);
        this.fTransformation = fTransformation;
    }

    @Override
    public T getTarget() {
        return this.fTransformation.invert(this.rData);
    }

    public final InvertibleFunction<T, D> getTransformation() {
        return this.fTransformation;
    }

    public final D getTransformedTarget() {
        return this.rData;
    }

    @Override
    Relation<T> copyTo(Relatable rTarget) {
        TransformedRelation aCopy = rTarget.transform(this.getType(), this.fTransformation);
        aCopy.rData = this.rData;
        return aCopy;
    }

    @Override
    boolean dataEqual(Relation<?> rOther) {
        TransformedRelation rOtherRelation = (TransformedRelation)rOther;
        boolean bResult = false;
        if (this.fTransformation.equals(rOtherRelation.fTransformation)) {
            bResult = this.rData == null ? rOtherRelation.rData == null : this.rData.equals(rOtherRelation.rData);
        }
        return bResult;
    }

    @Override
    int dataHashCode() {
        return 31 * this.fTransformation.hashCode() + (this.rData != null ? this.rData.hashCode() : 0);
    }

    @Override
    void setTarget(T rNewTarget) {
        this.rData = this.fTransformation.evaluate(rNewTarget);
    }
}

